/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jbpm.services.api.query.QueryParamBuilderFactory;

public class QueryParamBuilderManager {
    private static QueryParamBuilderManager INSTANCE = new QueryParamBuilderManager();
    private ConcurrentMap<String, List<QueryParamBuilderFactory>> factoriesPerContainer = new ConcurrentHashMap<String, List<QueryParamBuilderFactory>>();
    private List<QueryParamBuilderFactory> factories = new CopyOnWriteArrayList<QueryParamBuilderFactory>();

    private QueryParamBuilderManager() {
    }

    public static QueryParamBuilderManager get() {
        return INSTANCE;
    }

    public void discoverAndAddQueryFactories(String containerId, ClassLoader cl) {
        ArrayList<QueryParamBuilderFactory> added = new ArrayList<QueryParamBuilderFactory>();
        ServiceLoader<QueryParamBuilderFactory> availableFactories = ServiceLoader.load(QueryParamBuilderFactory.class, cl);
        for (QueryParamBuilderFactory factory : availableFactories) {
            added.add(factory);
        }
        if (!added.isEmpty()) {
            this.factoriesPerContainer.putIfAbsent(containerId, added);
            this.factories.addAll(added);
        }
    }

    public void removeQueryFactories(String containerId) {
        List removed = (List)this.factoriesPerContainer.remove(containerId);
        if (removed != null && !removed.isEmpty()) {
            this.factories.removeAll(removed);
        }
    }

    public QueryParamBuilderFactory find(String identifier) {
        for (QueryParamBuilderFactory factory : this.factories) {
            if (!factory.accept(identifier)) continue;
            return factory;
        }
        return null;
    }
}

