/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.clock;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

public class ClockUtil {
    public static DateTime toUTCDateTime(LocalDate localDate, LocalTime referenceTime, DateTimeZone dateTimeZone) {
        DateTime targetDateTime;
        try {
            targetDateTime = new DateTime(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), referenceTime.getHourOfDay(), referenceTime.getMinuteOfHour(), referenceTime.getSecondOfMinute(), dateTimeZone);
        }
        catch (IllegalInstantException e) {
            targetDateTime = localDate.toDateTimeAtStartOfDay(dateTimeZone);
        }
        return ClockUtil.toUTCDateTime(targetDateTime);
    }

    public static LocalDate toLocalDate(DateTime dateTime, DateTimeZone dateTimeZone) {
        return new LocalDate((Object)dateTime, dateTimeZone);
    }

    public static DateTime toUTCDateTime(DateTime dateTime) {
        return ClockUtil.toDateTime(dateTime, DateTimeZone.UTC);
    }

    public static DateTime toDateTime(DateTime dateTime, DateTimeZone accountTimeZone) {
        return dateTime.toDateTime(accountTimeZone);
    }
}

