/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.concurrent.LoggingExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicThreadPoolExecutorWithLoggingOnExceptions
extends LoggingExecutor {
    private final int inputSpecifiedCorePoolSize;
    private int currentTasks;

    public DynamicThreadPoolExecutorWithLoggingOnExceptions(int corePoolSize, int maximumPoolSize, String name, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, name, keepAliveTime, unit);
        this.inputSpecifiedCorePoolSize = corePoolSize;
    }

    public DynamicThreadPoolExecutorWithLoggingOnExceptions(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory);
        this.inputSpecifiedCorePoolSize = corePoolSize;
    }

    public DynamicThreadPoolExecutorWithLoggingOnExceptions(int corePoolSize, int maximumPoolSize, String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, name, keepAliveTime, unit, workQueue);
        this.inputSpecifiedCorePoolSize = corePoolSize;
    }

    public DynamicThreadPoolExecutorWithLoggingOnExceptions(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.inputSpecifiedCorePoolSize = corePoolSize;
    }

    public DynamicThreadPoolExecutorWithLoggingOnExceptions(int corePoolSize, int maximumPoolSize, String name, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, name, keepAliveTime, unit, workQueue, handler);
        this.inputSpecifiedCorePoolSize = corePoolSize;
    }

    public DynamicThreadPoolExecutorWithLoggingOnExceptions(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.inputSpecifiedCorePoolSize = corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        DynamicThreadPoolExecutorWithLoggingOnExceptions dynamicThreadPoolExecutorWithLoggingOnExceptions = this;
        synchronized (dynamicThreadPoolExecutorWithLoggingOnExceptions) {
            ++this.currentTasks;
            this.setCorePoolSizeToTaskCountWithinBounds();
        }
        super.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        DynamicThreadPoolExecutorWithLoggingOnExceptions dynamicThreadPoolExecutorWithLoggingOnExceptions = this;
        synchronized (dynamicThreadPoolExecutorWithLoggingOnExceptions) {
            --this.currentTasks;
            this.setCorePoolSizeToTaskCountWithinBounds();
        }
    }

    private void setCorePoolSizeToTaskCountWithinBounds() {
        int updatedCorePoolSize = this.currentTasks;
        if (updatedCorePoolSize < this.inputSpecifiedCorePoolSize) {
            updatedCorePoolSize = this.inputSpecifiedCorePoolSize;
        }
        if (updatedCorePoolSize > this.getMaximumPoolSize()) {
            updatedCorePoolSize = this.getMaximumPoolSize();
        }
        this.setCorePoolSize(updatedCorePoolSize);
    }
}

