/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.mapper;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public abstract class MapperBase {
    protected LocalDate getDate(ResultSet rs, String fieldName) throws SQLException {
        Date resultStamp = rs.getDate(fieldName);
        return rs.wasNull() ? null : new LocalDate((Object)resultStamp, DateTimeZone.UTC);
    }

    protected DateTime getDateTime(ResultSet rs, String fieldName) throws SQLException {
        Timestamp resultStamp = rs.getTimestamp(fieldName);
        return rs.wasNull() ? null : new DateTime((Object)resultStamp).toDateTime(DateTimeZone.UTC);
    }

    protected UUID getUUID(ResultSet resultSet, String fieldName) throws SQLException {
        String result = resultSet.getString(fieldName);
        return result == null ? null : UUID.fromString(result);
    }
}

