/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.template;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.sqlobject.stringtemplate.ST4StatementLocator;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseST4StatementLocator;
import org.skife.jdbi.v2.tweak.StatementLocator;

@SqlStatementCustomizingAnnotation(value=KillBillSqlDaoStringTemplateFactory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface KillBillSqlDaoStringTemplate {
    public static final String DEFAULT_VALUE = " ~ ";

    public String value() default " ~ ";

    public static class KillBillSqlDaoStringTemplateFactory
    extends UseST4StatementLocator.LocatorFactory {
        static final boolean enableGroupTemplateCaching = Boolean.parseBoolean(System.getProperty("org.killbill.jdbi.allow.stringTemplateGroupCaching", "true"));
        static final ConcurrentMap<String, StatementLocator> locatorCache = new ConcurrentHashMap<String, StatementLocator>();
        static final ConcurrentMap<Class, String> locatorPathCache = new ConcurrentHashMap<Class, String>();
        private static final String sep = "/";
        private static final String QUOTE_REPLACEMENT_SEP = Matcher.quoteReplacement("/");

        static String mungify(Class claz) {
            String locatorPath = (String)locatorPathCache.get(claz);
            if (locatorPath != null) {
                return locatorPath;
            }
            String path = sep + claz.getName();
            locatorPath = path.replaceAll("\\.", QUOTE_REPLACEMENT_SEP) + ".sql.stg";
            if (enableGroupTemplateCaching) {
                locatorPathCache.put(claz, locatorPath);
            }
            return locatorPath;
        }

        private StatementLocator getLocator(String locatorPath) {
            StatementLocator locator = (StatementLocator)locatorCache.get(locatorPath);
            if (locator != null) {
                return locator;
            }
            locator = ST4StatementLocator.fromClasspath(ST4StatementLocator.UseSTGroupCache.YES, locatorPath);
            if (enableGroupTemplateCaching) {
                locatorCache.put(locatorPath, locator);
            }
            return locator;
        }

        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            KillBillSqlDaoStringTemplate a = (KillBillSqlDaoStringTemplate)annotation;
            String locatorPath = KillBillSqlDaoStringTemplate.DEFAULT_VALUE.equals(a.value()) ? KillBillSqlDaoStringTemplateFactory.mungify(sqlObjectType) : a.value();
            final StatementLocator l = this.getLocator(locatorPath);
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement statement) {
                    statement.setStatementLocator(l);
                }
            };
        }
    }
}

