/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.skife.jdbi.v2.Cleanable;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionState;
import org.skife.jdbi.v2.tweak.StatementBuilder;

class Cleanables {
    private Cleanables() {
        throw new AssertionError((Object)"do not instantiate");
    }

    static Cleanable forResultSet(ResultSet rs) {
        return new ResultSetCleanable(rs);
    }

    static Cleanable forStatement(Statement stmt) {
        return new StatementCleanable(stmt);
    }

    static Cleanable forHandle(Handle handle, TransactionState state) {
        return new HandleCleanable(handle, state);
    }

    static class StatementBuilderCleanable
    implements Cleanable {
        private final StatementBuilder statementBuilder;
        private final Connection conn;
        private final String sql;
        private final Statement stmt;

        StatementBuilderCleanable(StatementBuilder statementBuilder, Connection conn, String sql, Statement stmt) {
            this.statementBuilder = statementBuilder;
            this.conn = conn;
            this.sql = sql;
            this.stmt = stmt;
        }

        public void cleanup() throws SQLException {
            if (this.statementBuilder != null) {
                this.statementBuilder.close(this.conn, this.sql, this.stmt);
            }
        }
    }

    private static final class HandleCleanable
    implements Cleanable {
        private final Handle handle;
        private final TransactionState state;

        private HandleCleanable(Handle handle, TransactionState state) {
            this.handle = handle;
            this.state = state;
        }

        public void cleanup() throws SQLException {
            if (this.handle != null) {
                if (this.handle.isInTransaction()) {
                    if (this.state == TransactionState.COMMIT) {
                        this.handle.commit();
                    } else {
                        this.handle.rollback();
                    }
                }
                this.handle.close();
            }
        }

        public int hashCode() {
            return this.handle == null ? 0 : this.handle.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            HandleCleanable that = (HandleCleanable)o;
            if (this.handle == null) {
                return that.handle == null;
            }
            return this.handle.equals(that.handle);
        }
    }

    private static final class StatementCleanable
    implements Cleanable {
        private final Statement stmt;

        private StatementCleanable(Statement stmt) {
            this.stmt = stmt;
        }

        public void cleanup() throws SQLException {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }

        public int hashCode() {
            return this.stmt == null ? 0 : this.stmt.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            StatementCleanable that = (StatementCleanable)o;
            if (this.stmt == null) {
                return that.stmt == null;
            }
            return this.stmt.equals(that.stmt);
        }
    }

    private static final class ResultSetCleanable
    implements Cleanable {
        private final ResultSet rs;

        private ResultSetCleanable(ResultSet rs) {
            this.rs = rs;
        }

        public void cleanup() throws SQLException {
            if (this.rs != null) {
                this.rs.close();
            }
        }

        public int hashCode() {
            return this.rs == null ? 0 : this.rs.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ResultSetCleanable that = (ResultSetCleanable)o;
            if (this.rs == null) {
                return that.rs == null;
            }
            return this.rs.equals(that.rs);
        }
    }
}

