/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.skife.jdbi.v2.BuiltInArgumentFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Foreman {
    private final Map<Class<?>, ArgumentFactory> cache = new ConcurrentHashMap();
    private final List<ArgumentFactory> factories = new CopyOnWriteArrayList<ArgumentFactory>();
    private static final ArgumentFactory BUILT_INS = new BuiltInArgumentFactory();

    public Foreman() {
        this.factories.add(BUILT_INS);
    }

    public Foreman(List<ArgumentFactory> factories) {
        this.factories.addAll(factories);
    }

    Argument waffle(Class expectedType, Object it, StatementContext ctx) {
        if (this.cache.containsKey(expectedType)) {
            return this.cache.get(expectedType).build(expectedType, it, ctx);
        }
        ArgumentFactory candidate = null;
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            ArgumentFactory factory = this.factories.get(i);
            if (factory.accepts(expectedType, it, ctx)) {
                this.cache.put(expectedType, factory);
                return factory.build(expectedType, it, ctx);
            }
            if (candidate != null || !factory.accepts(Object.class, it, ctx)) continue;
            candidate = factory;
        }
        if (candidate != null) {
            this.cache.put(Object.class, candidate);
            return candidate.build(Object.class, it, ctx);
        }
        throw new IllegalStateException("Unbindable argument passed: " + String.valueOf(it));
    }

    public void register(ArgumentFactory<?> argumentFactory) {
        this.factories.add(argumentFactory);
    }

    public Foreman createChild() {
        return this;
    }
}

