/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.skife.jdbi.v2.InferredMapperFactory;
import org.skife.jdbi.v2.PrimitivesMapperFactory;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

class MappingRegistry {
    private static final PrimitivesMapperFactory BUILT_IN_MAPPERS = new PrimitivesMapperFactory();
    private final List<ResultSetMapperFactory> factories = new CopyOnWriteArrayList<ResultSetMapperFactory>();
    private final ConcurrentHashMap<Class, ResultSetMapper> cache = new ConcurrentHashMap();

    MappingRegistry(MappingRegistry parent) {
        this.factories.addAll(parent.factories);
        this.cache.putAll(parent.cache);
    }

    public MappingRegistry() {
    }

    public void add(ResultSetMapper mapper) {
        this.add(new InferredMapperFactory(mapper));
    }

    public void add(ResultSetMapperFactory factory) {
        this.factories.add(factory);
        this.cache.clear();
    }

    public ResultSetMapper mapperFor(Class type, StatementContext ctx) {
        Object mapper;
        Boolean bypassCache = Boolean.valueOf(String.valueOf(ctx.getAttribute("bypassMappingRegistryCache")));
        if (this.cache.containsKey(type) && (mapper = this.cache.get(type)) != null) {
            return mapper;
        }
        for (ResultSetMapperFactory factory : this.factories) {
            if (!factory.accepts(type, ctx)) continue;
            ResultSetMapper mapper2 = factory.mapperFor(type, ctx);
            if (!bypassCache.booleanValue()) {
                this.cache.put(type, mapper2);
            }
            return mapper2;
        }
        if (BUILT_IN_MAPPERS.accepts(type, ctx)) {
            mapper = BUILT_IN_MAPPERS.mapperFor(type, ctx);
            this.cache.put(type, (ResultSetMapper)mapper);
            return mapper;
        }
        throw new DBIException("No mapper registered for " + type.getName()){};
    }

    public MappingRegistry createChild() {
        return this;
    }
}

