/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.BigDecimalMapper;
import org.skife.jdbi.v2.util.BooleanMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.skife.jdbi.v2.util.ByteMapper;
import org.skife.jdbi.v2.util.DoubleMapper;
import org.skife.jdbi.v2.util.FloatMapper;
import org.skife.jdbi.v2.util.IntegerMapper;
import org.skife.jdbi.v2.util.LongMapper;
import org.skife.jdbi.v2.util.ShortMapper;
import org.skife.jdbi.v2.util.StringMapper;
import org.skife.jdbi.v2.util.TimestampMapper;
import org.skife.jdbi.v2.util.URLMapper;

public class PrimitivesMapperFactory
implements ResultSetMapperFactory {
    private static final Map<Class, ResultSetMapper> mappers = new HashMap<Class, ResultSetMapper>();

    public boolean accepts(Class type, StatementContext ctx) {
        return mappers.containsKey(type);
    }

    public ResultSetMapper mapperFor(Class type, StatementContext ctx) {
        return mappers.get(type);
    }

    static {
        mappers.put(BigDecimal.class, BigDecimalMapper.FIRST);
        mappers.put(Boolean.class, BooleanMapper.FIRST);
        mappers.put(Boolean.TYPE, BooleanMapper.FIRST);
        mappers.put(byte[].class, ByteArrayMapper.FIRST);
        mappers.put(Short.TYPE, ShortMapper.FIRST);
        mappers.put(Short.class, ShortMapper.FIRST);
        mappers.put(Float.class, FloatMapper.FIRST);
        mappers.put(Float.TYPE, FloatMapper.FIRST);
        mappers.put(Double.class, DoubleMapper.FIRST);
        mappers.put(Double.TYPE, DoubleMapper.FIRST);
        mappers.put(Byte.class, ByteMapper.FIRST);
        mappers.put(Byte.TYPE, ByteMapper.FIRST);
        mappers.put(URL.class, URLMapper.FIRST);
        mappers.put(Integer.TYPE, IntegerMapper.FIRST);
        mappers.put(Integer.class, IntegerMapper.FIRST);
        mappers.put(Long.TYPE, LongMapper.FIRST);
        mappers.put(Long.class, LongMapper.FIRST);
        mappers.put(Timestamp.class, TimestampMapper.FIRST);
        mappers.put(String.class, StringMapper.FIRST);
    }
}

