/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.logging;

import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.logging.FormattedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLog
extends FormattedLog {
    private final Logger logger;
    private final Level level;

    public SLF4JLog() {
        this(LoggerFactory.getLogger((String)DBI.class.getPackage().getName()));
    }

    public SLF4JLog(Logger logger) {
        this(logger, Level.TRACE);
    }

    public SLF4JLog(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    protected boolean isEnabled() {
        return this.level.isEnabled(this.logger);
    }

    protected void log(String msg) {
        this.level.log(this.logger, msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE{

            boolean isEnabled(Logger logger) {
                return logger.isTraceEnabled();
            }

            void log(Logger logger, String msg) {
                logger.trace(msg);
            }
        }
        ,
        DEBUG{

            boolean isEnabled(Logger logger) {
                return logger.isDebugEnabled();
            }

            void log(Logger logger, String msg) {
                logger.debug(msg);
            }
        }
        ,
        INFO{

            boolean isEnabled(Logger logger) {
                return logger.isInfoEnabled();
            }

            void log(Logger logger, String msg) {
                logger.info(msg);
            }
        }
        ,
        WARN{

            boolean isEnabled(Logger logger) {
                return logger.isWarnEnabled();
            }

            void log(Logger logger, String msg) {
                logger.warn(msg);
            }
        }
        ,
        ERROR{

            boolean isEnabled(Logger logger) {
                return logger.isErrorEnabled();
            }

            void log(Logger logger, String msg) {
                logger.error(msg);
            }
        };


        abstract boolean isEnabled(Logger var1);

        abstract void log(Logger var1, String var2);
    }
}

