/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Define {
    public String value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            throw new UnsupportedOperationException("Not allowed on Type");
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            throw new UnsupportedOperationException("Not allowed on Method");
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, final Object arg) {
            Define d = (Define)annotation;
            final String key = d.value();
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement q) {
                    q.define(key, arg);
                }
            };
        }
    }
}

