/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterArgumentFactory {
    public Class<? extends ArgumentFactory>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            return this.create(annotation);
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            return this.create(annotation);
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new IllegalStateException("not allowed on parameter");
        }

        private SqlStatementCustomizer create(Annotation annotation) {
            RegisterArgumentFactory raf = (RegisterArgumentFactory)annotation;
            final ArrayList<ArgumentFactory> ary = new ArrayList<ArgumentFactory>(raf.value().length);
            for (Class<? extends ArgumentFactory> aClass : raf.value()) {
                try {
                    ary.add(aClass.newInstance());
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to instantiate specified argument factory", e);
                }
            }
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement q) throws SQLException {
                    for (ArgumentFactory argumentFactory : ary) {
                        q.registerArgumentFactory(argumentFactory);
                    }
                }
            };
        }
    }
}

