/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.proxy;

import org.mockserver.client.AbstractClient;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;

public class ProxyClient
extends AbstractClient {
    public ProxyClient(String host, int port) {
        this(host, port, "");
    }

    public ProxyClient(String host, int port, String contextPath) {
        super(host, port, contextPath);
    }

    public ProxyClient dumpToLogAsJSON() {
        return this.dumpToLogAsJSON(null);
    }

    public ProxyClient dumpToLogAsJSON(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("dumpToLog")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this;
    }

    public ProxyClient dumpToLogAsJava() {
        return this.dumpToLogAsJava(null);
    }

    public ProxyClient dumpToLogAsJava(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("dumpToLog?type=java")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this;
    }

    public ProxyClient reset() {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return this;
    }

    public ProxyClient stop() {
        try {
            this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
        }
        catch (Exception e) {
            logger.warn("Failed to send stop request to proxy " + e.getMessage());
        }
        return this;
    }

    public ProxyClient clear(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this;
    }

    public ProxyClient verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0 || httpRequests[0] == null) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence))).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public ProxyClient verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = new Verification().withRequest(httpRequest).withTimes(times);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification))).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public Expectation[] retrieveAsExpectations(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString());
    }

    public String retrieveAsJSON(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        return httpResponse.getBodyAsString();
    }
}

