/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.client.ClientException;
import org.mockserver.client.ForwardChainExpectation;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.PortBinding;
import org.mockserver.model.RetrieveType;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient<T extends AbstractClient>
implements Closeable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String host;
    protected final int port;
    protected final String contextPath;
    private final Class<T> clientClass;
    protected NettyHttpClient nettyHttpClient = new NettyHttpClient();
    protected HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    protected PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    protected ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    protected VerificationSerializer verificationSerializer = new VerificationSerializer();
    protected VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    protected AbstractClient(String host, int port, String contextPath, Class<T> clientClass) {
        this.clientClass = clientClass;
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
    }

    protected String calculatePath(String path) {
        String cleanedPath = path;
        if (!Strings.isNullOrEmpty((String)this.contextPath)) {
            cleanedPath = (!this.contextPath.startsWith("/") ? "/" : "") + this.contextPath + (!this.contextPath.endsWith("/") ? "/" : "") + (cleanedPath.startsWith("/") ? cleanedPath.substring(1) : cleanedPath);
        }
        return (!cleanedPath.startsWith("/") ? "/" : "") + cleanedPath;
    }

    protected HttpResponse sendRequest(HttpRequest request) {
        HttpResponse response = this.nettyHttpClient.sendRequest(request.withHeader(HttpHeaderNames.HOST.toString(), new String[]{this.host + ":" + this.port}));
        if (response != null && response.getStatusCode() != null && response.getStatusCode().intValue() == HttpResponseStatus.BAD_REQUEST.code()) {
            throw new IllegalArgumentException(response.getBodyAsString());
        }
        return response;
    }

    protected String formatErrorMessage(String message, Object ... objects) {
        Object[] indentedObjects = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            indentedObjects[i] = Character.NEW_LINE + Character.NEW_LINE + String.valueOf(objects[i]).replaceAll("(?m)^", "\t") + Character.NEW_LINE;
        }
        return String.format(Character.NEW_LINE + message + Character.NEW_LINE, indentedObjects);
    }

    public InetSocketAddress remoteAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String contextPath() {
        return this.contextPath;
    }

    public boolean isRunning() {
        return this.isRunning(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean isRunning(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")));
            if (httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts == 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.isRunning(attempts - 1, timeout, timeUnit);
        }
        catch (SocketConnectionException sce) {
            return false;
        }
    }

    public List<Integer> bind(Integer ... ports) {
        String boundPorts = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("bind")).withBody(this.portBindingSerializer.serialize(PortBinding.portBinding((Integer[])ports)), Charsets.UTF_8)).getBodyAsString();
        return this.portBindingSerializer.deserialize(boundPorts).getPorts();
    }

    public T stop() {
        return this.stop(false);
    }

    public T stop(boolean ignoreFailure) {
        block4: {
            try {
                this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
                if (this.isRunning()) {
                    for (int i = 0; this.isRunning() && i < 50; ++i) {
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                }
            }
            catch (Exception e) {
                if (ignoreFailure) break block4;
                this.logger.warn("Failed to send stop request to MockServer " + e.getMessage());
            }
        }
        return (T)((AbstractClient)this.clientClass.cast(this));
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public T reset() {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return (T)((AbstractClient)this.clientClass.cast(this));
    }

    public T clear(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return (T)((AbstractClient)this.clientClass.cast(this));
    }

    public T clear(HttpRequest httpRequest, ClearType type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return (T)((AbstractClient)this.clientClass.cast(this));
    }

    public T verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0 || httpRequests[0] == null) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return (T)((AbstractClient)this.clientClass.cast(this));
    }

    public T verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = Verification.verification().withRequest(httpRequest).withTimes(times);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return (T)((AbstractClient)this.clientClass.cast(this));
    }

    public T verifyZeroInteractions() throws AssertionError {
        Verification verification = Verification.verification().withRequest(HttpRequest.request()).withTimes(VerificationTimes.exactly((int)0));
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return (T)((AbstractClient)this.clientClass.cast(this));
    }

    public HttpRequest[] retrieveRecordedRequests(HttpRequest httpRequest) {
        String recordedRequests = this.retrieveRecordedRequests(httpRequest, Format.JSON);
        if (StringUtils.isNotEmpty((CharSequence)recordedRequests)) {
            return this.httpRequestSerializer.deserializeArray(recordedRequests);
        }
        return new HttpRequest[0];
    }

    public String retrieveRecordedRequests(HttpRequest httpRequest, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUESTS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public Expectation[] retrieveRecordedExpectations(HttpRequest httpRequest) {
        String recordedExpectations = this.retrieveRecordedExpectations(httpRequest, Format.JSON);
        if (!Strings.isNullOrEmpty((String)recordedExpectations)) {
            return this.expectationSerializer.deserializeArray(recordedExpectations);
        }
        return new Expectation[0];
    }

    public String retrieveRecordedExpectations(HttpRequest httpRequest, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.RECORDED_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String retrieveLogMessages(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.LOGS.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String[] retrieveLogMessagesArray(HttpRequest httpRequest) {
        return this.retrieveLogMessages(httpRequest).split("------------------------------------\n");
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, TimeToLive.unlimited()));
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, timeToLive));
    }

    void sendExpectation(Expectation expectation) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("expectation")).withBody(expectation != null ? this.expectationSerializer.serialize(expectation) : "", Charsets.UTF_8));
        if (httpResponse != null && httpResponse.getStatusCode() != 201) {
            throw new ClientException(this.formatErrorMessage(Character.NEW_LINE + "error:%s" + Character.NEW_LINE + "while submitted expectation:%s", httpResponse.getBody(), expectation));
        }
    }

    public Expectation[] retrieveActiveExpectations(HttpRequest httpRequest) {
        String activeExpectations = this.retrieveActiveExpectations(httpRequest, Format.JSON);
        if (!Strings.isNullOrEmpty((String)activeExpectations)) {
            return this.expectationSerializer.deserializeArray(activeExpectations);
        }
        return new Expectation[0];
    }

    public String retrieveActiveExpectations(HttpRequest httpRequest, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.ACTIVE_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return httpResponse.getBodyAsString();
    }
}

