/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Map;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.SecurityException;
import org.mule.module.spring.security.SpringAuthenticationAdapter;
import org.mule.module.spring.security.SpringAuthenticationProvider;
import org.mule.module.spring.security.SpringSecurityContextFactory;
import org.mule.module.spring.security.UserAndPasswordAuthenticationProvider;
import org.mule.security.AbstractSecurityProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class SpringProviderAdapter
extends AbstractSecurityProvider
implements AuthenticationProvider {
    private AuthenticationManager delegate;
    private Map securityProperties;
    private SpringAuthenticationProvider authenticationProvider;

    public SpringProviderAdapter() {
        super("spring-security");
    }

    public SpringProviderAdapter(AuthenticationManager delegate) {
        this(delegate, "spring-security");
    }

    public SpringProviderAdapter(AuthenticationManager delegate, String name) {
        super(name);
        this.delegate = delegate;
    }

    protected void doInitialise() throws InitialisationException {
        this.setSecurityContextFactory(new SpringSecurityContextFactory());
    }

    public org.mule.api.security.Authentication authenticate(org.mule.api.security.Authentication authentication) throws SecurityException {
        Authentication auth = null;
        auth = authentication instanceof SpringAuthenticationAdapter ? ((SpringAuthenticationAdapter)authentication).getDelegate() : this.getAuthenticationProvider().getAuthentication(authentication);
        auth = this.delegate.authenticate(auth);
        return new SpringAuthenticationAdapter(auth, this.getSecurityProperties());
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.delegate.authenticate(authentication);
    }

    public AuthenticationManager getDelegate() {
        return this.delegate;
    }

    public void setDelegate(AuthenticationManager delegate) {
        this.delegate = delegate;
    }

    public Map getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(Map securityProperties) {
        this.securityProperties = securityProperties;
    }

    public SpringAuthenticationProvider getAuthenticationProvider() {
        if (this.authenticationProvider == null) {
            this.authenticationProvider = new UserAndPasswordAuthenticationProvider();
        }
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(SpringAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }
}

