/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.cdi.Mapper;
import org.mybatis.cdi.MyBatisBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension
implements javax.enterprise.inject.spi.Extension {
    private static final Logger logger = Logger.getLogger(Extension.class.getName());
    private final Set<BeanKey> mappers = new HashSet<BeanKey>();

    public <X> void processInjectionTarget(@Observes ProcessInjectionTarget<X> event) {
        InjectionTarget it = event.getInjectionTarget();
        for (InjectionPoint ip : it.getInjectionPoints()) {
            if (!ip.getAnnotated().isAnnotationPresent(Mapper.class) && !SqlSession.class.equals((Object)ip.getAnnotated().getBaseType())) continue;
            this.mappers.add(new BeanKey((Class)ip.getAnnotated().getBaseType(), ip.getAnnotated().getAnnotations()));
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        logger.log(Level.INFO, "MyBatis CDI Module - Activated");
        for (BeanKey key : this.mappers) {
            logger.log(Level.INFO, "MyBatis CDI Module - Mapper dependency discovered: {0}", key.getKey());
            abd.addBean(key.createBean(bm));
        }
        this.mappers.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BeanKey
    implements Comparable<BeanKey> {
        private final String key;
        private final List<Annotation> qualifiers;
        private final Class<?> type;
        private final String sqlSessionManagerName;

        public BeanKey(Class<?> type, Set<Annotation> annotations) {
            this.type = type;
            this.qualifiers = this.sort(this.filterQualifiers(annotations));
            StringBuilder sb = new StringBuilder();
            String name = null;
            sb.append(type.getName());
            for (Annotation q : this.qualifiers) {
                if (q instanceof Named) {
                    name = ((Named)q).value();
                    continue;
                }
                sb.append(".").append(q.annotationType().getSimpleName());
            }
            if (name != null) {
                sb.append("_").append(name);
            }
            this.key = sb.toString();
            this.sqlSessionManagerName = name;
        }

        private Set<Annotation> filterQualifiers(Set<Annotation> annotations) {
            HashSet<Annotation> set = new HashSet<Annotation>();
            for (Annotation a : annotations) {
                if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                set.add(a);
            }
            return set;
        }

        private List<Annotation> sort(Set<Annotation> annotations) {
            ArrayList<Annotation> list = new ArrayList<Annotation>(annotations);
            Collections.sort(list, new Comparator<Annotation>(){

                @Override
                public int compare(Annotation a, Annotation b) {
                    return a.getClass().getName().compareTo(b.getClass().getName());
                }
            });
            return list;
        }

        @Override
        public int compareTo(BeanKey o) {
            return this.key.compareTo(o.key);
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanKey other = (BeanKey)obj;
            return !(this.key != null ? !this.key.equals(other.key) : other.key != null);
        }

        public Bean createBean(BeanManager bm) {
            return new MyBatisBean(this.type, new HashSet<Annotation>(this.qualifiers), this.sqlSessionManagerName, bm);
        }

        public String getKey() {
            return this.key;
        }
    }
}

