/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.transaction.UserTransaction;
import org.mybatis.cdi.LocalTransactionInterceptor;
import org.mybatis.cdi.Transactional;

@Transactional
@Interceptor
public class JtaTransactionInterceptor
extends LocalTransactionInterceptor {
    @Inject
    private transient UserTransaction userTransaction;

    protected boolean isTransactionActive() throws Exception {
        return this.userTransaction.getStatus() != 6;
    }

    protected void beginJta() throws Exception {
        this.userTransaction.begin();
    }

    protected void endJta(boolean isExternaTransaction, boolean needsRollback) throws Exception {
        if (isExternaTransaction) {
            if (needsRollback) {
                this.userTransaction.setRollbackOnly();
            }
        } else if (needsRollback) {
            this.userTransaction.rollback();
        } else {
            this.userTransaction.commit();
        }
    }
}

