/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.cdi.CDIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyBatisBean
implements Bean {
    private final Class type;
    private final Set<Annotation> qualifiers;
    private final BeanManager beanManager;
    private final String sqlSessionFactoryName;

    public MyBatisBean(Class type, Set<Annotation> qualifiers, String sqlSessionFactoryName, BeanManager beanManager) {
        this.type = type;
        this.sqlSessionFactoryName = sqlSessionFactoryName;
        this.beanManager = beanManager;
        if (qualifiers == null || qualifiers.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
            this.qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        } else {
            this.qualifiers = qualifiers;
        }
    }

    public Set getTypes() {
        HashSet<Class> types = new HashSet<Class>();
        types.add(this.type);
        return types;
    }

    public Set getQualifiers() {
        return this.qualifiers;
    }

    public Class getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set getStereotypes() {
        return Collections.emptySet();
    }

    public Class getBeanClass() {
        return this.type;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Set getInjectionPoints() {
        return Collections.emptySet();
    }

    public Object create(CreationalContext creationalContext) {
        SqlSessionManager manager = this.findSqlSessionManager(creationalContext);
        return SqlSession.class.equals((Object)this.type) ? manager : manager.getMapper(this.type);
    }

    public void destroy(Object instance, CreationalContext creationalContext) {
        creationalContext.release();
    }

    private SqlSessionManager findSqlSessionManager(CreationalContext creationalContext) {
        SqlSessionFactory factory = CDIUtils.findSqlSessionFactory(this.sqlSessionFactoryName, this.qualifiers, this.beanManager, creationalContext);
        return CDIUtils.getRegistry(this.beanManager, creationalContext).getManager(factory);
    }
}

