/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.jceproviders.safenetprotect.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import org.nhindirect.common.crypto.jceproviders.safenetprotect.impl.AbstractWrappableCipher;

public class AES
extends AbstractWrappableCipher {
    protected static final String CLAZZ_NAME = "au.com.safenet.crypto.provider.slot0.AES";

    public AES() {
        try {
            this.internalClazz = this.getClass().getClassLoader().loadClass(CLAZZ_NAME);
            this.internalCipher = (CipherSpi)CipherSpi.class.cast(this.internalClazz.newInstance());
            this.initEngineSession();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to construct AES engine.", e);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            Class<?> mechParamClazz = this.getClass().getClassLoader().loadClass("jprov.cryptoki.MechanismParam");
            Class<?> mechClazz = this.getClass().getClassLoader().loadClass("jprov.cryptoki.Mechanism");
            Constructor<?> mechConst = mechClazz.getConstructor(Integer.TYPE, mechParamClazz);
            Object mech = mechConst.newInstance(4225, null);
            Class<?> cryObjClazz = this.getClass().getClassLoader().loadClass("jprov.cryptoki.CryptokiObject");
            Method wrapKeyMeth = this.localSession.getClass().getMethod("wrapKey", mechClazz, cryObjClazz, cryObjClazz, byte[].class, Integer.TYPE);
            Object wrapper = this.toCrptokiObject(this.cipherKey);
            Object wrappee = this.toCrptokiObject(key);
            int size = (Integer)wrapKeyMeth.invoke(this.localSession, mech, wrapper, wrappee, null, 0);
            byte[] wrapBuffer = new byte[size];
            wrapKeyMeth.invoke(this.localSession, mech, wrapper, wrappee, wrapBuffer, 0);
            return wrapBuffer;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] paramArrayOfByte, String paramString, int paramInt) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            int objectClass;
            switch (paramInt) {
                case 2: {
                    objectClass = 3;
                    break;
                }
                case 3: {
                    objectClass = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Key type " + paramInt + " is not supported.");
                }
            }
            int keyType = paramString.equals("DSA") ? 1 : (paramString.equals("RSA") ? 0 : (paramString.equals("DH") ? 2 : this.getSecretKeyType(paramString)));
            Class<?> mechClazz = this.getClass().getClassLoader().loadClass("jprov.cryptoki.Mechanism");
            Class<?> cryObjClazz = this.getClass().getClassLoader().loadClass("jprov.cryptoki.CryptokiObject");
            Class<?> mechParamClazz = this.getClass().getClassLoader().loadClass("jprov.cryptoki.MechanismParam");
            Constructor<?> mechConst = mechClazz.getConstructor(Integer.TYPE, mechParamClazz);
            Object mech = mechConst.newInstance(4225, null);
            Class<?> attrArrayClass = Class.forName("[Ljprov.cryptoki.Attribute;");
            Method unwrapKeyMeth = this.localSession.getClass().getMethod("unwrapKey", mechClazz, cryObjClazz, byte[].class, Integer.TYPE, Integer.TYPE, attrArrayClass);
            Class<?> attClass = this.getClass().getClassLoader().loadClass("jprov.cryptoki.Attribute");
            Constructor<?> attrConst = attClass.getConstructor(Integer.TYPE, Object.class);
            Object attr1 = attrConst.newInstance(0, objectClass);
            Object attr2 = attrConst.newInstance(256, keyType);
            Object attr3 = attrConst.newInstance(354, Boolean.TRUE);
            Object attr4 = attrConst.newInstance(259, Boolean.TRUE);
            Object attr5 = attrConst.newInstance(268, Boolean.TRUE);
            Object attr = Array.newInstance(attClass, 5);
            Array.set(attr, 0, attr1);
            Array.set(attr, 1, attr2);
            Array.set(attr, 2, attr3);
            Array.set(attr, 3, attr4);
            Array.set(attr, 4, attr5);
            Object wrapper = this.toCrptokiObject(this.cipherKey);
            Object unwrappedKey = unwrapKeyMeth.invoke(this.localSession, mech, wrapper, paramArrayOfByte, 0, paramArrayOfByte.length, attrArrayClass.cast(attr));
            switch (keyType) {
                case 1: {
                    Class<?> dsaClass = this.getClass().getClassLoader().loadClass("au.com.safenet.crypto.provider.DSAPrivKey");
                    Constructor<?> cst = dsaClass.getDeclaredConstructor(cryObjClazz);
                    cst.setAccessible(true);
                    return (Key)cst.newInstance(unwrappedKey);
                }
                case 0: {
                    Class<?> rsaClass = this.getClass().getClassLoader().loadClass("au.com.safenet.crypto.provider.RSAPrivKeyCrt");
                    Constructor<?> cst = rsaClass.getDeclaredConstructor(cryObjClazz);
                    cst.setAccessible(true);
                    return (Key)cst.newInstance(unwrappedKey);
                }
            }
            Class<?> basicSecKeyClass = this.getClass().getClassLoader().loadClass("au.com.safenet.crypto.provider.BasicSecretKey");
            Constructor<?> cst = basicSecKeyClass.getDeclaredConstructor(String.class, cryObjClazz);
            cst.setAccessible(true);
            return (Key)cst.newInstance(paramString, unwrappedKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

