/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.jceproviders.safenetprotect.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractWrappableCipher
extends CipherSpi {
    protected static final String DSA_KEY_CLAZZ_NAME = "au.com.safenet.crypto.provider.DSAPrivKey";
    protected static final String RSA_KEY_CLAZZ_NAME = "au.com.safenet.crypto.provider.RSAPrivKeyCrt";
    protected static final String BASIC_SECRET_KEY_CLAZZ_NAME = "au.com.safenet.crypto.provider.BasicSecretKey";
    protected static final String BASIC_KEY_CLAZZ_NAME = "au.com.safenet.crypto.provider.BasicKey";
    protected static final String CRYPTOKEY_CLAZZ_NAME = "jprov.cryptoki.Cryptoki";
    protected static final String ATTRIBUTE_CLAZZ_NAME = "jprov.cryptoki.Attribute";
    protected static final String MECH_CLAZZ_NAME = "jprov.cryptoki.Mechanism";
    protected static final String MECH_PARAM_CLAZZ_NAME = "jprov.cryptoki.MechanismParam";
    protected static final String CRY_OBJECT_CLAZZ_NAME = "jprov.cryptoki.CryptokiObject";
    protected CipherSpi internalCipher;
    protected Class<?> internalClazz;
    protected int mode;
    protected Key cipherKey;
    protected SecureRandom rand;
    protected AlgorithmParameters algParams;
    protected AlgorithmParameterSpec algSpecs;
    protected Object localSession;

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        Method m = this.safeGetMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        return (Integer)this.safeInvoke(m, input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        Method m = this.safeGetMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE);
        return (byte[])this.safeInvoke(m, input, inputOffset, inputLen);
    }

    @Override
    protected int engineGetBlockSize() {
        Method m = this.safeGetMethod("engineGetBlockSize", new Class[0]);
        return (Integer)this.safeInvoke(m, new Object[0]);
    }

    @Override
    protected byte[] engineGetIV() {
        Method m = this.safeGetMethod("engineGetIV", new Class[0]);
        return (byte[])this.safeInvoke(m, new Object[0]);
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        Method m = this.safeGetMethod("engineGetOutputSize", new Class[0]);
        return (Integer)this.safeInvoke(m, new Object[0]);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        Method m = this.safeGetMethod("engineGetParameters", new Class[0]);
        return (AlgorithmParameters)this.safeInvoke(m, new Object[0]);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opmode == 3 || opmode == 4) {
            this.goWrapMode(opmode, key, random, params, null);
            return;
        }
        Method m = this.safeGetMethod("engineInit", Integer.TYPE, Key.class, AlgorithmParameters.class, SecureRandom.class);
        this.safeInvoke(m, opmode, key, params, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opmode == 3 || opmode == 4) {
            this.goWrapMode(opmode, key, random, null, params);
            return;
        }
        Method m = this.safeGetMethod("engineInit", Integer.TYPE, Key.class, AlgorithmParameterSpec.class, SecureRandom.class);
        this.safeInvoke(m, opmode, key, params, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (opmode == 3 || opmode == 4) {
            this.goWrapMode(opmode, key, random, null, null);
            return;
        }
        Method m = this.safeGetMethod("engineInit", Integer.TYPE, Key.class, SecureRandom.class);
        this.safeInvoke(m, opmode, key, random);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        Method m = this.safeGetMethod("engineSetMode", String.class);
        this.safeInvoke(m, mode);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        Method m = this.safeGetMethod("engineSetPadding", String.class);
        this.safeInvoke(m, padding);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        Method m = this.safeGetMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        return (Integer)this.safeInvoke(m, input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        Method m = this.safeGetMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE);
        return (byte[])this.safeInvoke(m, input, inputOffset, inputLen);
    }

    public void finalize() {
        Method m = this.safeGetMethod("finalize", new Class[0]);
        this.safeInvoke(m, new Object[0]);
        try {
            Method closeSession = this.localSession.getClass().getMethod("closeSession", Integer.TYPE);
            closeSession.invoke(this.localSession, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close HSM session.");
        }
    }

    protected Object toCrptokiObject(Key paramKey) throws KeyStoreException {
        Key basicKey = null;
        try {
            Class<?> basicSecretKeyClazz = this.getClass().getClassLoader().loadClass(BASIC_SECRET_KEY_CLAZZ_NAME);
            Class<?> basicKeyClazz = this.getClass().getClassLoader().loadClass(BASIC_KEY_CLAZZ_NAME);
            if (paramKey instanceof SecretKeySpec) {
                SecretKeySpec localSecretKeySpec = (SecretKeySpec)paramKey;
                Constructor<?> cst = basicSecretKeyClazz.getConstructor(this.localSession.getClass(), String.class, byte[].class);
                basicKey = cst.newInstance(this.localSession, localSecretKeySpec.getAlgorithm(), paramKey.getEncoded());
            } else if (basicKeyClazz.isAssignableFrom(paramKey.getClass())) {
                basicKey = paramKey;
            } else {
                if (paramKey instanceof PrivateKey) {
                    throw new IllegalStateException("Key is not of a recognized type.");
                }
                throw new IllegalStateException("Key is not of a recognized type.");
            }
            Field field = this.safeGetField("key", basicKeyClazz);
            return field.get(basicKey);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get internal CrptokiObject.", e);
        }
    }

    protected void goWrapMode(int mode, Key key, SecureRandom rand, AlgorithmParameters algParams, AlgorithmParameterSpec algSpecs) {
        this.mode = mode;
        this.cipherKey = key;
        this.rand = rand;
        this.algParams = algParams;
        this.algSpecs = algSpecs;
    }

    protected void initEngineSession() {
        try {
            Class<?> crptClass = this.getClass().getClassLoader().loadClass(CRYPTOKEY_CLAZZ_NAME);
            Method getSlot = crptClass.getMethod("getSlot", Integer.TYPE);
            Object slot = getSlot.invoke(null, 0);
            Method openSession = slot.getClass().getMethod("openSession", Integer.TYPE);
            this.localSession = openSession.invoke(slot, 2);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get internal engine session.", e);
        }
    }

    protected Field safeGetField(String fieldName, Class<?> clazz) {
        Field f = null;
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                f = c.getDeclaredField(fieldName);
                if (f == null) continue;
                f.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (f == null) {
            throw new IllegalStateException("Can't find field " + fieldName + " in class " + clazz.getName());
        }
        return f;
    }

    protected Method safeGetMethod(String methodName, Class<?> ... params) {
        Method m = null;
        for (Class<?> c = this.internalClazz; c != null; c = c.getSuperclass()) {
            try {
                Method method = m = params != null && params.length > 0 ? c.getDeclaredMethod(methodName, params) : c.getDeclaredMethod(methodName, new Class[0]);
                if (m == null) continue;
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (m == null) {
            throw new IllegalStateException("Can't find method " + methodName);
        }
        return m;
    }

    protected Object safeInvoke(Method m, Object ... params) {
        try {
            m.setAccessible(true);
            return m.invoke((Object)this.internalCipher, params);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected int getSecretKeyType(String paramString) {
        if (paramString.equals("CAST")) {
            return 22;
        }
        if (paramString.equals("CAST128")) {
            return 24;
        }
        if (paramString.equals("DES")) {
            return 19;
        }
        if (paramString.equals("DESede") || paramString.equals("DESedeX919")) {
            return 21;
        }
        if (paramString.equals("IDEA")) {
            return 26;
        }
        if (paramString.equals("RC2")) {
            return 17;
        }
        if (paramString.equals("RC4")) {
            return 18;
        }
        if (paramString.equals("RC5")) {
            return 25;
        }
        if (paramString.equals("AES")) {
            return 31;
        }
        if (paramString.equals("HMAC")) {
            return 16;
        }
        throw new IllegalArgumentException("Unsupported key type: " + paramString);
    }
}

