/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.config.yaml.PropertiesJson;
import org.noear.solon.config.yaml.PropertiesYaml;
import org.noear.solon.core.PropsLoader;
import org.noear.solon.core.util.LogUtil;

public class PropsLoaderExt
extends PropsLoader {
    public boolean isSupport(String suffix) {
        if (suffix == null) {
            return false;
        }
        return suffix.endsWith(".properties") || suffix.endsWith(".yml");
    }

    public Properties load(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        String fileName = url.toString();
        if (fileName.endsWith(".properties")) {
            if (Solon.app() != null && Solon.cfg().isDebugMode()) {
                LogUtil.global().trace(fileName);
            }
            Properties tmp = new Properties();
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), Solon.encoding());){
                tmp.load(reader);
            }
            return tmp;
        }
        if (fileName.endsWith(".yml")) {
            if (Solon.app() != null && Solon.cfg().isDebugMode()) {
                LogUtil.global().trace(fileName);
            }
            PropertiesYaml tmp = new PropertiesYaml();
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), Solon.encoding());){
                tmp.loadYml(reader);
            }
            return tmp;
        }
        throw new RuntimeException("This profile is not supported: " + fileName);
    }

    public Properties build(String text) throws IOException {
        text = text.trim();
        int idx1 = text.indexOf("=");
        int idx2 = text.indexOf(":");
        if (text.startsWith("{") && text.endsWith("}")) {
            PropertiesJson tmp = new PropertiesJson();
            tmp.loadJson(text);
            return tmp;
        }
        if (text.startsWith("[") && text.endsWith("]")) {
            PropertiesJson tmp = new PropertiesJson();
            tmp.loadJson(text);
            return tmp;
        }
        if (idx1 > 0 && (idx1 < idx2 || idx2 < 0)) {
            Properties tmp = new Properties();
            tmp.load(new StringReader(text));
            return tmp;
        }
        if (idx2 > 0 && (idx2 < idx1 || idx1 < 0)) {
            PropertiesYaml tmp = new PropertiesYaml();
            tmp.loadYml(new StringReader(text));
            return tmp;
        }
        return new Properties();
    }
}

