/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.codahale.metrics.health.HealthCheck;
import java.io.IOException;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogHealthCheck
extends HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogHealthCheck.class);
    private final UserRepository userRepository;

    public CatalogHealthCheck(Jdbi jdbi) {
        CollectionDAO repo = (CollectionDAO)jdbi.onDemand(CollectionDAO.class);
        this.userRepository = new UserRepository(repo);
    }

    protected HealthCheck.Result check() {
        try {
            ListFilter filter = new ListFilter();
            this.userRepository.listAfter(null, EntityUtil.Fields.EMPTY_FIELDS, filter, 1, null);
            return HealthCheck.Result.healthy();
        }
        catch (IOException e) {
            LOG.error("Health check error {}", (Object)e.getMessage());
            return HealthCheck.Result.unhealthy((String)e.getMessage());
        }
    }
}

