/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.health.conf.HealthConfiguration;
import io.dropwizard.health.core.HealthCheckBundle;
import io.dropwizard.jdbi3.JdbiFactory;
import io.dropwizard.jersey.errors.EarlyEofExceptionMapper;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import io.github.maksymdolgykh.dropwizard.micrometer.MicrometerBundle;
import io.github.maksymdolgykh.dropwizard.micrometer.MicrometerHttpFilter;
import io.github.maksymdolgykh.dropwizard.micrometer.MicrometerJdbiTimingCollector;
import io.socket.engineio.server.EngineIoServerOptions;
import io.socket.engineio.server.JettyWebSocketHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TimingCollector;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.service.JsonPatchProvider;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.OpenMetadataServerHealthCheck;
import org.openmetadata.service.elasticsearch.ElasticSearchEventPublisher;
import org.openmetadata.service.events.EventFilter;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.exception.CatalogGenericExceptionMapper;
import org.openmetadata.service.exception.ConstraintViolationExceptionMapper;
import org.openmetadata.service.exception.JsonMappingExceptionMapper;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareAnnotationSqlLocator;
import org.openmetadata.service.migration.Migration;
import org.openmetadata.service.migration.MigrationConfiguration;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.resources.search.SearchResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.SecretsManagerMigrationService;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.NoopAuthorizer;
import org.openmetadata.service.security.NoopFilter;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.socket.FeedServlet;
import org.openmetadata.service.socket.SocketAddressFilter;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.ConfigurationHolder;
import org.openmetadata.service.util.EmailUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataApplication
extends Application<OpenMetadataApplicationConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadataApplication.class);
    private Authorizer authorizer;

    public void run(OpenMetadataApplicationConfig catalogConfig, Environment environment) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, IOException {
        ConfigurationHolder.getInstance().init(catalogConfig);
        EmailUtil.EmailUtilBuilder.build(catalogConfig.getSmtpSettings());
        Jdbi jdbi = this.createAndSetupJDBI(environment, catalogConfig.getDataSourceFactory());
        SecretsManager secretsManager = SecretsManagerFactory.createSecretsManager(catalogConfig.getSecretsManagerConfiguration(), catalogConfig.getClusterName());
        Fernet.getInstance().setFernetKey(catalogConfig);
        JWTTokenGenerator.getInstance().init(catalogConfig.getJwtTokenConfiguration());
        ((SqlObjects)jdbi.getConfig(SqlObjects.class)).setSqlLocator((SqlLocator)new ConnectionAwareAnnotationSqlLocator(catalogConfig.getDataSourceFactory().getDriverClass()));
        this.validateMigrations(jdbi, catalogConfig.getMigrationConfiguration());
        this.registerAuthorizer(catalogConfig, environment);
        ((DefaultServerFactory)catalogConfig.getServerFactory()).setRegisterDefaultExceptionMappers(Boolean.valueOf(false));
        environment.jersey().property("jersey.config.server.response.setStatusOverSendError", (Object)true);
        environment.jersey().register(MultiPartFeature.class);
        environment.jersey().register(CatalogGenericExceptionMapper.class);
        environment.jersey().register((Object)new ConstraintViolationExceptionMapper());
        environment.jersey().register((Object)new LoggingExceptionMapper<Throwable>(){});
        environment.jersey().register((Object)new JsonProcessingExceptionMapper(true));
        environment.jersey().register((Object)new EarlyEofExceptionMapper());
        environment.jersey().register(JsonMappingExceptionMapper.class);
        environment.healthChecks().register("OpenMetadataServerHealthCheck", (HealthCheck)new OpenMetadataServerHealthCheck());
        EventPubSub.start();
        this.registerResources(catalogConfig, environment, jdbi, secretsManager);
        this.registerEventFilter(catalogConfig, environment, jdbi);
        environment.lifecycle().manage((Managed)new ManagedShutdown());
        this.registerEventPublisher(catalogConfig, jdbi);
        new SecretsManagerMigrationService(secretsManager, catalogConfig.getClusterName()).migrateServicesToSecretManagerIfNeeded();
        this.authorizer.init(catalogConfig, jdbi);
        FilterRegistration.Dynamic micrometerFilter = environment.servlets().addFilter("MicrometerHttpFilter", (Filter)new MicrometerHttpFilter());
        micrometerFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        this.intializeWebsockets(catalogConfig, environment);
    }

    private Jdbi createAndSetupJDBI(Environment environment, DataSourceFactory dbFactory) {
        Jdbi jdbi = new JdbiFactory().build(environment, (PooledDataSourceFactory)dbFactory, "database");
        jdbi.setTimingCollector((TimingCollector)new MicrometerJdbiTimingCollector());
        SqlLogger sqlLogger = new SqlLogger(){

            public void logAfterExecution(StatementContext context) {
                LOG.debug("sql {}, parameters {}, timeTaken {} ms", new Object[]{context.getRenderedSql(), context.getBinding(), context.getElapsedTime(ChronoUnit.MILLIS)});
            }
        };
        if (LOG.isDebugEnabled()) {
            jdbi.setSqlLogger(sqlLogger);
        }
        ((SqlObjects)jdbi.getConfig(SqlObjects.class)).setSqlLocator((SqlLocator)new ConnectionAwareAnnotationSqlLocator(dbFactory.getDriverClass()));
        return jdbi;
    }

    public void initialize(Bootstrap<OpenMetadataApplicationConfig> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StringSubstitutor)new EnvironmentVariableSubstitutor(false)));
        bootstrap.addBundle((ConfiguredBundle)new SwaggerBundle<OpenMetadataApplicationConfig>(){

            protected SwaggerBundleConfiguration getSwaggerBundleConfiguration(OpenMetadataApplicationConfig catalogConfig) {
                return catalogConfig.getSwaggerBundleConfig();
            }
        });
        bootstrap.addBundle((ConfiguredBundle)new AssetsBundle("/assets", "/", "index.html", "static"));
        bootstrap.addBundle((ConfiguredBundle)new HealthCheckBundle<OpenMetadataApplicationConfig>(){

            protected HealthConfiguration getHealthConfiguration(OpenMetadataApplicationConfig configuration) {
                return configuration.getHealthConfiguration();
            }
        });
        bootstrap.addBundle((ConfiguredBundle)new MicrometerBundle());
        super.initialize(bootstrap);
    }

    private void validateMigrations(Jdbi jdbi, MigrationConfiguration conf) throws IOException {
        LOG.info("Validating Flyway migrations");
        Optional<String> lastMigrated = Migration.lastMigrated(jdbi);
        String maxMigration = Migration.lastMigrationFile(conf);
        if (lastMigrated.isEmpty()) {
            throw new IllegalStateException("Could not validate Flyway migrations in the database. Make sure you have run `./bootstrap/bootstrap_storage.sh migrate-all` at least once.");
        }
        if (lastMigrated.get().compareTo(maxMigration) < 0) {
            throw new IllegalStateException("There are pending migrations to be run on the database. Please backup your data and run `./bootstrap/bootstrap_storage.sh migrate-all`. You can find more information on upgrading OpenMetadata at https://docs.open-metadata.org/deployment/upgrade ");
        }
    }

    private void registerAuthorizer(OpenMetadataApplicationConfig catalogConfig, Environment environment) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        AuthorizerConfiguration authorizerConf = catalogConfig.getAuthorizerConfiguration();
        AuthenticationConfiguration authenticationConfiguration = catalogConfig.getAuthenticationConfiguration();
        if (authorizerConf != null) {
            this.authorizer = Class.forName(authorizerConf.getClassName()).asSubclass(Authorizer.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            String filterClazzName = authorizerConf.getContainerRequestFilter();
            if (!StringUtils.isEmpty((CharSequence)filterClazzName)) {
                ContainerRequestFilter filter = Class.forName(filterClazzName).asSubclass(ContainerRequestFilter.class).getConstructor(AuthenticationConfiguration.class, AuthorizerConfiguration.class).newInstance(authenticationConfiguration, authorizerConf);
                LOG.info("Registering ContainerRequestFilter: {}", (Object)filter.getClass().getCanonicalName());
                environment.jersey().register((Object)filter);
            }
        } else {
            LOG.info("Authorizer config not set, setting noop authorizer");
            this.authorizer = new NoopAuthorizer();
            NoopFilter filter = new NoopFilter(authenticationConfiguration, null);
            environment.jersey().register((Object)filter);
        }
    }

    private void registerEventFilter(OpenMetadataApplicationConfig catalogConfig, Environment environment, Jdbi jdbi) {
        if (catalogConfig.getEventHandlerConfiguration() != null) {
            EventFilter eventFilter = new EventFilter(catalogConfig, jdbi);
            environment.jersey().register((Object)eventFilter);
        }
    }

    private void registerEventPublisher(OpenMetadataApplicationConfig openMetadataApplicationConfig, Jdbi jdbi) {
        if (openMetadataApplicationConfig.getElasticSearchConfiguration() != null) {
            ElasticSearchEventPublisher elasticSearchEventPublisher = new ElasticSearchEventPublisher(openMetadataApplicationConfig.getElasticSearchConfiguration(), (CollectionDAO)jdbi.onDemand(CollectionDAO.class));
            EventPubSub.addEventHandler(elasticSearchEventPublisher);
        }
    }

    private void registerResources(OpenMetadataApplicationConfig config, Environment environment, Jdbi jdbi, SecretsManager secretsManager) {
        CollectionRegistry.getInstance().registerResources(jdbi, environment, config, this.authorizer, secretsManager);
        if (config.getElasticSearchConfiguration() != null) {
            environment.jersey().register((Object)new SearchResource(config.getElasticSearchConfiguration()));
        }
        environment.jersey().register((Object)new JsonPatchProvider());
        ErrorPageErrorHandler eph = new ErrorPageErrorHandler();
        eph.addErrorPage(Response.Status.NOT_FOUND.getStatusCode(), "/");
        environment.getApplicationContext().setErrorHandler((ErrorHandler)eph);
    }

    private void intializeWebsockets(OpenMetadataApplicationConfig catalogConfig, Environment environment) {
        String pathSpec = "/api/v1/push/feed/*";
        SocketAddressFilter socketAddressFilter = catalogConfig.getAuthorizerConfiguration() != null ? new SocketAddressFilter(catalogConfig.getAuthenticationConfiguration(), catalogConfig.getAuthorizerConfiguration()) : new SocketAddressFilter();
        EngineIoServerOptions eioOptions = EngineIoServerOptions.newFromDefault();
        eioOptions.setAllowedCorsOrigins(null);
        WebSocketManager.WebSocketManagerBuilder.build(eioOptions);
        environment.getApplicationContext().setContextPath("/");
        environment.getApplicationContext().addFilter(new FilterHolder((Filter)socketAddressFilter), pathSpec, EnumSet.of(DispatcherType.REQUEST));
        environment.getApplicationContext().addServlet(new ServletHolder((Servlet)new FeedServlet()), pathSpec);
        try {
            WebSocketUpgradeFilter webSocketUpgradeFilter = WebSocketUpgradeFilter.configureContext((ServletContextHandler)environment.getApplicationContext());
            webSocketUpgradeFilter.addMapping((PathSpec)new ServletPathSpec(pathSpec), (servletUpgradeRequest, servletUpgradeResponse) -> new JettyWebSocketHandler(WebSocketManager.getInstance().getEngineIoServer()));
        }
        catch (ServletException ex) {
            LOG.error("Websocket Upgrade Filter error : " + ex.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        OpenMetadataApplication OpenMetadataApplication2 = new OpenMetadataApplication();
        OpenMetadataApplication2.run(args);
    }

    public static class ManagedShutdown
    implements Managed {
        public void start() {
            LOG.info("Starting the application");
        }

        public void stop() throws InterruptedException {
            EventPubSub.shutdown();
            LOG.info("Stopping the application");
        }
    }
}

