/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.elasticsearch.DashboardIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.GlossaryTermIndex;
import org.openmetadata.service.elasticsearch.MlModelIndex;
import org.openmetadata.service.elasticsearch.PipelineIndex;
import org.openmetadata.service.elasticsearch.TableIndex;
import org.openmetadata.service.elasticsearch.TagIndex;
import org.openmetadata.service.elasticsearch.TeamIndex;
import org.openmetadata.service.elasticsearch.TopicIndex;
import org.openmetadata.service.elasticsearch.UserIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchIndexFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchIndexFactory.class);

    private ElasticSearchIndexFactory() {
    }

    public static ElasticSearchIndex buildIndex(String entityType, EntityInterface entity) {
        switch (entityType) {
            case "table": {
                return new TableIndex((Table)entity);
            }
            case "dashboard": {
                return new DashboardIndex((Dashboard)entity);
            }
            case "topic": {
                return new TopicIndex((Topic)entity);
            }
            case "pipeline": {
                return new PipelineIndex((Pipeline)entity);
            }
            case "user": {
                return new UserIndex((User)entity);
            }
            case "team": {
                return new TeamIndex((Team)entity);
            }
            case "glossaryTerm": {
                return new GlossaryTermIndex((GlossaryTerm)entity);
            }
            case "mlmodel": {
                return new MlModelIndex((MlModel)entity);
            }
            case "tag": {
                return new TagIndex((Tag)entity);
            }
        }
        LOG.warn("Ignoring Entity Type {}", (Object)entityType);
        return null;
    }
}

