/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.filter.FilterRegistry;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.FilterUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeEventHandler.class);
    private CollectionDAO dao;
    private FeedRepository feedDao;
    private ObjectMapper mapper;

    @Override
    public void init(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        this.dao = (CollectionDAO)jdbi.onDemand(CollectionDAO.class);
        this.feedDao = new FeedRepository(this.dao);
        this.mapper = new ObjectMapper();
    }

    @Override
    public Void process(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        block9: {
            String method = requestContext.getMethod();
            SecurityContext securityContext = requestContext.getSecurityContext();
            String loggedInUserName = securityContext.getUserPrincipal().getName();
            try {
                boolean filterEnabled;
                this.handleWebSocket(responseContext);
                ChangeEvent changeEvent = this.getChangeEvent(method, responseContext);
                if (changeEvent == null) {
                    return null;
                }
                LOG.info("Recording change event {}:{}:{}:{}", new Object[]{changeEvent.getTimestamp(), changeEvent.getEntityId(), changeEvent.getEventType(), changeEvent.getEntityType()});
                EventPubSub.publish(changeEvent);
                if (changeEvent.getEntity() != null) {
                    Object entity = changeEvent.getEntity();
                    changeEvent = ChangeEventHandler.copyChangeEvent(changeEvent);
                    changeEvent.setEntity((Object)JsonUtils.pojoToMaskedJson(entity));
                }
                this.dao.changeEventDAO().insert(JsonUtils.pojoToJson(changeEvent));
                if (!Entity.shouldDisplayEntityChangeOnFeed(changeEvent.getEntityType()) || !(filterEnabled = FilterUtil.shouldProcessRequest(changeEvent, FilterRegistry.getAllFilters()))) break block9;
                for (Thread thread : CommonUtil.listOrEmpty(this.getThreads(responseContext, loggedInUserName))) {
                    EntityReference owner;
                    EntityInterface entity;
                    if (thread.getMessage() == null || thread.getMessage().isEmpty()) continue;
                    if (responseContext.getEntity() instanceof ChangeEvent) {
                        ChangeEvent change = (ChangeEvent)responseContext.getEntity();
                        entity = (EntityInterface)change.getEntity();
                    } else {
                        entity = (EntityInterface)responseContext.getEntity();
                    }
                    EntityReference entityReference = entity.getEntityReference();
                    try {
                        owner = Entity.getOwner(entityReference);
                    }
                    catch (Exception exception) {
                        owner = null;
                    }
                    MessageParser.EntityLink about = MessageParser.EntityLink.parse(thread.getAbout());
                    this.feedDao.create(thread, entity.getId(), owner, about);
                    String jsonThread = this.mapper.writeValueAsString((Object)thread);
                    WebSocketManager.getInstance().broadCastMessageToAll("activityFeed", jsonThread);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to capture change event for method {} due to ", (Object)method, (Object)e);
            }
        }
        return null;
    }

    private void handleWebSocket(ContainerResponseContext responseContext) {
        int responseCode = responseContext.getStatus();
        if (responseCode == Response.Status.CREATED.getStatusCode() && responseContext.getEntity() != null && responseContext.getEntity().getClass().equals(Thread.class)) {
            Thread thread = (Thread)responseContext.getEntity();
            try {
                String jsonThread = this.mapper.writeValueAsString((Object)thread);
                switch (thread.getType()) {
                    case Task: {
                        if (thread.getPostsCount() != 0) break;
                        List assignees = thread.getTask().getAssignees();
                        assignees.forEach(e -> {
                            if ("user".equals(e.getType())) {
                                WebSocketManager.getInstance().sendToOne(e.getId(), "taskChannel", jsonThread);
                            } else if ("team".equals(e.getType())) {
                                List<CollectionDAO.EntityRelationshipRecord> records = this.dao.relationshipDAO().findTo(e.getId().toString(), "team", Relationship.HAS.ordinal(), "user");
                                WebSocketManager.getInstance().sendToManyWithString(records, "taskChannel", jsonThread);
                            }
                        });
                        break;
                    }
                    case Conversation: {
                        List<MessageParser.EntityLink> mentions;
                        WebSocketManager.getInstance().broadCastMessageToAll("activityFeed", jsonThread);
                        if (thread.getPostsCount() == 0) {
                            mentions = MessageParser.getEntityLinks(thread.getMessage());
                        } else {
                            Post latestPost = (Post)thread.getPosts().get(thread.getPostsCount() - 1);
                            mentions = MessageParser.getEntityLinks(latestPost.getMessage());
                        }
                        mentions.forEach(entityLink -> {
                            String fqn = entityLink.getEntityFQN();
                            if ("user".equals(entityLink.getEntityType())) {
                                User user = (User)this.dao.userDAO().findEntityByName(fqn);
                                WebSocketManager.getInstance().sendToOne(user.getId(), "mentionChannel", jsonThread);
                            } else if ("team".equals(entityLink.getEntityType())) {
                                Team team = (Team)this.dao.teamDAO().findEntityByName(fqn);
                                List<CollectionDAO.EntityRelationshipRecord> records = this.dao.relationshipDAO().findTo(team.getId().toString(), "team", Relationship.HAS.ordinal(), "user");
                                WebSocketManager.getInstance().sendToManyWithString(records, "mentionChannel", jsonThread);
                            }
                        });
                        break;
                    }
                    case Announcement: {
                        AnnouncementDetails announcementDetails = thread.getAnnouncement();
                        Long currentTimestamp = Instant.now().getEpochSecond();
                        if (announcementDetails.getStartTime() > currentTimestamp || currentTimestamp > announcementDetails.getEndTime()) break;
                        WebSocketManager.getInstance().broadCastMessageToAll("announcementChannel", jsonThread);
                    }
                }
            }
            catch (JsonProcessingException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public ChangeEvent getChangeEvent(String method, ContainerResponseContext responseContext) {
        if (method.equals("GET")) {
            return null;
        }
        if (responseContext.getEntity() == null) {
            return null;
        }
        int responseCode = responseContext.getStatus();
        String changeType = responseContext.getHeaderString("X-OpenMetadata-Change");
        if (responseCode == Response.Status.CREATED.getStatusCode() && !"entityFieldsChanged".equals(changeType) && !responseContext.getEntity().getClass().equals(Thread.class)) {
            EntityInterface entityInterface = (EntityInterface)responseContext.getEntity();
            EntityReference entityReference = entityInterface.getEntityReference();
            String entityType = entityReference.getType();
            String entityFQN = entityReference.getFullyQualifiedName();
            return ChangeEventHandler.getChangeEvent(EventType.ENTITY_CREATED, entityType, entityInterface).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityFQN);
        }
        if (changeType == null || "entityNoChange".equals(changeType)) {
            return null;
        }
        if (changeType.equals("entityUpdated") || changeType.equals("entitySoftDeleted")) {
            EntityInterface entityInterface = (EntityInterface)responseContext.getEntity();
            EntityReference entityReference = entityInterface.getEntityReference();
            String entityType = entityReference.getType();
            String entityFQN = entityReference.getFullyQualifiedName();
            EventType eventType = "entityUpdated".equals(changeType) ? EventType.ENTITY_UPDATED : EventType.ENTITY_SOFT_DELETED;
            return ChangeEventHandler.getChangeEvent(eventType, entityType, entityInterface).withPreviousVersion(entityInterface.getChangeDescription().getPreviousVersion()).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityFQN);
        }
        if (changeType.equals("entityFieldsChanged")) {
            return (ChangeEvent)responseContext.getEntity();
        }
        if (changeType.equals("entityDeleted")) {
            EntityInterface entityInterface = (EntityInterface)responseContext.getEntity();
            EntityReference entityReference = entityInterface.getEntityReference();
            String entityType = entityReference.getType();
            String entityFQN = entityReference.getFullyQualifiedName();
            return ChangeEventHandler.getChangeEvent(EventType.ENTITY_DELETED, entityType, entityInterface).withPreviousVersion(entityInterface.getVersion()).withEntity((Object)entityInterface).withEntityFullyQualifiedName(entityFQN);
        }
        return null;
    }

    private static ChangeEvent getChangeEvent(EventType eventType, String entityType, EntityInterface entityInterface) {
        return new ChangeEvent().withEventType(eventType).withEntityId(entityInterface.getId()).withEntityType(entityType).withUserName(entityInterface.getUpdatedBy()).withTimestamp(entityInterface.getUpdatedAt()).withChangeDescription(entityInterface.getChangeDescription()).withCurrentVersion(entityInterface.getVersion());
    }

    private static ChangeEvent copyChangeEvent(ChangeEvent changeEvent) {
        return new ChangeEvent().withEventType(changeEvent.getEventType()).withEntityId(changeEvent.getEntityId()).withEntityType(changeEvent.getEntityType()).withUserName(changeEvent.getUserName()).withTimestamp(changeEvent.getTimestamp()).withChangeDescription(changeEvent.getChangeDescription()).withCurrentVersion(changeEvent.getCurrentVersion());
    }

    private List<Thread> getThreads(ContainerResponseContext responseContext, String loggedInUserName) {
        Object entity = responseContext.getEntity();
        String changeType = responseContext.getHeaderString("X-OpenMetadata-Change");
        if (entity == null) {
            return Collections.emptyList();
        }
        if (entity instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)entity;
            EntityInterface realEntity = (EntityInterface)changeEvent.getEntity();
            if (realEntity != null) {
                return this.getThreads(realEntity, changeEvent.getChangeDescription(), loggedInUserName);
            }
            return Collections.emptyList();
        }
        EntityInterface entityInterface = (EntityInterface)entity;
        if ("entityDeleted".equals(changeType)) {
            String entityType = Entity.getEntityTypeFromClass(entity.getClass());
            String message = String.format("Deleted **%s**: `%s`", entityType, entityInterface.getFullyQualifiedName());
            MessageParser.EntityLink about = new MessageParser.EntityLink(entityType, entityInterface.getFullyQualifiedName(), null, null, null);
            Thread thread = new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withCreatedBy(entityInterface.getUpdatedBy()).withAbout(about.getLinkString()).withReactions(Collections.emptyList()).withUpdatedBy(entityInterface.getUpdatedBy()).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withMessage(message);
            return List.of(thread);
        }
        if (entityInterface.getChangeDescription() == null) {
            return Collections.emptyList();
        }
        return this.getThreads(entityInterface, entityInterface.getChangeDescription(), loggedInUserName);
    }

    private List<Thread> getThreads(EntityInterface entity, ChangeDescription changeDescription, String loggedInUserName) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessages(ChangeEventParser.PUBLISH_TO.FEED, changeDescription, entity);
        for (MessageParser.EntityLink link : messages.keySet()) {
            threads.add(this.getThread(link.getLinkString(), messages.get(link), loggedInUserName));
        }
        return threads;
    }

    private Thread getThread(String linkString, String message, String loggedInUserName) {
        return new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withCreatedBy(loggedInUserName).withAbout(linkString).withReactions(Collections.emptyList()).withUpdatedBy(loggedInUserName).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withMessage(message);
    }

    @Override
    public void close() {
    }
}

