/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openmetadata.schema.filter.EventFilter;
import org.openmetadata.schema.filter.Filters;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.util.FilterUtil;

public class FilterRegistry {
    private static final ConcurrentHashMap<String, Map<EventType, Filters>> FILTERS_MAP = new ConcurrentHashMap();

    private FilterRegistry() {
    }

    public static void add(List<EventFilter> f) {
        if (f != null) {
            f.forEach(entityFilter -> {
                String entityType = entityFilter.getEntityType();
                HashMap eventFilterMap = new HashMap();
                if (entityFilter.getFilters() != null) {
                    entityFilter.getFilters().forEach(eventFilter -> eventFilterMap.put(eventFilter.getEventType(), eventFilter));
                }
                FILTERS_MAP.put(entityType, eventFilterMap);
            });
        }
    }

    public static List<Map<EventType, Filters>> listAllFilters() {
        ArrayList<Map<EventType, Filters>> filterList = new ArrayList<Map<EventType, Filters>>();
        FILTERS_MAP.forEach((key, value) -> filterList.add((Map<EventType, Filters>)value));
        return filterList;
    }

    public static List<String> listAllEntitiesHavingFilter() {
        return List.copyOf(FILTERS_MAP.keySet());
    }

    public static Map<EventType, Filters> getFilterForEntity(String key) {
        return FILTERS_MAP.get(key);
    }

    public static Map<String, Map<EventType, Filters>> getAllFilters() throws IOException {
        Settings settings = SettingsCache.getInstance().getEventFilters();
        FilterRegistry.add(FilterUtil.getEventFilterFromSettings(settings));
        return FILTERS_MAP;
    }
}

