/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.BotType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.util.EntityUtil;

public class BotRepository
extends EntityRepository<Bot> {
    static final String BOT_UPDATE_FIELDS = "botUser";
    final SecretsManager secretsManager;

    public BotRepository(CollectionDAO dao, SecretsManager secretsManager) {
        super("/v1/bots/", "bot", Bot.class, dao.botDAO(), dao, "", BOT_UPDATE_FIELDS);
        this.secretsManager = secretsManager;
    }

    @Override
    public Bot setFields(Bot entity, EntityUtil.Fields fields) throws IOException {
        return entity.withBotUser(this.getBotUser(entity));
    }

    @Override
    public void prepare(Bot entity) throws IOException {
        this.setFullyQualifiedName(entity);
        User user = (User)this.daoCollection.userDAO().findEntityById(entity.getBotUser().getId(), Include.ALL);
        entity.getBotUser().withName(user.getName()).withDisplayName(user.getDisplayName());
    }

    @Override
    public void storeEntity(Bot entity, boolean update) throws IOException {
        EntityReference botUser = entity.getBotUser();
        entity.withBotUser(null);
        this.store(entity.getId(), entity, update);
        if (!BotType.BOT.equals((Object)entity.getBotType())) {
            this.secretsManager.encryptOrDecryptBotCredentials(entity.getBotType().value(), botUser.getName(), true);
        }
        entity.withBotUser(botUser);
    }

    @Override
    public void storeRelationships(Bot entity) {
        this.addRelationship(entity.getId(), entity.getBotUser().getId(), "bot", "user", Relationship.CONTAINS);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Bot original, Bot updated, EntityRepository.Operation operation) {
        return new BotUpdater(original, updated, operation);
    }

    @Override
    public void restorePatchAttributes(Bot original, Bot updated) {
        updated.withBotUser(original.getBotUser());
    }

    public EntityReference getBotUser(Bot bot) throws IOException {
        return this.getToEntityRef(bot.getId(), Relationship.CONTAINS, "user", false);
    }

    public class BotUpdater
    extends EntityRepository.EntityUpdater {
        public BotUpdater(Bot original, Bot updated, EntityRepository.Operation operation) {
            super((EntityRepository)BotRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateUser((Bot)this.original, (Bot)this.updated);
            if (((Bot)this.original).getBotType() != null) {
                ((Bot)this.updated).setBotType(((Bot)this.original).getBotType());
            }
        }

        private void updateUser(Bot original, Bot updated) throws IOException {
            BotRepository.this.deleteTo(original.getBotUser().getId(), "user", Relationship.CONTAINS, "bot");
            BotRepository.this.addRelationship(updated.getId(), updated.getBotUser().getId(), "bot", "user", Relationship.CONTAINS);
            if (original.getBotUser() == null || updated.getBotUser() == null || !updated.getBotUser().getId().equals(original.getBotUser().getId())) {
                this.recordChange(BotRepository.BOT_UPDATE_FIELDS, original.getBotUser(), updated.getBotUser());
            }
        }
    }
}

