/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.TypeRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityRepository<T extends EntityInterface> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityRepository.class);
    private final String collectionPath;
    private final Class<T> entityClass;
    protected final String entityType;
    public final EntityDAO<T> dao;
    protected final CollectionDAO daoCollection;
    protected final List<String> allowedFields;
    public final boolean supportsSoftDelete;
    protected final boolean supportsTags;
    protected final boolean supportsOwner;
    protected final boolean supportsFollower;
    private final EntityUtil.Fields patchFields;
    protected final EntityUtil.Fields putFields;

    EntityRepository(String collectionPath, String entityType, Class<T> entityClass, EntityDAO<T> entityDAO, CollectionDAO collectionDAO, String patchFields, String putFields) {
        this.collectionPath = collectionPath;
        this.entityClass = entityClass;
        this.allowedFields = Entity.getEntityFields(entityClass);
        this.dao = entityDAO;
        this.daoCollection = collectionDAO;
        this.patchFields = this.getFields(patchFields);
        this.putFields = this.getFields(putFields);
        this.entityType = entityType;
        this.supportsTags = this.allowedFields.contains("tags");
        this.supportsOwner = this.allowedFields.contains("owner");
        this.supportsSoftDelete = this.allowedFields.contains("deleted");
        this.supportsFollower = this.allowedFields.contains("followers");
        Entity.registerEntity(entityClass, entityType, this.dao, this);
    }

    public abstract T setFields(T var1, EntityUtil.Fields var2) throws IOException;

    public abstract void prepare(T var1) throws IOException;

    public abstract void storeEntity(T var1, boolean var2) throws IOException;

    public abstract void storeRelationships(T var1) throws IOException;

    public void restorePatchAttributes(T original, T updated) {
    }

    public void setFullyQualifiedName(T entity) {
        entity.setFullyQualifiedName(entity.getName());
    }

    public void initSeedDataFromResources() throws IOException {
        List<String> jsonDataFiles = EntityUtil.getJsonDataResources(String.format(".*json/data/%s/.*\\.json$", this.entityType));
        jsonDataFiles.forEach(jsonDataFile -> {
            try {
                String json = CommonUtil.getResourceAsStream((ClassLoader)this.getClass().getClassLoader(), (String)jsonDataFile);
                this.initSeedData((EntityInterface)JsonUtils.readValue(json, this.entityClass));
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize the {} from file {}", new Object[]{this.entityType, jsonDataFile, e});
            }
        });
    }

    @Transaction
    public void initSeedData(T entity) throws IOException {
        String existingJson = this.dao.findJsonByFqn(entity.getFullyQualifiedName(), Include.ALL);
        if (existingJson != null) {
            LOG.info("{} {} is already initialized", (Object)this.entityType, (Object)entity.getFullyQualifiedName());
            return;
        }
        LOG.info("{} {} is not initialized", (Object)this.entityType, (Object)entity.getFullyQualifiedName());
        entity.setUpdatedBy("admin");
        entity.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        entity.setId(UUID.randomUUID());
        this.create(null, entity);
        LOG.info("Created a new {} {}", (Object)this.entityType, (Object)entity.getFullyQualifiedName());
    }

    public EntityUpdater getUpdater(T original, T updated, Operation operation) {
        return new EntityUpdater(this, original, updated, operation);
    }

    @Transaction
    public final T get(UriInfo uriInfo, UUID id, EntityUtil.Fields fields) throws IOException {
        return this.get(uriInfo, id, fields, Include.NON_DELETED);
    }

    @Transaction
    public final T get(UriInfo uriInfo, UUID id, EntityUtil.Fields fields, Include include) throws IOException {
        return this.withHref(uriInfo, this.setFieldsInternal(this.dao.findEntityById(id, include), fields));
    }

    @Transaction
    public final T getByName(UriInfo uriInfo, String fqn, EntityUtil.Fields fields) throws IOException {
        return this.getByName(uriInfo, fqn, fields, Include.NON_DELETED);
    }

    @Transaction
    public final T getByName(UriInfo uriInfo, String fqn, EntityUtil.Fields fields, Include include) throws IOException {
        return this.withHref(uriInfo, this.setFieldsInternal(this.dao.findEntityByName(fqn, include), fields));
    }

    @Transaction
    public final ResultList<T> listAfter(UriInfo uriInfo, EntityUtil.Fields fields, ListFilter filter, int limitParam, String after) throws IOException {
        int total = this.dao.listCount(filter);
        ArrayList<EntityInterface> entities = new ArrayList<EntityInterface>();
        if (limitParam > 0) {
            String beforeCursor;
            List<String> jsons = this.dao.listAfter(filter, limitParam + 1, after == null ? "" : RestUtil.decodeCursor(after));
            for (String json : jsons) {
                EntityInterface entity = this.withHref(uriInfo, this.setFieldsInternal((EntityInterface)JsonUtils.readValue(json, this.entityClass), fields));
                entities.add(entity);
            }
            String afterCursor = null;
            String string = beforeCursor = after == null ? null : ((EntityInterface)entities.get(0)).getFullyQualifiedName();
            if (entities.size() > limitParam) {
                entities.remove(limitParam);
                afterCursor = ((EntityInterface)entities.get(limitParam - 1)).getFullyQualifiedName();
            }
            return this.getResultList(entities, beforeCursor, afterCursor, total);
        }
        return this.getResultList(entities, null, null, total);
    }

    @Transaction
    public final ResultList<T> listBefore(UriInfo uriInfo, EntityUtil.Fields fields, ListFilter filter, int limitParam, String before) throws IOException {
        List<String> jsons = this.dao.listBefore(filter, limitParam + 1, RestUtil.decodeCursor(before));
        ArrayList<EntityInterface> entities = new ArrayList<EntityInterface>();
        for (String json : jsons) {
            EntityInterface entity = this.withHref(uriInfo, this.setFieldsInternal((EntityInterface)JsonUtils.readValue(json, this.entityClass), fields));
            entities.add(entity);
        }
        int total = this.dao.listCount(filter);
        String beforeCursor = null;
        if (entities.size() > limitParam) {
            entities.remove(0);
            beforeCursor = ((EntityInterface)entities.get(0)).getFullyQualifiedName();
        }
        String afterCursor = ((EntityInterface)entities.get(entities.size() - 1)).getFullyQualifiedName();
        return this.getResultList(entities, beforeCursor, afterCursor, total);
    }

    @Transaction
    public T getVersion(UUID id, String version) throws IOException {
        Double requestedVersion = Double.parseDouble(version);
        String extension = EntityUtil.getVersionExtension(this.entityType, requestedVersion);
        String json = this.daoCollection.entityExtensionDAO().getExtension(id.toString(), extension);
        if (json != null) {
            return (T)((EntityInterface)JsonUtils.readValue(json, this.entityClass));
        }
        T entity = this.setFieldsInternal(this.dao.findEntityById(id, Include.ALL), this.putFields);
        if (entity.getVersion().equals(requestedVersion)) {
            return entity;
        }
        throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityVersionNotFound(this.entityType, id, requestedVersion));
    }

    @Transaction
    public EntityHistory listVersions(UUID id) throws IOException {
        T latest = this.setFieldsInternal(this.dao.findEntityById(id, Include.ALL), this.putFields);
        String extensionPrefix = EntityUtil.getVersionExtensionPrefix(this.entityType);
        List<CollectionDAO.ExtensionRecord> records = this.daoCollection.entityExtensionDAO().getExtensions(id.toString(), extensionPrefix);
        ArrayList<CollectionDAO.EntityVersionPair> oldVersions = new ArrayList<CollectionDAO.EntityVersionPair>();
        records.forEach(r -> oldVersions.add(new CollectionDAO.EntityVersionPair((CollectionDAO.ExtensionRecord)r)));
        oldVersions.sort(EntityUtil.compareVersion.reversed());
        ArrayList<String> allVersions = new ArrayList<String>();
        allVersions.add(JsonUtils.pojoToJson(latest));
        oldVersions.forEach(version -> allVersions.add(version.getEntityJson()));
        return new EntityHistory().withEntityType(this.entityType).withVersions(allVersions);
    }

    public final T create(UriInfo uriInfo, T entity) throws IOException {
        entity = this.withHref(uriInfo, this.createInternal(entity));
        this.postCreate(entity);
        return entity;
    }

    @Transaction
    public final T createInternal(T entity) throws IOException {
        this.prepareInternal(entity);
        return this.createNewEntity(entity);
    }

    private void prepareInternal(T entity) throws IOException {
        this.prepare(entity);
        this.validateExtension(entity);
    }

    T setFieldsInternal(T entity, EntityUtil.Fields fields) throws IOException {
        entity.setOwner(fields.contains("owner") ? this.getOwner(entity) : null);
        entity.setTags(fields.contains("tags") ? this.getTags(entity.getFullyQualifiedName()) : null);
        entity.setExtension(fields.contains("extension") ? this.getExtension(entity) : null);
        this.setFields(entity, fields);
        return entity;
    }

    @Transaction
    public final RestUtil.PutResponse<T> createOrUpdate(UriInfo uriInfo, T original, T updated) throws IOException {
        this.prepareInternal(updated);
        original = (EntityInterface)JsonUtils.readValue(this.dao.findJsonByFqn(original.getFullyQualifiedName(), Include.ALL), this.entityClass);
        if (original == null) {
            return new RestUtil.PutResponse<T>(Response.Status.CREATED, this.withHref(uriInfo, this.createNewEntity(updated)), "entityCreated");
        }
        return this.update(uriInfo, original, updated);
    }

    public final RestUtil.PutResponse<T> createOrUpdate(UriInfo uriInfo, T updated) throws IOException {
        RestUtil.PutResponse<T> response = this.createOrUpdateInternal(uriInfo, updated);
        if (response.getStatus() == Response.Status.CREATED) {
            this.postCreate((EntityInterface)response.getEntity());
        } else if (response.getStatus() == Response.Status.OK) {
            this.postUpdate((EntityInterface)response.getEntity());
        }
        return response;
    }

    @Transaction
    public final RestUtil.PutResponse<T> createOrUpdateInternal(UriInfo uriInfo, T updated) throws IOException {
        EntityInterface original = (EntityInterface)JsonUtils.readValue(this.dao.findJsonByFqn(updated.getFullyQualifiedName(), Include.ALL), this.entityClass);
        if (original == null) {
            return new RestUtil.PutResponse<T>(Response.Status.CREATED, this.withHref(uriInfo, this.createNewEntity(updated)), "entityCreated");
        }
        return this.update(uriInfo, original, updated);
    }

    protected void postCreate(T entity) {
    }

    protected void postUpdate(T entity) {
    }

    @Transaction
    public RestUtil.PutResponse<T> update(UriInfo uriInfo, T original, T updated) throws IOException {
        this.setFieldsInternal(original, this.putFields);
        if (Boolean.TRUE.equals(original.getDeleted())) {
            this.restoreEntity(updated.getUpdatedBy(), this.entityType, original.getId());
        }
        EntityUpdater entityUpdater = this.getUpdater(original, updated, Operation.PUT);
        entityUpdater.update();
        String change = entityUpdater.fieldsChanged() ? "entityUpdated" : "entityNoChange";
        return new RestUtil.PutResponse<T>(Response.Status.OK, this.withHref(uriInfo, updated), change);
    }

    @Transaction
    public final RestUtil.PatchResponse<T> patch(UriInfo uriInfo, UUID id, String user, JsonPatch patch) throws IOException {
        T original = this.setFieldsInternal(this.dao.findEntityById(id), this.patchFields);
        EntityInterface updated = (EntityInterface)JsonUtils.applyPatch(original, patch, this.entityClass);
        updated.setUpdatedBy(user);
        updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        this.prepareInternal(updated);
        this.populateOwner(updated.getOwner());
        this.restorePatchAttributes(original, updated);
        EntityUpdater entityUpdater = this.getUpdater(original, updated, Operation.PATCH);
        entityUpdater.update();
        String change = entityUpdater.fieldsChanged() ? "entityUpdated" : "entityNoChange";
        return new RestUtil.PatchResponse<EntityInterface>(Response.Status.OK, this.withHref(uriInfo, updated), change);
    }

    @Transaction
    public RestUtil.PutResponse<T> addFollower(String updatedBy, UUID entityId, UUID userId) throws IOException {
        T entity = this.dao.findEntityById(entityId);
        User user = (User)this.daoCollection.userDAO().findEntityById(userId);
        if (Boolean.TRUE.equals(user.getDeleted())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.deletedUser(userId));
        }
        this.addRelationship(userId, entityId, "user", this.entityType, Relationship.FOLLOWS);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(entity.getVersion());
        EntityUtil.fieldAdded(change, "followers", List.of(user.getEntityReference()));
        ChangeEvent changeEvent = new ChangeEvent().withEntity(entity).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(this.entityType).withEntityId(entityId).withEntityFullyQualifiedName(entity.getFullyQualifiedName()).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(entity.getVersion()).withPreviousVersion(change.getPreviousVersion());
        return new RestUtil.PutResponse(Response.Status.OK, changeEvent, "entityFieldsChanged");
    }

    public final RestUtil.DeleteResponse<T> delete(String updatedBy, UUID id, boolean recursive, boolean hardDelete) throws IOException {
        RestUtil.DeleteResponse<T> response = this.deleteInternal(updatedBy, id, recursive, hardDelete);
        this.postDelete((EntityInterface)response.getEntity());
        return response;
    }

    public final RestUtil.DeleteResponse<T> deleteByName(String updatedBy, String name, boolean recursive, boolean hardDelete) throws IOException {
        RestUtil.DeleteResponse<T> response = this.deleteInternalByName(updatedBy, name, recursive, hardDelete);
        this.postDelete((EntityInterface)response.getEntity());
        return response;
    }

    protected void preDelete(T entity) {
    }

    protected void postDelete(T entity) {
    }

    private RestUtil.DeleteResponse<T> delete(String updatedBy, String json, UUID id, boolean recursive, boolean hardDelete) throws IOException {
        String changeType;
        EntityInterface original = (EntityInterface)JsonUtils.readValue(json, this.entityClass);
        this.preDelete(original);
        this.setFieldsInternal(original, this.putFields);
        this.deleteChildren(id, recursive, hardDelete, updatedBy);
        EntityInterface updated = (EntityInterface)JsonUtils.readValue(json, this.entityClass);
        this.setFieldsInternal(updated, this.putFields);
        if (this.supportsSoftDelete && !hardDelete) {
            updated.setUpdatedBy(updatedBy);
            updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            updated.setDeleted(Boolean.valueOf(true));
            EntityUpdater updater = this.getUpdater(original, updated, Operation.SOFT_DELETE);
            updater.update();
            changeType = "entitySoftDeleted";
        } else {
            this.cleanup(updated);
            changeType = "entityDeleted";
        }
        LOG.info("{} deleted {}", (Object)(hardDelete ? "Hard" : "Soft"), (Object)updated.getFullyQualifiedName());
        return new RestUtil.DeleteResponse<EntityInterface>(updated, changeType);
    }

    @Transaction
    public final RestUtil.DeleteResponse<T> deleteInternalByName(String updatedBy, String name, boolean recursive, boolean hardDelete) throws IOException {
        String json = this.dao.findJsonByFqn(name, Include.ALL);
        if (json == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(this.entityType, name));
        }
        UUID id = ((EntityInterface)JsonUtils.readValue(json, this.entityClass)).getId();
        return this.delete(updatedBy, json, id, recursive, hardDelete);
    }

    @Transaction
    public final RestUtil.DeleteResponse<T> deleteInternal(String updatedBy, UUID id, boolean recursive, boolean hardDelete) throws IOException {
        String json = this.dao.findJsonById(id, Include.ALL);
        if (json == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(this.entityType, id));
        }
        return this.delete(updatedBy, json, id, recursive, hardDelete);
    }

    private void deleteChildren(UUID id, boolean recursive, boolean hardDelete, String updatedBy) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.daoCollection.relationshipDAO().findTo(id.toString(), this.entityType, List.of(Integer.valueOf(Relationship.CONTAINS.ordinal()), Integer.valueOf(Relationship.PARENT_OF.ordinal())));
        if (records.isEmpty()) {
            return;
        }
        if (!recursive) {
            throw new IllegalArgumentException(CatalogExceptionMessage.entityIsNotEmpty(this.entityType));
        }
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            LOG.info("Recursively {} deleting {} {}", new Object[]{hardDelete ? "hard" : "soft", entityRelationshipRecord.getType(), entityRelationshipRecord.getId()});
            Entity.deleteEntity(updatedBy, entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), true, hardDelete);
        }
    }

    protected void cleanup(T entityInterface) throws IOException {
        String id = entityInterface.getId().toString();
        this.daoCollection.relationshipDAO().deleteAll(id, this.entityType);
        this.daoCollection.fieldRelationshipDAO().deleteAllByPrefix(entityInterface.getFullyQualifiedName());
        this.daoCollection.entityExtensionDAO().deleteAll(id);
        this.daoCollection.tagUsageDAO().deleteTagLabelsByTargetPrefix(entityInterface.getFullyQualifiedName());
        this.daoCollection.usageDAO().delete(id);
        this.removeExtension((EntityInterface)entityInterface);
        this.dao.delete(id);
    }

    @Transaction
    public RestUtil.PutResponse<T> deleteFollower(String updatedBy, UUID entityId, UUID userId) throws IOException {
        T entity = this.dao.findEntityById(entityId);
        User user = (User)this.daoCollection.userDAO().findEntityById(userId);
        this.deleteRelationship(userId, "user", entityId, this.entityType, Relationship.FOLLOWS);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(entity.getVersion());
        EntityUtil.fieldDeleted(change, "followers", List.of(user.getEntityReference()));
        ChangeEvent changeEvent = new ChangeEvent().withEntity(entity).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityFullyQualifiedName(entity.getFullyQualifiedName()).withEntityType(this.entityType).withEntityId(entityId).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(entity.getVersion()).withPreviousVersion(change.getPreviousVersion());
        return new RestUtil.PutResponse(Response.Status.OK, changeEvent, "entityFieldsChanged");
    }

    public final ResultList<T> getResultList(List<T> entities, String beforeCursor, String afterCursor, int total) {
        return new ResultList<T>(entities, beforeCursor, afterCursor, total);
    }

    private T createNewEntity(T entity) throws IOException {
        this.storeEntity(entity, false);
        this.storeExtension((EntityInterface)entity);
        this.storeRelationships(entity);
        return entity;
    }

    protected void store(UUID id, T entity, boolean update) throws JsonProcessingException {
        if (update) {
            this.dao.update(id, JsonUtils.pojoToJson(entity));
        } else {
            this.dao.insert((EntityInterface)entity);
        }
    }

    public void validateExtension(T entity) {
        if (entity.getExtension() == null) {
            return;
        }
        JsonNode jsonNode = JsonUtils.valueToTree(entity.getExtension());
        Iterator customFields = jsonNode.fields();
        while (customFields.hasNext()) {
            Map.Entry entry = (Map.Entry)customFields.next();
            String fieldName = (String)entry.getKey();
            JsonNode fieldValue = (JsonNode)entry.getValue();
            JsonSchema jsonSchema = TypeRegistry.instance().getSchema(this.entityType, fieldName);
            if (jsonSchema == null) {
                throw new IllegalArgumentException(CatalogExceptionMessage.unknownCustomField(fieldName));
            }
            Set validationMessages = jsonSchema.validate(fieldValue);
            if (validationMessages.isEmpty()) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.jsonValidationError(fieldName, validationMessages.toString()));
        }
    }

    public void storeExtension(EntityInterface entity) throws JsonProcessingException {
        JsonNode jsonNode = JsonUtils.valueToTree(entity.getExtension());
        Iterator customFields = jsonNode.fields();
        while (customFields.hasNext()) {
            Map.Entry entry = (Map.Entry)customFields.next();
            String fieldName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            this.storeCustomProperty(entity, fieldName, value);
        }
    }

    public void removeExtension(EntityInterface entity) {
        JsonNode jsonNode = JsonUtils.valueToTree(entity.getExtension());
        Iterator customFields = jsonNode.fields();
        while (customFields.hasNext()) {
            Map.Entry entry = (Map.Entry)customFields.next();
            this.removeCustomProperty(entity, (String)entry.getKey());
        }
    }

    private void storeCustomProperty(EntityInterface entity, String fieldName, JsonNode value) throws JsonProcessingException {
        String fieldFQN = TypeRegistry.getCustomPropertyFQN(this.entityType, fieldName);
        this.daoCollection.entityExtensionDAO().insert(entity.getId().toString(), fieldFQN, "customFieldSchema", JsonUtils.pojoToJson(value));
    }

    private void removeCustomProperty(EntityInterface entity, String fieldName) {
        String fieldFQN = TypeRegistry.getCustomPropertyFQN(this.entityType, fieldName);
        this.daoCollection.entityExtensionDAO().delete(entity.getId().toString(), fieldFQN);
    }

    public ObjectNode getExtension(T entity) throws JsonProcessingException {
        String fieldFQNPrefix = TypeRegistry.getCustomPropertyFQNPrefix(this.entityType);
        List<CollectionDAO.ExtensionRecord> records = this.daoCollection.entityExtensionDAO().getExtensions(entity.getId().toString(), fieldFQNPrefix);
        if (records.isEmpty()) {
            return null;
        }
        ObjectNode objectNode = JsonUtils.getObjectNode();
        for (CollectionDAO.ExtensionRecord extensionRecord : records) {
            String fieldName = TypeRegistry.getPropertyName(extensionRecord.getExtensionName());
            objectNode.set(fieldName, JsonUtils.readTree(extensionRecord.getExtensionJson()));
        }
        return objectNode;
    }

    public final List<TagLabel> addDerivedTags(List<TagLabel> tagLabels) {
        if (CommonUtil.nullOrEmpty(tagLabels)) {
            return tagLabels;
        }
        ArrayList<TagLabel> updatedTagLabels = new ArrayList<TagLabel>();
        EntityUtil.mergeTags(updatedTagLabels, tagLabels);
        for (TagLabel tagLabel : tagLabels) {
            EntityUtil.mergeTags(updatedTagLabels, this.getDerivedTags(tagLabel));
        }
        updatedTagLabels.sort(EntityUtil.compareTagLabel);
        return updatedTagLabels;
    }

    private List<TagLabel> getDerivedTags(TagLabel tagLabel) {
        if (tagLabel.getSource() == TagLabel.TagSource.GLOSSARY) {
            List<TagLabel> derivedTags = this.daoCollection.tagUsageDAO().getTags(tagLabel.getTagFQN());
            derivedTags.forEach(tag -> tag.setLabelType(TagLabel.LabelType.DERIVED));
            return derivedTags;
        }
        return Collections.emptyList();
    }

    protected void applyTags(T entity) {
        if (this.supportsTags) {
            this.applyTags(entity.getTags(), entity.getFullyQualifiedName());
        }
    }

    public void applyTags(List<TagLabel> tagLabels, String targetFQN) {
        for (TagLabel tagLabel : CommonUtil.listOrEmpty(tagLabels)) {
            if (tagLabel.getSource() == TagLabel.TagSource.TAG) {
                Tag tag = (Tag)this.daoCollection.tagDAO().findEntityByName(tagLabel.getTagFQN());
                tagLabel.withDescription(tag.getDescription());
                tagLabel.setSource(TagLabel.TagSource.TAG);
            } else if (tagLabel.getSource() == TagLabel.TagSource.GLOSSARY) {
                GlossaryTerm term = (GlossaryTerm)this.daoCollection.glossaryTermDAO().findEntityByName(tagLabel.getTagFQN(), Include.NON_DELETED);
                tagLabel.withDescription(term.getDescription());
                tagLabel.setSource(TagLabel.TagSource.GLOSSARY);
            }
            this.daoCollection.tagUsageDAO().applyTag(tagLabel.getSource().ordinal(), tagLabel.getTagFQN(), targetFQN, tagLabel.getLabelType().ordinal(), tagLabel.getState().ordinal());
        }
    }

    protected List<TagLabel> getTags(String fqn) {
        return !this.supportsTags ? null : this.daoCollection.tagUsageDAO().getTags(fqn);
    }

    protected List<EntityReference> getFollowers(T entity) throws IOException {
        if (!this.supportsFollower || entity == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference> followers = new ArrayList<EntityReference>();
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(entity.getId(), this.entityType, Relationship.FOLLOWS, "user");
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            followers.add(this.daoCollection.userDAO().findEntityReferenceById(entityRelationshipRecord.getId(), Include.ALL));
        }
        return followers;
    }

    public T withHref(UriInfo uriInfo, T entity) {
        if (uriInfo == null) {
            return entity;
        }
        return (T)entity.withHref(this.getHref(uriInfo, entity.getId()));
    }

    public URI getHref(UriInfo uriInfo, UUID id) {
        return RestUtil.getHref(uriInfo, this.collectionPath, id);
    }

    public void restoreEntity(String updatedBy, String entityType, UUID id) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.daoCollection.relationshipDAO().findTo(id.toString(), entityType, Relationship.CONTAINS.ordinal());
        if (!records.isEmpty()) {
            for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
                LOG.info("Recursively restoring {} {}", (Object)entityRelationshipRecord.getType(), (Object)entityRelationshipRecord.getId());
                Entity.restoreEntity(updatedBy, entityRelationshipRecord.getType(), entityRelationshipRecord.getId());
            }
        }
        LOG.info("Restoring the {} {}", (Object)entityType, (Object)id);
        T entity = this.dao.findEntityById(id, Include.DELETED);
        entity.setDeleted(Boolean.valueOf(false));
        this.dao.update(entity.getId(), JsonUtils.pojoToJson(entity));
    }

    public void addRelationship(UUID fromId, UUID toId, String fromEntity, String toEntity, Relationship relationship) {
        this.addRelationship(fromId, toId, fromEntity, toEntity, relationship, false);
    }

    public void addRelationship(UUID fromId, UUID toId, String fromEntity, String toEntity, Relationship relationship, boolean bidirectional) {
        this.addRelationship(fromId, toId, fromEntity, toEntity, relationship, null, bidirectional);
    }

    public void addRelationship(UUID fromId, UUID toId, String fromEntity, String toEntity, Relationship relationship, String json, boolean bidirectional) {
        UUID from = fromId;
        UUID to = toId;
        if (bidirectional && fromId.compareTo(toId) > 0) {
            from = toId;
            to = fromId;
        }
        this.daoCollection.relationshipDAO().insert(from, to, fromEntity, toEntity, relationship.ordinal(), json);
    }

    public List<CollectionDAO.EntityRelationshipRecord> findBoth(UUID entity1, String entityType1, Relationship relationship, String entity2) {
        ArrayList<CollectionDAO.EntityRelationshipRecord> ids = new ArrayList<CollectionDAO.EntityRelationshipRecord>();
        ids.addAll(this.findFrom(entity1, entityType1, relationship, entity2));
        ids.addAll(this.findTo(entity1, entityType1, relationship, entity2));
        return ids;
    }

    public List<CollectionDAO.EntityRelationshipRecord> findFrom(UUID toId, String toEntityType, Relationship relationship, String fromEntityType) {
        return fromEntityType == null ? this.daoCollection.relationshipDAO().findFrom(toId.toString(), toEntityType, relationship.ordinal()) : this.daoCollection.relationshipDAO().findFrom(toId.toString(), toEntityType, relationship.ordinal(), fromEntityType);
    }

    public List<CollectionDAO.EntityRelationshipRecord> findFrom(String toId) {
        return this.daoCollection.relationshipDAO().findFrom(toId);
    }

    public EntityReference getContainer(UUID toId) throws IOException {
        return this.getFromEntityRef(toId, Relationship.CONTAINS, null, true);
    }

    public EntityReference getFromEntityRef(UUID toId, Relationship relationship, String fromEntityType, boolean mustHaveRelationship) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(toId, this.entityType, relationship, fromEntityType);
        this.ensureSingleRelationship(this.entityType, toId, records, relationship.value(), mustHaveRelationship);
        return records.size() >= 1 ? Entity.getEntityReferenceById(records.get(0).getType(), records.get(0).getId(), Include.ALL) : null;
    }

    public EntityReference getToEntityRef(UUID fromId, Relationship relationship, String toEntityType, boolean mustHaveRelationship) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findTo(fromId, this.entityType, relationship, toEntityType);
        this.ensureSingleRelationship(this.entityType, fromId, records, relationship.value(), mustHaveRelationship);
        return records.size() >= 1 ? Entity.getEntityReferenceById(records.get(0).getType(), records.get(0).getId(), Include.ALL) : null;
    }

    public void ensureSingleRelationship(String entityType, UUID id, List<?> relations, String relationshipName, boolean mustHaveRelationship) {
        if (mustHaveRelationship && relations.size() == 0) {
            throw new UnhandledServerException(CatalogExceptionMessage.entityTypeNotFound(entityType));
        }
        if (!mustHaveRelationship && relations.isEmpty()) {
            return;
        }
        if (relations.size() != 1) {
            LOG.warn("Possible database issues - multiple relations {} for entity {}:{}", new Object[]{relationshipName, entityType, id});
        }
    }

    public final List<CollectionDAO.EntityRelationshipRecord> findTo(UUID fromId, String fromEntityType, Relationship relationship, String toEntityType) {
        return this.daoCollection.relationshipDAO().findTo(fromId.toString(), fromEntityType, relationship.ordinal(), toEntityType);
    }

    public void deleteRelationship(UUID fromId, String fromEntityType, UUID toId, String toEntityType, Relationship relationship) {
        this.daoCollection.relationshipDAO().delete(fromId.toString(), fromEntityType, toId.toString(), toEntityType, relationship.ordinal());
    }

    public void deleteTo(UUID toId, String toEntityType, Relationship relationship, String fromEntityType) {
        this.daoCollection.relationshipDAO().deleteTo(toId.toString(), toEntityType, relationship.ordinal(), fromEntityType);
    }

    public void deleteFrom(UUID fromId, String fromEntityType, Relationship relationship, String toEntityType) {
        this.daoCollection.relationshipDAO().deleteFrom(fromId.toString(), fromEntityType, relationship.ordinal(), toEntityType);
    }

    public void validateUsers(List<EntityReference> entityReferences) throws IOException {
        if (entityReferences != null) {
            for (EntityReference entityReference : entityReferences) {
                EntityReference ref = this.daoCollection.userDAO().findEntityReferenceById(entityReference.getId());
                EntityUtil.copy(ref, entityReference);
            }
            entityReferences.sort(EntityUtil.compareEntityReference);
        }
    }

    public void validateRoles(List<EntityReference> roles) throws IOException {
        if (roles != null) {
            for (EntityReference entityReference : roles) {
                EntityReference ref = this.daoCollection.roleDAO().findEntityReferenceById(entityReference.getId());
                EntityUtil.copy(ref, entityReference);
            }
            roles.sort(EntityUtil.compareEntityReference);
        }
    }

    void validatePolicies(List<EntityReference> policies) throws IOException {
        if (policies != null) {
            for (EntityReference entityReference : policies) {
                EntityReference ref = this.daoCollection.policyDAO().findEntityReferenceById(entityReference.getId());
                EntityUtil.copy(ref, entityReference);
            }
            policies.sort(EntityUtil.compareEntityReference);
        }
    }

    public EntityReference getOwner(T entity) throws IOException {
        if (!this.supportsOwner) {
            return null;
        }
        return this.getFromEntityRef(entity.getId(), Relationship.OWNS, null, false);
    }

    public EntityReference getOwner(EntityReference ref) throws IOException {
        return !this.supportsOwner ? null : Entity.getEntityReferenceById(ref.getType(), ref.getId(), Include.ALL);
    }

    public EntityReference getOriginalOwner(T entity) throws IOException {
        if (!this.supportsOwner) {
            return null;
        }
        String json = this.dao.findJsonByFqn(entity.getFullyQualifiedName(), Include.NON_DELETED);
        if (json == null) {
            return null;
        }
        entity = (EntityInterface)JsonUtils.readValue(json, this.entityClass);
        return this.getOwner(entity);
    }

    public void populateOwner(EntityReference owner) throws IOException {
        if (owner == null) {
            return;
        }
        EntityReference ref = this.validateOwner(owner);
        EntityUtil.copy(ref, owner);
    }

    protected void storeOwner(T entity, EntityReference owner) {
        if (this.supportsOwner && owner != null) {
            LOG.info("Adding owner {}:{} for entity {}:{}", new Object[]{owner.getType(), owner.getId(), this.entityType, entity.getId()});
            this.addRelationship(owner.getId(), entity.getId(), owner.getType(), this.entityType, Relationship.OWNS);
        }
    }

    private void removeOwner(T entity, EntityReference owner) {
        if (owner != null && owner.getId() != null) {
            LOG.info("Removing owner {}:{} for entity {}", new Object[]{owner.getType(), owner.getId(), entity.getId()});
            this.deleteRelationship(owner.getId(), owner.getType(), entity.getId(), this.entityType, Relationship.OWNS);
        }
    }

    public void updateOwner(T ownedEntity, EntityReference originalOwner, EntityReference newOwner) {
        this.removeOwner(ownedEntity, originalOwner);
        this.storeOwner(ownedEntity, newOwner);
    }

    public final EntityUtil.Fields getFields(String fields) {
        return new EntityUtil.Fields(this.allowedFields, fields);
    }

    public final List<String> getAllowedFields() {
        return this.allowedFields;
    }

    public final List<String> getAllowedFieldsCopy() {
        return new ArrayList<String>(this.allowedFields);
    }

    protected String getCustomPropertyFQNPrefix(String entityType) {
        return FullyQualifiedName.build(entityType, "customProperties");
    }

    protected String getCustomPropertyFQN(String entityType, String propertyName) {
        return FullyQualifiedName.build(entityType, "customProperties", propertyName);
    }

    public static List<UUID> toIds(List<String> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String id : ids) {
            uuids.add(UUID.fromString(id));
        }
        return uuids;
    }

    protected List<EntityReference> getIngestionPipelines(T service) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findTo(service.getId(), this.entityType, Relationship.CONTAINS, "ingestionPipeline");
        ArrayList<EntityReference> ingestionPipelines = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            ingestionPipelines.add(this.daoCollection.ingestionPipelineDAO().findEntityReferenceById(entityRelationshipRecord.getId(), Include.ALL));
        }
        return ingestionPipelines;
    }

    public EntityReference validateOwner(EntityReference owner) throws IOException {
        if (owner == null) {
            return null;
        }
        if (owner.getType().equals("team")) {
            Team team = (Team)Entity.getEntity("team", owner.getId(), EntityUtil.Fields.EMPTY_FIELDS, Include.ALL);
            if (!team.getTeamType().equals((Object)CreateTeam.TeamType.GROUP)) {
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidTeamOwner(team.getTeamType()));
            }
            return team.getEntityReference();
        }
        return Entity.getEntityReferenceById(owner.getType(), owner.getId(), Include.ALL);
    }

    public boolean isSupportsTags() {
        return this.supportsTags;
    }

    public boolean isSupportsOwner() {
        return this.supportsOwner;
    }

    public static class EntityUpdater {
        protected final T original;
        protected final T updated;
        protected final Operation operation;
        protected final ChangeDescription changeDescription = new ChangeDescription();
        protected boolean majorVersionChange = false;
        protected final User updatingUser;
        private boolean entityRestored = false;
        final /* synthetic */ EntityRepository this$0;

        public EntityUpdater(T original, T updated, Operation operation) {
            this.this$0 = this$0;
            this.original = original;
            this.updated = updated;
            this.operation = operation;
            this.updatingUser = updated.getUpdatedBy().equalsIgnoreCase("admin") ? new User().withName("admin").withIsAdmin(Boolean.valueOf(true)) : SubjectCache.getInstance().getSubjectContext(updated.getUpdatedBy()).getUser();
        }

        public final void update() throws IOException {
            if (this.operation.isDelete()) {
                this.updateDeleted();
            } else {
                this.updated.setId(this.original.getId());
                this.updateDeleted();
                this.updateDescription();
                this.updateDisplayName();
                this.updateOwner();
                this.updateExtension();
                this.updateTags(this.updated.getFullyQualifiedName(), "tags", this.original.getTags(), this.updated.getTags());
                this.entitySpecificUpdate();
            }
            this.storeUpdate();
        }

        public void entitySpecificUpdate() throws IOException {
        }

        private void updateDescription() throws JsonProcessingException {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)this.original.getDescription()) && this.updatedByBot()) {
                this.updated.setDescription(this.original.getDescription());
                return;
            }
            this.recordChange("description", this.original.getDescription(), this.updated.getDescription());
        }

        private void updateDeleted() throws JsonProcessingException {
            if (this.operation.isPut() || this.operation.isPatch()) {
                if (this.updated.getDeleted() != this.original.getDeleted() && Boolean.TRUE.equals(this.updated.getDeleted())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.readOnlyAttribute(this.this$0.entityType, "deleted"));
                }
                if (Boolean.TRUE.equals(this.original.getDeleted())) {
                    this.updated.setDeleted(Boolean.valueOf(false));
                    this.recordChange("deleted", true, false);
                    this.entityRestored = true;
                }
            } else {
                this.recordChange("deleted", this.original.getDeleted(), this.updated.getDeleted());
            }
        }

        private void updateDisplayName() throws JsonProcessingException {
            if (this.operation.isPut() && !CommonUtil.nullOrEmpty((String)this.original.getDisplayName()) && this.updatedByBot()) {
                this.updated.setDisplayName(this.original.getDisplayName());
                return;
            }
            this.recordChange("displayName", this.original.getDisplayName(), this.updated.getDisplayName());
        }

        private void updateOwner() throws JsonProcessingException {
            EntityReference origOwner = this.original.getOwner();
            EntityReference updatedOwner = this.updated.getOwner();
            if ((this.operation.isPatch() || updatedOwner != null) && this.recordChange("owner", origOwner, updatedOwner, true, EntityUtil.entityReferenceMatch)) {
                this.this$0.updateOwner(this.original, origOwner, updatedOwner);
            }
        }

        protected void updateTags(String fqn, String fieldName, List<TagLabel> origTags, List<TagLabel> updatedTags) throws IOException {
            origTags = CommonUtil.listOrEmpty(origTags);
            updatedTags = Optional.ofNullable(updatedTags).orElse(new ArrayList());
            if (origTags.isEmpty() && updatedTags.isEmpty()) {
                return;
            }
            this.this$0.daoCollection.tagUsageDAO().deleteTagsByTarget(fqn);
            if (this.operation.isPut()) {
                EntityUtil.mergeTags(updatedTags, origTags);
            }
            ArrayList addedTags = new ArrayList();
            ArrayList deletedTags = new ArrayList();
            this.recordListChange(fieldName, origTags, updatedTags, addedTags, deletedTags, EntityUtil.tagLabelMatch);
            updatedTags.sort(EntityUtil.compareTagLabel);
            this.this$0.applyTags(updatedTags, fqn);
        }

        private void updateExtension() throws JsonProcessingException {
            if (this.original.getExtension() == this.updated.getExtension()) {
                return;
            }
            if (this.updatedByBot()) {
                this.updated.setExtension(this.original.getExtension());
                return;
            }
            ArrayList<ObjectNode> added = new ArrayList<ObjectNode>();
            ArrayList<ObjectNode> deleted = new ArrayList<ObjectNode>();
            JsonNode origFields = JsonUtils.valueToTree(this.original.getExtension());
            JsonNode updatedFields = JsonUtils.valueToTree(this.updated.getExtension());
            Iterator it = origFields.fields();
            while (it.hasNext()) {
                Map.Entry orig = (Map.Entry)it.next();
                JsonNode updated = updatedFields.get((String)orig.getKey());
                if (updated == null) {
                    deleted.add(JsonUtils.getObjectNode((String)orig.getKey(), (JsonNode)orig.getValue()));
                    continue;
                }
                this.recordChange(EntityUtil.getExtensionField((String)orig.getKey()), ((JsonNode)orig.getValue()).toString(), updated.toString());
            }
            it = updatedFields.fields();
            while (it.hasNext()) {
                Map.Entry updated = (Map.Entry)it.next();
                JsonNode orig = origFields.get((String)updated.getKey());
                if (orig != null) continue;
                added.add(JsonUtils.getObjectNode((String)updated.getKey(), (JsonNode)updated.getValue()));
            }
            if (!added.isEmpty()) {
                EntityUtil.fieldAdded(this.changeDescription, "extension", JsonUtils.pojoToJson(added));
            }
            if (!deleted.isEmpty()) {
                EntityUtil.fieldDeleted(this.changeDescription, "extension", JsonUtils.pojoToJson(deleted));
            }
            this.this$0.removeExtension((EntityInterface)this.original);
            this.this$0.storeExtension((EntityInterface)this.updated);
        }

        public final boolean updateVersion(Double oldVersion) {
            Double newVersion = oldVersion;
            if (this.majorVersionChange) {
                newVersion = EntityUtil.nextMajorVersion(oldVersion);
            } else if (this.fieldsChanged()) {
                newVersion = EntityUtil.nextVersion(oldVersion);
            }
            LOG.info("{} {}->{} - Fields added {}, updated {}, deleted {}", new Object[]{this.original.getId(), oldVersion, newVersion, this.changeDescription.getFieldsAdded(), this.changeDescription.getFieldsUpdated(), this.changeDescription.getFieldsDeleted()});
            this.changeDescription.withPreviousVersion(oldVersion);
            this.updated.setVersion(newVersion);
            this.updated.setChangeDescription(this.changeDescription);
            return !newVersion.equals(oldVersion);
        }

        public boolean fieldsChanged() {
            return !this.changeDescription.getFieldsAdded().isEmpty() || !this.changeDescription.getFieldsUpdated().isEmpty() || !this.changeDescription.getFieldsDeleted().isEmpty();
        }

        public boolean isEntityRestored() {
            return this.entityRestored;
        }

        public final <K> boolean recordChange(String field, K orig, K updated) throws JsonProcessingException {
            return this.recordChange(field, orig, updated, false, EntityUtil.objectMatch);
        }

        public final <K> boolean recordChange(String field, K orig, K updated, boolean jsonValue) throws JsonProcessingException {
            return this.recordChange(field, orig, updated, jsonValue, EntityUtil.objectMatch);
        }

        public final <K> boolean recordChange(String field, K orig, K updated, boolean jsonValue, BiPredicate<K, K> typeMatch) throws JsonProcessingException {
            if (orig == updated) {
                return false;
            }
            FieldChange fieldChange = new FieldChange().withName(field).withOldValue(jsonValue ? JsonUtils.pojoToJson(orig) : orig).withNewValue(jsonValue ? JsonUtils.pojoToJson(updated) : updated);
            if (orig == null) {
                this.changeDescription.getFieldsAdded().add(fieldChange);
                return true;
            }
            if (updated == null) {
                this.changeDescription.getFieldsDeleted().add(fieldChange);
                return true;
            }
            if (!typeMatch.test(orig, updated)) {
                this.changeDescription.getFieldsUpdated().add(fieldChange);
                return true;
            }
            return false;
        }

        public final <K> boolean recordListChange(String field, List<K> origList, List<K> updatedList, List<K> addedItems, List<K> deletedItems, BiPredicate<K, K> typeMatch) throws JsonProcessingException {
            origList = CommonUtil.listOrEmpty(origList);
            updatedList = CommonUtil.listOrEmpty(updatedList);
            for (Object stored : origList) {
                Object u = updatedList.stream().filter(c -> typeMatch.test(c, stored)).findAny().orElse(null);
                if (u != null) continue;
                deletedItems.add(stored);
            }
            for (Object U : updatedList) {
                Object stored = origList.stream().filter(c -> typeMatch.test(c, U)).findAny().orElse(null);
                if (stored != null) continue;
                addedItems.add(U);
            }
            if (!addedItems.isEmpty()) {
                EntityUtil.fieldAdded(this.changeDescription, field, JsonUtils.pojoToJson(addedItems));
            }
            if (!deletedItems.isEmpty()) {
                EntityUtil.fieldDeleted(this.changeDescription, field, JsonUtils.pojoToJson(deletedItems));
            }
            return !addedItems.isEmpty() || !deletedItems.isEmpty();
        }

        public final void updateToRelationships(String field, String fromEntityType, UUID fromId, Relationship relationshipType, String toEntityType, List<EntityReference> origToRefs, List<EntityReference> updatedToRefs, boolean bidirectional) throws JsonProcessingException {
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            if (!this.recordListChange(field, origToRefs, updatedToRefs, added, deleted, EntityUtil.entityReferenceMatch)) {
                return;
            }
            this.this$0.deleteFrom(fromId, fromEntityType, relationshipType, toEntityType);
            if (bidirectional) {
                this.this$0.deleteTo(fromId, fromEntityType, relationshipType, toEntityType);
            }
            for (EntityReference ref : updatedToRefs) {
                this.this$0.addRelationship(fromId, ref.getId(), fromEntityType, toEntityType, relationshipType, bidirectional);
            }
            updatedToRefs.sort(EntityUtil.compareEntityReference);
            origToRefs.sort(EntityUtil.compareEntityReference);
        }

        public final void updateFromRelationships(String field, String fromEntityType, List<EntityReference> originFromRefs, List<EntityReference> updatedFromRefs, Relationship relationshipType, String toEntityType, UUID toId) throws JsonProcessingException {
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            if (!this.recordListChange(field, originFromRefs, updatedFromRefs, added, deleted, EntityUtil.entityReferenceMatch)) {
                return;
            }
            this.this$0.deleteTo(toId, toEntityType, relationshipType, fromEntityType);
            for (EntityReference ref : updatedFromRefs) {
                this.this$0.addRelationship(ref.getId(), toId, fromEntityType, toEntityType, relationshipType);
            }
            updatedFromRefs.sort(EntityUtil.compareEntityReference);
            originFromRefs.sort(EntityUtil.compareEntityReference);
        }

        public final void storeUpdate() throws IOException {
            if (this.updateVersion(this.original.getVersion())) {
                this.storeOldVersion();
                this.storeNewVersion();
            } else {
                this.updated.setUpdatedBy(this.original.getUpdatedBy());
                this.updated.setUpdatedAt(this.original.getUpdatedAt());
            }
        }

        private void storeOldVersion() throws JsonProcessingException {
            String extensionName = EntityUtil.getVersionExtension(this.this$0.entityType, this.original.getVersion());
            this.this$0.daoCollection.entityExtensionDAO().insert(this.original.getId().toString(), extensionName, this.this$0.entityType, JsonUtils.pojoToJson(this.original));
        }

        private void storeNewVersion() throws IOException {
            this.this$0.storeEntity(this.updated, true);
        }

        public final boolean updatedByBot() {
            return Boolean.TRUE.equals(this.updatingUser.getIsBot());
        }
    }

    public static enum Operation {
        PUT,
        PATCH,
        SOFT_DELETE;


        public boolean isPatch() {
            return this == PATCH;
        }

        public boolean isPut() {
            return this == PUT;
        }

        public boolean isDelete() {
            return this == SOFT_DELETE;
        }
    }
}

