/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import org.json.JSONObject;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.ingestionPipelines.AirflowConfig;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.DatabaseServiceMetadataPipeline;
import org.openmetadata.schema.metadataIngestion.LogLevels;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.PipelineServiceClient;

public class IngestionPipelineRepository
extends EntityRepository<IngestionPipeline> {
    private static final String UPDATE_FIELDS = "owner,sourceConfig,airflowConfig,loggerLevel,enabled";
    private static final String PATCH_FIELDS = "owner,sourceConfig,airflowConfig,loggerLevel,enabled";
    private static PipelineServiceClient pipelineServiceClient;
    private final SecretsManager secretsManager;

    public IngestionPipelineRepository(CollectionDAO dao, SecretsManager secretsManager) {
        super("v1/services/ingestionPipelines/", "ingestionPipeline", IngestionPipeline.class, dao.ingestionPipelineDAO(), dao, "owner,sourceConfig,airflowConfig,loggerLevel,enabled", "owner,sourceConfig,airflowConfig,loggerLevel,enabled");
        this.secretsManager = secretsManager;
    }

    @Override
    public void setFullyQualifiedName(IngestionPipeline ingestionPipeline) {
        ingestionPipeline.setFullyQualifiedName(FullyQualifiedName.add(ingestionPipeline.getService().getName(), ingestionPipeline.getName()));
    }

    @Override
    public IngestionPipeline setFields(IngestionPipeline ingestionPipeline, EntityUtil.Fields fields) throws IOException {
        ingestionPipeline.setService(this.getContainer(ingestionPipeline.getId()));
        ingestionPipeline.setOwner(fields.contains("owner") ? this.getOwner(ingestionPipeline) : null);
        return ingestionPipeline;
    }

    @Override
    public void prepare(IngestionPipeline ingestionPipeline) throws IOException {
        EntityReference entityReference = Entity.getEntityReference(ingestionPipeline.getService());
        ingestionPipeline.setService(entityReference);
        this.setFullyQualifiedName(ingestionPipeline);
    }

    @Override
    public void storeEntity(IngestionPipeline ingestionPipeline, boolean update) throws IOException {
        EntityReference owner = ingestionPipeline.getOwner();
        EntityReference service = ingestionPipeline.getService();
        ingestionPipeline.withOwner(null).withService(null).withHref(null);
        if (this.secretsManager.isLocal()) {
            this.secretsManager.encryptOrDecryptDbtConfigSource(ingestionPipeline, service, true);
            this.store(ingestionPipeline.getId(), ingestionPipeline, update);
        } else if (service.getType().equals("databaseService") && ingestionPipeline.getPipelineType().equals((Object)PipelineType.METADATA)) {
            DatabaseServiceMetadataPipeline databaseServiceMetadataPipeline = JsonUtils.convertValue(ingestionPipeline.getSourceConfig().getConfig(), DatabaseServiceMetadataPipeline.class);
            Object dbtConfigSource = databaseServiceMetadataPipeline.getDbtConfigSource();
            databaseServiceMetadataPipeline.setDbtConfigSource(null);
            ingestionPipeline.getSourceConfig().setConfig((Object)databaseServiceMetadataPipeline);
            this.store(ingestionPipeline.getId(), ingestionPipeline, update);
            databaseServiceMetadataPipeline.setDbtConfigSource(dbtConfigSource);
            ingestionPipeline.getSourceConfig().setConfig((Object)databaseServiceMetadataPipeline);
            this.secretsManager.encryptOrDecryptDbtConfigSource(ingestionPipeline, service, true);
        } else {
            this.store(ingestionPipeline.getId(), ingestionPipeline, update);
        }
        ingestionPipeline.withOwner(owner).withService(service);
    }

    @Override
    public void storeRelationships(IngestionPipeline ingestionPipeline) {
        EntityReference service = ingestionPipeline.getService();
        this.addRelationship(service.getId(), ingestionPipeline.getId(), service.getType(), "ingestionPipeline", Relationship.CONTAINS);
        this.storeOwner(ingestionPipeline, ingestionPipeline.getOwner());
        this.applyTags(ingestionPipeline);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(IngestionPipeline original, IngestionPipeline updated, EntityRepository.Operation operation) {
        return new IngestionPipelineUpdater(original, updated, operation);
    }

    @Override
    protected void postDelete(IngestionPipeline entity) {
        pipelineServiceClient.deletePipeline(entity.getName());
    }

    public void setPipelineServiceClient(PipelineServiceClient client) {
        pipelineServiceClient = client;
    }

    public class IngestionPipelineUpdater
    extends EntityRepository.EntityUpdater {
        public IngestionPipelineUpdater(IngestionPipeline original, IngestionPipeline updated, EntityRepository.Operation operation) {
            super((EntityRepository)IngestionPipelineRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateSourceConfig();
            this.updateAirflowConfig(((IngestionPipeline)this.original).getAirflowConfig(), ((IngestionPipeline)this.updated).getAirflowConfig());
            this.updateOpenMetadataServerConnection(((IngestionPipeline)this.original).getOpenMetadataServerConnection(), ((IngestionPipeline)this.updated).getOpenMetadataServerConnection());
            this.updateLogLevel(((IngestionPipeline)this.original).getLoggerLevel(), ((IngestionPipeline)this.updated).getLoggerLevel());
            this.updateEnabled(((IngestionPipeline)this.original).getEnabled(), ((IngestionPipeline)this.updated).getEnabled());
        }

        private void updateSourceConfig() throws JsonProcessingException {
            IngestionPipelineRepository.this.secretsManager.encryptOrDecryptDbtConfigSource((IngestionPipeline)this.original, false);
            JSONObject origSourceConfig = new JSONObject(JsonUtils.pojoToJson(((IngestionPipeline)this.original).getSourceConfig().getConfig()));
            JSONObject updatedSourceConfig = new JSONObject(JsonUtils.pojoToJson(((IngestionPipeline)this.updated).getSourceConfig().getConfig()));
            ((IngestionPipeline)this.original).getSourceConfig().setConfig(null);
            if (!origSourceConfig.similar((Object)updatedSourceConfig)) {
                this.recordChange("sourceConfig", "old-encrypted-value", "new-encrypted-value", true);
            }
        }

        private void updateAirflowConfig(AirflowConfig origAirflowConfig, AirflowConfig updatedAirflowConfig) throws JsonProcessingException {
            if (!origAirflowConfig.equals((Object)updatedAirflowConfig)) {
                this.recordChange("airflowConfig", origAirflowConfig, updatedAirflowConfig);
            }
        }

        private void updateOpenMetadataServerConnection(OpenMetadataServerConnection origConfig, OpenMetadataServerConnection updatedConfig) throws JsonProcessingException {
            if (updatedConfig != null && !origConfig.equals((Object)updatedConfig)) {
                this.recordChange("openMetadataServerConnection", origConfig, updatedConfig);
            }
        }

        private void updateLogLevel(LogLevels origLevel, LogLevels updatedLevel) throws JsonProcessingException {
            if (updatedLevel != null && !origLevel.equals((Object)updatedLevel)) {
                this.recordChange("loggerLevel", origLevel, updatedLevel);
            }
        }

        private void updateEnabled(Boolean origEnabled, Boolean updatedEnabled) throws JsonProcessingException {
            if (updatedEnabled != null && !origEnabled.equals(updatedEnabled)) {
                this.recordChange("enabled", origEnabled, updatedEnabled);
            }
        }
    }
}

