/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Location;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class LocationRepository
extends EntityRepository<Location> {
    private static final String LOCATION_PATCH_FIELDS = "owner,tags,path";
    private static final String LOCATION_UPDATE_FIELDS = "owner,tags,path";

    public LocationRepository(CollectionDAO dao) {
        super("v1/locations/", "location", Location.class, dao.locationDAO(), dao, "owner,tags,path", "owner,tags,path");
    }

    @Override
    public Location setFields(Location location, EntityUtil.Fields fields) throws IOException {
        location.setService(this.getContainer(location.getId()));
        location.setPath(location.getPath());
        location.setFollowers(fields.contains("followers") ? this.getFollowers(location) : null);
        return location;
    }

    @Override
    public void restorePatchAttributes(Location original, Location updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    @Transaction
    public final ResultList<Location> listPrefixesBefore(EntityUtil.Fields fields, String fqn, int limitParam, String before) throws IOException {
        String service = FullyQualifiedName.getServiceName(fqn);
        List<String> jsons = this.daoCollection.locationDAO().listPrefixesBefore(this.daoCollection.locationDAO().getTableName(), this.daoCollection.locationDAO().getNameColumn(), fqn, service, limitParam + 1, RestUtil.decodeCursor(before));
        ArrayList<Location> entities = new ArrayList<Location>();
        for (String json : jsons) {
            entities.add(this.setFieldsInternal(JsonUtils.readValue(json, Location.class), fields));
        }
        int total = this.daoCollection.locationDAO().listPrefixesCount(this.daoCollection.locationDAO().getTableName(), this.daoCollection.locationDAO().getNameColumn(), fqn, service);
        String beforeCursor = null;
        if (entities.size() > limitParam) {
            entities.remove(0);
            beforeCursor = ((Location)entities.get(0)).getFullyQualifiedName();
        }
        String afterCursor = ((Location)entities.get(entities.size() - 1)).getFullyQualifiedName();
        return this.getResultList(entities, beforeCursor, afterCursor, total);
    }

    @Transaction
    public final ResultList<Location> listPrefixesAfter(EntityUtil.Fields fields, String fqn, int limitParam, String after) throws IOException {
        String beforeCursor;
        String service = FullyQualifiedName.getServiceName(fqn);
        List<String> jsons = this.daoCollection.locationDAO().listPrefixesAfter(this.daoCollection.locationDAO().getTableName(), this.daoCollection.locationDAO().getNameColumn(), fqn, service, limitParam + 1, after == null ? "" : RestUtil.decodeCursor(after));
        ArrayList<Location> entities = new ArrayList<Location>();
        for (String json : jsons) {
            entities.add(this.setFieldsInternal(JsonUtils.readValue(json, Location.class), fields));
        }
        int total = this.daoCollection.locationDAO().listPrefixesCount(this.daoCollection.locationDAO().getTableName(), this.daoCollection.locationDAO().getNameColumn(), fqn, service);
        String afterCursor = null;
        String string = beforeCursor = after == null ? null : ((Location)entities.get(0)).getFullyQualifiedName();
        if (entities.size() > limitParam) {
            entities.remove(limitParam);
            afterCursor = ((Location)entities.get(limitParam - 1)).getFullyQualifiedName();
        }
        return this.getResultList(entities, beforeCursor, afterCursor, total);
    }

    @Override
    public void setFullyQualifiedName(Location location) {
        location.setFullyQualifiedName(FullyQualifiedName.add(location.getService().getName(), location.getName()));
    }

    private StorageService getService(UUID serviceId, String entityType) throws IOException {
        if (entityType.equalsIgnoreCase("storageService")) {
            return (StorageService)this.daoCollection.storageServiceDAO().findEntityById(serviceId);
        }
        throw new IllegalArgumentException(CatalogExceptionMessage.invalidServiceEntity(entityType, "location", "storageService"));
    }

    @Override
    public void prepare(Location location) throws IOException {
        StorageService storageService = this.getService(location.getService().getId(), location.getService().getType());
        location.setService(storageService.getEntityReference());
        location.setServiceType(storageService.getServiceType());
        this.setFullyQualifiedName(location);
        location.setTags(this.addDerivedTags(location.getTags()));
    }

    @Override
    public void storeEntity(Location location, boolean update) throws IOException {
        EntityReference owner = location.getOwner();
        EntityReference service = location.getService();
        List tags = location.getTags();
        location.withOwner(null).withService(null).withHref(null).withTags(null);
        this.store(location.getId(), location, update);
        location.withOwner(owner).withService(service).withTags(tags);
    }

    @Override
    public void storeRelationships(Location location) {
        this.storeOwner(location, location.getOwner());
        EntityReference service = location.getService();
        this.addRelationship(service.getId(), location.getId(), service.getType(), "location", Relationship.CONTAINS);
        this.applyTags(location);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Location original, Location updated, EntityRepository.Operation operation) {
        return new LocationUpdater(original, updated, operation);
    }

    private EntityReference getService(EntityReference service) throws IOException {
        if (service.getType().equalsIgnoreCase("storageService")) {
            return this.daoCollection.storageServiceDAO().findEntityReferenceById(service.getId());
        }
        throw new IllegalArgumentException(CatalogExceptionMessage.invalidServiceEntity(service.getType(), "location", "storageService"));
    }

    public List<EntityReference> getEntityDetails(String id) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(id);
        return EntityUtil.getEntityReferences(records);
    }

    public void setService(Location location, EntityReference service) throws IOException {
        if (service != null && location != null) {
            service = this.getService(service);
            this.addRelationship(service.getId(), location.getId(), service.getType(), "location", Relationship.CONTAINS);
            location.setService(service);
        }
    }

    public class LocationUpdater
    extends EntityRepository.EntityUpdater {
        public LocationUpdater(Location original, Location updated, EntityRepository.Operation operation) {
            super((EntityRepository)LocationRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("locationType", ((Location)this.original).getLocationType(), ((Location)this.updated).getLocationType());
            this.recordChange("path", ((Location)this.original).getPath(), ((Location)this.updated).getPath());
        }
    }
}

