/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;

public abstract class ServiceEntityRepository<T extends ServiceEntityInterface, S extends ServiceConnectionEntityInterface>
extends EntityRepository<T> {
    private static final String UPDATE_FIELDS = "owner";
    private final Class<S> serviceConnectionClass;
    protected final SecretsManager secretsManager;
    private final ServiceType serviceType;

    protected ServiceEntityRepository(String collectionPath, String service, CollectionDAO dao, EntityDAO<T> entityDAO, SecretsManager secretsManager, Class<S> serviceConnectionClass, ServiceType serviceType) {
        this(collectionPath, service, dao, entityDAO, secretsManager, serviceConnectionClass, UPDATE_FIELDS, serviceType);
    }

    protected ServiceEntityRepository(String collectionPath, String service, CollectionDAO dao, EntityDAO<T> entityDAO, SecretsManager secretsManager, Class<S> serviceConnectionClass, String updatedFields, ServiceType serviceType) {
        super(collectionPath, service, entityDAO.getEntityClass(), entityDAO, dao, "", updatedFields);
        this.secretsManager = secretsManager;
        this.serviceConnectionClass = serviceConnectionClass;
        this.serviceType = serviceType;
    }

    @Override
    public T setFields(T entity, EntityUtil.Fields fields) throws IOException {
        entity.setPipelines(fields.contains("pipelines") ? this.getIngestionPipelines(entity) : null);
        entity.setOwner(fields.contains(UPDATE_FIELDS) ? this.getOwner(entity) : null);
        return entity;
    }

    @Override
    public void prepare(T service) {
        this.setFullyQualifiedName(service);
    }

    @Override
    public void storeEntity(T service, boolean update) throws IOException {
        EntityReference owner = service.getOwner();
        service.withOwner(null).withHref(null);
        if (this.secretsManager.isLocal()) {
            service.getConnection().setConfig(this.secretsManager.encryptOrDecryptServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), service.getName(), this.serviceType, true));
            this.store(service.getId(), service, update);
        } else {
            Object connectionConfig = service.getConnection().getConfig();
            this.secretsManager.validateServiceConnection(connectionConfig, service.getServiceType().value(), this.serviceType);
            service.getConnection().setConfig(null);
            this.store(service.getId(), service, update);
            service.getConnection().setConfig(this.secretsManager.encryptOrDecryptServiceConnectionConfig(connectionConfig, service.getServiceType().value(), service.getName(), this.serviceType, true));
        }
        service.withOwner(owner);
    }

    @Override
    public void storeRelationships(T service) {
        this.storeOwner(service, service.getOwner());
    }

    @Override
    public ServiceUpdater getUpdater(T original, T updated, EntityRepository.Operation operation) {
        return new ServiceUpdater(this, original, updated, operation);
    }

    public Class<S> getServiceConnectionClass() {
        return this.serviceConnectionClass;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public static class ServiceUpdater
    extends EntityRepository.EntityUpdater {
        final /* synthetic */ ServiceEntityRepository this$0;

        public ServiceUpdater(T original, T updated, EntityRepository.Operation operation) {
            this.this$0 = this$0;
            super((EntityRepository)this$0, original, updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateConnection();
        }

        private void updateConnection() throws IOException {
            if (this.this$0.secretsManager.isLocal()) {
                ServiceConnectionEntityInterface origConn = ((ServiceEntityInterface)this.original).getConnection();
                ServiceConnectionEntityInterface updatedConn = ((ServiceEntityInterface)this.updated).getConnection();
                String origJson = JsonUtils.pojoToJson(origConn);
                String updatedJson = JsonUtils.pojoToJson(updatedConn);
                ServiceConnectionEntityInterface decryptedOrigConn = (ServiceConnectionEntityInterface)JsonUtils.readValue(origJson, this.this$0.serviceConnectionClass);
                ServiceConnectionEntityInterface decryptedUpdatedConn = (ServiceConnectionEntityInterface)JsonUtils.readValue(updatedJson, this.this$0.serviceConnectionClass);
                decryptedOrigConn.setConfig(this.this$0.secretsManager.encryptOrDecryptServiceConnectionConfig(decryptedOrigConn.getConfig(), ((ServiceEntityInterface)this.original).getServiceType().value(), ((ServiceEntityInterface)this.original).getName(), this.this$0.serviceType, false));
                decryptedUpdatedConn.setConfig(this.this$0.secretsManager.encryptOrDecryptServiceConnectionConfig(decryptedUpdatedConn.getConfig(), ((ServiceEntityInterface)this.updated).getServiceType().value(), ((ServiceEntityInterface)this.updated).getName(), this.this$0.serviceType, false));
                if (!EntityUtil.objectMatch.test(decryptedOrigConn, decryptedUpdatedConn)) {
                    this.recordChange("connection", origConn, updatedConn, true);
                }
            } else {
                ((ServiceEntityInterface)this.original).getConnection().setConfig(this.this$0.secretsManager.encryptOrDecryptServiceConnectionConfig(((ServiceEntityInterface)this.original).getConnection().getConfig(), ((ServiceEntityInterface)this.original).getServiceType().value(), ((ServiceEntityInterface)this.original).getName(), this.this$0.serviceType, false));
                String origJson = JsonUtils.pojoToJson(((ServiceEntityInterface)this.original).getConnection());
                String updatedJson = JsonUtils.pojoToJson(((ServiceEntityInterface)this.updated).getConnection());
                ((ServiceEntityInterface)this.original).getConnection().setConfig(null);
                if (!EntityUtil.objectMatch.test(origJson, updatedJson)) {
                    this.recordChange("connection", "old-encrypted-value", "new-encrypted-value", true);
                }
            }
        }
    }
}

