/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import javax.json.JsonPatch;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.filter.Filters;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.filter.FilterRegistry;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.util.FilterUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsRepository.class);
    private final CollectionDAO dao;

    public SettingsRepository(CollectionDAO dao) {
        this.dao = dao;
    }

    public ResultList<Settings> listAllConfigs() {
        List<Settings> settingsList = null;
        try {
            settingsList = this.dao.getSettingsDAO().getAllConfig();
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch all Settings " + ex.getMessage());
        }
        int count = 0;
        if (settingsList != null) {
            count = settingsList.size();
        }
        return new ResultList<Settings>(settingsList, null, null, count);
    }

    public Settings getConfigWithKey(String key) {
        Settings settings = null;
        try {
            settings = this.dao.getSettingsDAO().getConfigWithKey(key);
        }
        catch (Exception ex) {
            LOG.error("Error while trying fetch Settings " + ex.getMessage());
        }
        return settings;
    }

    public Response createOrUpdate(Settings setting) {
        Settings oldValue = this.getConfigWithKey(setting.getConfigType().toString());
        try {
            this.updateSetting(setting);
        }
        catch (Exception ex) {
            LOG.error("Failed to Update Settings" + ex.getMessage());
            return Response.status((int)500, (String)("Internal Server Error. Reason :" + ex.getMessage())).build();
        }
        if (oldValue == null) {
            return new RestUtil.PutResponse<Settings>(Response.Status.CREATED, setting, "entityCreated").toResponse();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.OK, setting, "entityUpdated").toResponse();
    }

    public Response updateEntityFilter(String entityType, List<Filters> filters) {
        Settings oldValue = this.getConfigWithKey(SettingsType.ACTIVITY_FEED_FILTER_SETTING.toString());
        try {
            this.updateSetting(FilterUtil.updateEntityFilter(oldValue, entityType, filters));
            return new RestUtil.PutResponse<Settings>(Response.Status.OK, oldValue, "entityUpdated").toResponse();
        }
        catch (Exception ex) {
            LOG.error("Failed to Update Settings" + ex.getMessage());
            return Response.status((int)500, (String)("Internal Server Error. Reason :" + ex.getMessage())).build();
        }
    }

    public Response createNewSetting(Settings setting) {
        try {
            this.updateSetting(setting);
        }
        catch (Exception ex) {
            LOG.error("Failed to Update Settings" + ex.getMessage());
            return Response.status((int)500, (String)("Internal Server Error. Reason :" + ex.getMessage())).build();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.CREATED, setting, "entityCreated").toResponse();
    }

    public Response patchSetting(String settingName, JsonPatch patch) {
        Settings original = this.getConfigWithKey(settingName);
        JsonValue updated = JsonUtils.applyPatch(original.getConfigValue(), patch);
        original.setConfigValue((Object)updated);
        try {
            this.updateSetting(original);
        }
        catch (Exception ex) {
            LOG.error("Failed to Update Settings" + ex.getMessage());
            return Response.status((int)500, (String)("Internal Server Error. Reason :" + ex.getMessage())).build();
        }
        return new RestUtil.PutResponse<Settings>(Response.Status.OK, original, "entityUpdated").toResponse();
    }

    public void updateSetting(Settings setting) {
        try {
            this.dao.getSettingsDAO().insertSettings(setting.getConfigType().toString(), JsonUtils.pojoToJson(setting.getConfigValue()));
            if (setting.getConfigType().equals((Object)SettingsType.ACTIVITY_FEED_FILTER_SETTING)) {
                FilterRegistry.add(FilterUtil.getEventFilterFromSettings(setting));
                SettingsCache.getInstance().putSettings(setting);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

