/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestCaseParameter;
import org.openmetadata.schema.tests.TestCaseParameterValue;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class TestCaseRepository
extends EntityRepository<TestCase> {
    public static final String COLLECTION_PATH = "/v1/testCase";
    private static final String UPDATE_FIELDS = "owner,entityLink,testSuite,testDefinition";
    private static final String PATCH_FIELDS = "owner,entityLink,testSuite,testDefinition";
    public static final String TESTCASE_RESULT_EXTENSION = "testCase.testCaseResult";

    public TestCaseRepository(CollectionDAO dao) {
        super(COLLECTION_PATH, "testCase", TestCase.class, dao.testCaseDAO(), dao, "owner,entityLink,testSuite,testDefinition", "owner,entityLink,testSuite,testDefinition");
    }

    @Override
    public TestCase setFields(TestCase test, EntityUtil.Fields fields) throws IOException {
        test.setTestSuite(fields.contains("testSuite") ? this.getTestSuite(test) : null);
        test.setTestDefinition(fields.contains("testDefinition") ? this.getTestDefinition(test) : null);
        test.setTestCaseResult(fields.contains("testCaseResult") ? this.getTestCaseResult(test) : null);
        test.setOwner(fields.contains("owner") ? this.getOwner(test) : null);
        return test;
    }

    @Override
    public void prepare(TestCase test) throws IOException {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        EntityUtil.validateEntityLink(entityLink);
        Entity.getEntityReferenceById("testDefinition", test.getTestDefinition().getId(), Include.NON_DELETED);
        Entity.getEntityReferenceById("testSuite", test.getTestSuite().getId(), Include.NON_DELETED);
        TestDefinition testDefinition = (TestDefinition)Entity.getEntity(test.getTestDefinition(), EntityUtil.Fields.EMPTY_FIELDS, Include.NON_DELETED);
        this.validateTestParameters(test.getParameterValues(), testDefinition.getParameterDefinition());
        test.setFullyQualifiedName(FullyQualifiedName.add(entityLink.getFullyQualifiedFieldValue(), test.getName()));
        test.setEntityFQN(entityLink.getFullyQualifiedFieldValue());
    }

    private EntityReference getTestSuite(TestCase test) throws IOException {
        return this.getFromEntityRef(test.getId(), Relationship.CONTAINS, "testSuite", true);
    }

    private EntityReference getTestDefinition(TestCase test) throws IOException {
        return this.getFromEntityRef(test.getId(), Relationship.APPLIED_TO, "testDefinition", true);
    }

    private void validateTestParameters(List<TestCaseParameterValue> parameterValues, List<TestCaseParameter> parameterDefinition) {
        if (parameterDefinition.isEmpty() && !parameterValues.isEmpty()) {
            throw new IllegalArgumentException("Parameter Values doesn't match Test Definition Parameters");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (TestCaseParameterValue testCaseParameterValue : parameterValues) {
            values.put(testCaseParameterValue.getName(), testCaseParameterValue.getValue());
        }
        for (TestCaseParameter parameter : parameterDefinition) {
            if (!Boolean.TRUE.equals(parameter.getRequired()) || values.containsKey(parameter.getName()) && values.get(parameter.getName()) != null) continue;
            throw new IllegalArgumentException("Required parameter " + parameter.getName() + " is not passed in parameterValues");
        }
    }

    @Override
    public void storeEntity(TestCase test, boolean update) throws IOException {
        EntityReference owner = test.getOwner();
        EntityReference testSuite = test.getTestSuite();
        EntityReference testDefinition = test.getTestDefinition();
        test.withOwner(null).withHref(null).withTestSuite(null).withTestDefinition(null);
        this.store(test.getId(), test, update);
        test.withOwner(owner).withTestSuite(testSuite).withTestDefinition(testDefinition);
    }

    @Override
    public void storeRelationships(TestCase test) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        EntityReference tableRef = EntityUtil.validateEntityLink(entityLink);
        this.addRelationship(test.getTestSuite().getId(), test.getId(), "testSuite", "testCase", Relationship.CONTAINS);
        this.addRelationship(tableRef.getId(), test.getId(), tableRef.getType(), "testCase", Relationship.CONTAINS);
        this.addRelationship(test.getTestDefinition().getId(), test.getId(), "testDefinition", "testCase", Relationship.APPLIED_TO);
        this.storeOwner(test, test.getOwner());
    }

    @Transaction
    public RestUtil.PutResponse<?> addTestCaseResult(UriInfo uriInfo, String fqn, TestCaseResult testCaseResult) throws IOException {
        TestCase testCase = (TestCase)this.dao.findEntityByName(fqn);
        TestCaseResult storedTestCaseResult = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION, testCaseResult.getTimestamp()), TestCaseResult.class);
        if (storedTestCaseResult != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().update(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION, JsonUtils.pojoToJson(testCaseResult), testCaseResult.getTimestamp());
        } else {
            this.daoCollection.entityExtensionTimeSeriesDao().insert(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION, "testCaseResult", JsonUtils.pojoToJson(testCaseResult));
        }
        this.setFieldsInternal(testCase, new EntityUtil.Fields(this.allowedFields, "testSuite"));
        ChangeDescription change = this.addTestCaseChangeDescription(testCase.getVersion(), testCaseResult, storedTestCaseResult);
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)this.withHref(uriInfo, testCase), change, this.entityType, testCase.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    @Transaction
    public RestUtil.PutResponse<?> deleteTestCaseResult(String fqn, Long timestamp) throws IOException {
        TestCase testCase = (TestCase)this.dao.findEntityByName(fqn);
        TestCaseResult storedTestCaseResult = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp), TestCaseResult.class);
        if (storedTestCaseResult != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().deleteAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp);
            testCase.setTestCaseResult(storedTestCaseResult);
            ChangeDescription change = this.deleteTestCaseChangeDescription(testCase.getVersion(), storedTestCaseResult);
            ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)testCase, change, this.entityType, testCase.getVersion());
            return new RestUtil.PutResponse(Response.Status.OK, changeEvent, "entityFieldsChanged");
        }
        throw new EntityNotFoundException(String.format("Failed to find testCase result for %s at %s", testCase.getName(), timestamp));
    }

    private ChangeDescription addTestCaseChangeDescription(Double version, Object newValue, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName("testCaseResult").withNewValue(newValue).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsUpdated().add(fieldChange);
        return change;
    }

    private ChangeDescription deleteTestCaseChangeDescription(Double version, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName("testCaseResult").withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsDeleted().add(fieldChange);
        return change;
    }

    private ChangeEvent getChangeEvent(EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updated.getUpdatedBy()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    private TestCaseResult getTestCaseResult(TestCase testCase) throws IOException {
        return JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION), TestCaseResult.class);
    }

    public ResultList<TestCaseResult> getTestCaseResults(String fqn, Long startTs, Long endTs) throws IOException {
        List<TestCaseResult> testCaseResults = JsonUtils.readObjects(this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestamps(fqn, TESTCASE_RESULT_EXTENSION, startTs, endTs), TestCaseResult.class);
        return new ResultList<TestCaseResult>(testCaseResults, String.valueOf(startTs), String.valueOf(endTs), testCaseResults.size());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestCase original, TestCase updated, EntityRepository.Operation operation) {
        return new TestUpdater(original, updated, operation);
    }

    public class TestUpdater
    extends EntityRepository.EntityUpdater {
        public TestUpdater(TestCase original, TestCase updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestCaseRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            MessageParser.EntityLink origEntityLink = MessageParser.EntityLink.parse(((TestCase)this.original).getEntityLink());
            EntityReference origTableRef = EntityUtil.validateEntityLink(origEntityLink);
            MessageParser.EntityLink updatedEntityLink = MessageParser.EntityLink.parse(((TestCase)this.updated).getEntityLink());
            EntityReference updatedTableRef = EntityUtil.validateEntityLink(updatedEntityLink);
            this.updateFromRelationships("entity", updatedTableRef.getType(), new ArrayList<EntityReference>(List.of(origTableRef)), new ArrayList<EntityReference>(List.of(updatedTableRef)), Relationship.CONTAINS, "testCase", ((TestCase)this.updated).getId());
            this.updateFromRelationships("testSuite", "testSuite", new ArrayList<EntityReference>(List.of(((TestCase)this.original).getTestSuite())), new ArrayList<EntityReference>(List.of(((TestCase)this.updated).getTestSuite())), Relationship.HAS, "testCase", ((TestCase)this.updated).getId());
            this.updateFromRelationships("testDefinition", "testDefinition", new ArrayList<EntityReference>(List.of(((TestCase)this.original).getTestDefinition())), new ArrayList<EntityReference>(List.of(((TestCase)this.updated).getTestDefinition())), Relationship.APPLIED_TO, "testCase", ((TestCase)this.updated).getId());
            this.recordChange("parameterValues", ((TestCase)this.original).getParameterValues(), ((TestCase)this.updated).getParameterValues());
        }
    }
}

