/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TokenRepository.class);
    private final CollectionDAO dao;

    public TokenRepository(CollectionDAO dao) {
        this.dao = dao;
    }

    public TokenInterface findByToken(String token) {
        return this.dao.getTokenDAO().findByToken(token);
    }

    public List<TokenInterface> findByUserIdAndType(String userId, String type) {
        return this.dao.getTokenDAO().getAllUserTokenWithType(userId, type);
    }

    public void insertToken(TokenInterface tokenInterface) throws JsonProcessingException {
        this.dao.getTokenDAO().insert(JsonUtils.pojoToJson(tokenInterface));
    }

    public void updateToken(TokenInterface tokenInterface) throws JsonProcessingException {
        this.dao.getTokenDAO().update(tokenInterface.getToken().toString(), JsonUtils.pojoToJson(tokenInterface));
    }

    public void deleteToken(String token) {
        try {
            this.dao.getTokenDAO().delete(token);
        }
        catch (Exception ex) {
            LOG.info("Token not present for the user");
        }
    }

    public void deleteTokenByUserAndType(String userId, String type) {
        try {
            this.dao.getTokenDAO().deleteTokenByUserAndType(userId, type);
        }
        catch (Exception ex) {
            LOG.info("Token not present for the user");
        }
    }
}

