/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.topic.TopicSampleData;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class TopicRepository
extends EntityRepository<Topic> {
    private static final String TOPIC_UPDATE_FIELDS = "owner,tags,extension";
    private static final String TOPIC_PATCH_FIELDS = "owner,tags,extension";

    @Override
    public void setFullyQualifiedName(Topic topic) {
        topic.setFullyQualifiedName(FullyQualifiedName.add(topic.getService().getName(), topic.getName()));
    }

    public TopicRepository(CollectionDAO dao) {
        super("v1/topics/", "topic", Topic.class, dao.topicDAO(), dao, "owner,tags,extension", "owner,tags,extension");
    }

    @Override
    public void prepare(Topic topic) throws IOException {
        MessagingService messagingService = (MessagingService)Entity.getEntity(topic.getService(), EntityUtil.Fields.EMPTY_FIELDS, Include.ALL);
        topic.setService(messagingService.getEntityReference());
        topic.setServiceType(messagingService.getServiceType());
        this.setFullyQualifiedName(topic);
        topic.setTags(this.addDerivedTags(topic.getTags()));
    }

    @Override
    public void storeEntity(Topic topic, boolean update) throws IOException {
        EntityReference owner = topic.getOwner();
        List tags = topic.getTags();
        EntityReference service = topic.getService();
        topic.withOwner(null).withService(null).withHref(null).withTags(null);
        this.store(topic.getId(), topic, update);
        topic.withOwner(owner).withService(service).withTags(tags);
    }

    @Override
    public void storeRelationships(Topic topic) {
        this.setService(topic, topic.getService());
        this.storeOwner(topic, topic.getOwner());
        this.applyTags(topic);
    }

    @Override
    public Topic setFields(Topic topic, EntityUtil.Fields fields) throws IOException {
        topic.setService(this.getContainer(topic.getId()));
        topic.setFollowers(fields.contains("followers") ? this.getFollowers(topic) : null);
        topic.setSampleData(fields.contains("sampleData") ? this.getSampleData(topic) : null);
        return topic;
    }

    public TopicUpdater getUpdater(Topic original, Topic updated, EntityRepository.Operation operation) {
        return new TopicUpdater(original, updated, operation);
    }

    public void setService(Topic topic, EntityReference service) {
        if (service != null && topic != null) {
            this.addRelationship(service.getId(), topic.getId(), service.getType(), "topic", Relationship.CONTAINS);
            topic.setService(service);
        }
    }

    private TopicSampleData getSampleData(Topic topic) throws IOException {
        return JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(topic.getId().toString(), "topic.sampleData"), TopicSampleData.class);
    }

    @Transaction
    public Topic addSampleData(UUID topicId, TopicSampleData sampleData) throws IOException {
        Topic topic = (Topic)this.daoCollection.topicDAO().findEntityById(topicId);
        this.daoCollection.entityExtensionDAO().insert(topicId.toString(), "topic.sampleData", "topicSampleData", JsonUtils.pojoToJson(sampleData));
        this.setFieldsInternal(topic, EntityUtil.Fields.EMPTY_FIELDS);
        return topic.withSampleData(sampleData);
    }

    public class TopicUpdater
    extends EntityRepository.EntityUpdater {
        public TopicUpdater(Topic original, Topic updated, EntityRepository.Operation operation) {
            super((EntityRepository)TopicRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("maximumMessageSize", ((Topic)this.original).getMaximumMessageSize(), ((Topic)this.updated).getMaximumMessageSize());
            this.recordChange("minimumInSyncReplicas", ((Topic)this.original).getMinimumInSyncReplicas(), ((Topic)this.updated).getMinimumInSyncReplicas());
            this.recordChange("partitions", ((Topic)this.original).getPartitions(), ((Topic)this.updated).getPartitions());
            this.recordChange("replicationFactor", ((Topic)this.original).getReplicationFactor(), ((Topic)this.updated).getReplicationFactor());
            this.recordChange("retentionTime", ((Topic)this.original).getRetentionTime(), ((Topic)this.updated).getRetentionTime());
            this.recordChange("retentionSize", ((Topic)this.original).getRetentionSize(), ((Topic)this.updated).getRetentionSize());
            this.recordChange("schemaText", ((Topic)this.original).getSchemaText(), ((Topic)this.updated).getSchemaText());
            this.recordChange("schemaType", ((Topic)this.original).getSchemaType(), ((Topic)this.updated).getSchemaType());
            this.recordChange("topicConfig", ((Topic)this.original).getTopicConfig(), ((Topic)this.updated).getTopicConfig());
            this.updateCleanupPolicies((Topic)this.original, (Topic)this.updated);
        }

        private void updateCleanupPolicies(Topic original, Topic updated) throws JsonProcessingException {
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("cleanupPolicies", original.getCleanupPolicies(), updated.getCleanupPolicies(), added, deleted, Enum::equals);
        }
    }
}

