/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources;

import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.setup.Environment;
import io.swagger.annotations.Api;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.schema.Function;
import org.openmetadata.schema.type.CollectionDescriptor;
import org.openmetadata.schema.type.CollectionInfo;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.RestUtil;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionRegistry.class);
    private static CollectionRegistry instance = null;
    private final Map<String, CollectionDetails> collectionMap = new LinkedHashMap<String, CollectionDetails>();
    private final Map<Class<?>, List<org.openmetadata.schema.type.Function>> functionMap = new ConcurrentHashMap();
    private final List<String> resourceBasedFunctions = new ArrayList<String>();
    @VisibleForTesting
    private final List<Object> testResources = new ArrayList<Object>();

    private CollectionRegistry() {
    }

    public static CollectionRegistry getInstance() {
        if (instance == null) {
            instance = new CollectionRegistry();
            instance.initialize();
        }
        return instance;
    }

    public List<org.openmetadata.schema.type.Function> getFunctions(Class<?> clz) {
        return this.functionMap.get(clz);
    }

    private void initialize() {
        this.loadCollectionDescriptors();
        this.loadConditionFunctions();
    }

    public CollectionDescriptor[] getCollectionForPath(String collectionPath, UriInfo uriInfo) {
        CollectionDescriptor[] children;
        CollectionDetails parent = this.collectionMap.get(collectionPath);
        for (CollectionDescriptor child : children = parent.getChildCollections()) {
            URI href = child.getCollection().getHref();
            child.getCollection().setHref(RestUtil.getHref(uriInfo, href.getPath()));
        }
        return children;
    }

    public Map<String, CollectionDetails> getCollectionMap() {
        return Collections.unmodifiableMap(this.collectionMap);
    }

    private void loadCollectionDescriptors() {
        List<CollectionDetails> collections = CollectionRegistry.getCollections();
        for (int i = 0; i < 10; ++i) {
            for (CollectionDetails collection : collections) {
                if (collection.order != i) continue;
                CollectionInfo collectionInfo = collection.cd.getCollection();
                this.collectionMap.put(collectionInfo.getHref().getPath(), collection);
            }
        }
        for (CollectionDetails details : this.collectionMap.values()) {
            String parent;
            CollectionDetails parentCollection;
            CollectionInfo collectionInfo = details.cd.getCollection();
            if (collectionInfo.getName().equals("root") || (parentCollection = this.collectionMap.get(parent = new File(collectionInfo.getHref().getPath()).getParent())) == null) continue;
            this.collectionMap.get(parent).addChildCollection(details);
        }
    }

    private void loadConditionFunctions() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"org.openmetadata.service", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new MethodAnnotationsScanner()}));
        Set methods = reflections.getMethodsAnnotatedWith(Function.class);
        for (Method method : methods) {
            Function annotation = method.getAnnotation(Function.class);
            List functionList = this.functionMap.computeIfAbsent(method.getDeclaringClass(), k -> new ArrayList());
            org.openmetadata.schema.type.Function function = new org.openmetadata.schema.type.Function().withName(annotation.name()).withInput(annotation.input()).withDescription(annotation.description()).withExamples(List.of(annotation.examples()));
            functionList.add(function);
            functionList.sort(Comparator.comparing(org.openmetadata.schema.type.Function::getName));
            if (annotation.resourceBased()) {
                this.resourceBasedFunctions.add(annotation.name());
            }
            LOG.info("Initialized for {} function {}\n", (Object)method.getDeclaringClass().getSimpleName(), (Object)function);
        }
    }

    @VisibleForTesting
    public static void addTestResource(Object testResource) {
        CollectionRegistry.getInstance().testResources.add(testResource);
    }

    public void registerResources(Jdbi jdbi, Environment environment, OpenMetadataApplicationConfig config, Authorizer authorizer, SecretsManager secretsManager) {
        for (Map.Entry<String, CollectionDetails> e : this.collectionMap.entrySet()) {
            CollectionDetails details = e.getValue();
            String resourceClass = details.resourceClass;
            try {
                CollectionDAO daoObject = (CollectionDAO)jdbi.onDemand(CollectionDAO.class);
                Objects.requireNonNull(daoObject, "CollectionDAO must not be null");
                Object resource = CollectionRegistry.createResource(daoObject, resourceClass, config, authorizer, secretsManager);
                details.setResource(resource);
                environment.jersey().register(resource);
                LOG.info("Registering {} with order {}", (Object)resourceClass, (Object)details.order);
            }
            catch (Exception ex) {
                LOG.warn("Failed to create resource for class {} {}", (Object)resourceClass, (Object)ex);
            }
        }
        this.testResources.forEach(object -> {
            LOG.info("Registering test resource {}", object);
            environment.jersey().register(object);
        });
    }

    private static CollectionDetails getCollection(Class<?> cl) {
        int order = 0;
        String href = null;
        String doc = null;
        String name = null;
        for (Annotation a : cl.getAnnotations()) {
            if (a instanceof Path) {
                href = ((Path)a).value();
                continue;
            }
            if (a instanceof Api) {
                doc = ((Api)a).value();
                continue;
            }
            if (!(a instanceof Collection)) continue;
            name = ((Collection)a).name();
            order = ((Collection)a).order();
        }
        CollectionDescriptor cd = new CollectionDescriptor();
        cd.setCollection(new CollectionInfo().withName(name).withDocumentation(doc).withHref(URI.create(href)));
        return new CollectionDetails(cd, cl.getCanonicalName(), order);
    }

    private static List<CollectionDetails> getCollections() {
        Reflections reflections = new Reflections("org.openmetadata.service.resources", new Scanner[0]);
        Set collectionClasses = reflections.getTypesAnnotatedWith(Collection.class);
        ArrayList<CollectionDetails> collections = new ArrayList<CollectionDetails>();
        for (Class cl : collectionClasses) {
            CollectionDetails cd = CollectionRegistry.getCollection(cl);
            collections.add(cd);
        }
        return collections;
    }

    private static Object createResource(CollectionDAO daoObject, String resourceClass, OpenMetadataApplicationConfig config, Authorizer authorizer, SecretsManager secretsManager) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object resource;
        Class<?> clz = Class.forName(resourceClass);
        try {
            resource = clz.getDeclaredConstructor(CollectionDAO.class, Authorizer.class).newInstance(daoObject, authorizer);
        }
        catch (NoSuchMethodException e) {
            try {
                resource = clz.getDeclaredConstructor(CollectionDAO.class, Authorizer.class, SecretsManager.class).newInstance(daoObject, authorizer, secretsManager);
            }
            catch (NoSuchMethodException ex) {
                try {
                    resource = clz.getDeclaredConstructor(OpenMetadataApplicationConfig.class).newInstance(new Object[]{config});
                }
                catch (NoSuchMethodException exc) {
                    resource = Class.forName(resourceClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        try {
            Method initializeMethod = resource.getClass().getMethod("initialize", OpenMetadataApplicationConfig.class);
            initializeMethod.invoke(resource, new Object[]{config});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return resource;
    }

    public List<String> getResourceBasedFunctions() {
        return this.resourceBasedFunctions;
    }

    public static class CollectionDetails {
        private final int order;
        private final String resourceClass;
        private final CollectionDescriptor cd;
        private final List<CollectionDescriptor> childCollections = new ArrayList<CollectionDescriptor>();
        private Object resource;

        CollectionDetails(CollectionDescriptor cd, String resourceClass, int order) {
            this.cd = cd;
            this.resourceClass = resourceClass;
            this.order = order;
        }

        public void addChildCollection(CollectionDetails child) {
            CollectionInfo collectionInfo = child.cd.getCollection();
            LOG.info("Adding child collection {} to parent collection {}", (Object)collectionInfo.getName(), (Object)this.cd.getCollection().getName());
            this.childCollections.add(child.cd);
        }

        public CollectionDescriptor[] getChildCollections() {
            return this.childCollections.toArray(new CollectionDescriptor[0]);
        }

        public String getResourceClass() {
            return this.resourceClass;
        }

        public Object getResource() {
            return this.resource;
        }

        public void setResource(Object resource) {
            this.resource = resource;
        }
    }
}

