/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.bots;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.CreateBot;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.BotType;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.BotRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/bots")
@Api(value="Bot collection", tags={"Bot collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="bots")
public class BotResource
extends EntityResource<Bot, BotRepository> {
    public static final String COLLECTION_PATH = "/v1/bots/";
    final SecretsManager secretsManager;

    public BotResource(CollectionDAO dao, Authorizer authorizer, SecretsManager secretsManager) {
        super(Bot.class, new BotRepository(dao, secretsManager), authorizer);
        this.secretsManager = secretsManager;
    }

    @Override
    public Bot addHref(UriInfo uriInfo, Bot entity) {
        Entity.withHref(uriInfo, entity.getBotUser());
        return entity;
    }

    @GET
    @Operation(operationId="listBots", summary="List Bot", tags={"bots"}, description="Get a list of Bot.", responses={@ApiResponse(responseCode="200", description="List of Bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=BotList.class))})})
    public ResultList<Bot> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of Bot before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of Bot after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return this.listInternal(uriInfo, securityContext, "", new ListFilter(include), limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getBotByID", summary="Get a bot", tags={"bots"}, description="Get a bot by `id`.", responses={@ApiResponse(responseCode="200", description="The bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Bot get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include, @PathParam(value="id") UUID id) throws IOException {
        return (Bot)this.getInternal(uriInfo, securityContext, id, "", include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getBotByFQN", summary="Get a bot by name", tags={"bots"}, description="Get a bot by name.", responses={@ApiResponse(responseCode="200", description="bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="404", description="Bot for instance {name} is not found")})
    public Bot getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the table", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Bot)this.getByNameInternal(uriInfo, securityContext, fqn, "", include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllBotVersion", summary="List bot versions", tags={"bots"}, description="Get a list of all the versions of a bot identified by `id`", responses={@ApiResponse(responseCode="200", description="List of bot versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="bot Id", schema=@Schema(type="uuid")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="listSpecificBotVersion", summary="Get a version of the bot", tags={"bots"}, description="Get a version of the bot by given `id`", responses={@ApiResponse(responseCode="200", description="bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="404", description="Bot for instance {id} and version {version} is not found")})
    public Bot getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="bot Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="bot version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Bot)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createBot", summary="Create a bot", tags={"bots"}, description="Create a new bot.", responses={@ApiResponse(responseCode="200", description="The bot ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateBot create) throws IOException {
        Bot bot = this.getBot(securityContext, create);
        return this.create(uriInfo, securityContext, bot, false);
    }

    @PUT
    @Operation(operationId="createOrUpdateBot", summary="Create or update a bot", tags={"bots"}, description="Create a bot, if it does not exist. If a bot already exists, update the bot.", responses={@ApiResponse(responseCode="200", description="The bot", content={@Content(mediaType="application/json", schema=@Schema(implementation=Bot.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateBot create) throws IOException {
        Bot bot = this.getBot(securityContext, create);
        Response response = this.createOrUpdate(uriInfo, securityContext, bot, false);
        if (!BotType.BOT.equals((Object)(bot = (Bot)response.getEntity()).getBotType())) {
            this.secretsManager.encryptOrDecryptBotCredentials(bot.getBotType().value(), bot.getBotUser().getName(), true);
        }
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchBot", summary="Update a bot", tags={"bots"}, description="Update an existing bot using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the bot", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteBot", summary="Delete a bot", tags={"bots"}, description="Delete a bot by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the Bot", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        BotType botType = ((Bot)((BotRepository)this.dao).get(null, id, EntityUtil.Fields.EMPTY_FIELDS)).getBotType();
        if (!BotType.BOT.equals((Object)botType)) {
            throw new IllegalArgumentException(String.format("[%s] can not be deleted.", botType.value()));
        }
        return this.delete(uriInfo, securityContext, id, true, hardDelete, false);
    }

    private Bot getBot(CreateBot create, String user) throws IOException {
        return this.copy(new Bot(), (CreateEntity)create, user).withBotUser(create.getBotUser()).withBotType(BotType.BOT).withFullyQualifiedName(create.getName());
    }

    private boolean userHasRelationshipWithAnyBot(User user, Bot botUser) {
        if (user == null) {
            return false;
        }
        List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(user);
        return !userBotRelationship.isEmpty() && (botUser == null || userBotRelationship.stream().anyMatch(relationship -> !relationship.getId().equals(botUser.getId())));
    }

    private List<CollectionDAO.EntityRelationshipRecord> retrieveBotRelationshipsFor(User user) {
        return ((BotRepository)this.dao).findFrom(user.getId(), "user", Relationship.CONTAINS, "bot");
    }

    private Bot getBot(SecurityContext securityContext, CreateBot create) throws IOException {
        Bot bot = this.getBot(create, securityContext.getUserPrincipal().getName());
        Bot originalBot = this.retrieveBot(bot.getName());
        User botUser = this.retrieveUser(bot);
        if (botUser != null && !Boolean.TRUE.equals(botUser.getIsBot())) {
            throw new IllegalArgumentException(String.format("User [%s] is not a bot user", botUser.getName()));
        }
        if (this.userHasRelationshipWithAnyBot(botUser, originalBot)) {
            List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(botUser);
            bot = (Bot)((BotRepository)this.dao).get(null, ((CollectionDAO.EntityRelationshipRecord)userBotRelationship.stream().findFirst().orElseThrow()).getId(), EntityUtil.Fields.EMPTY_FIELDS);
            throw new IllegalArgumentException(String.format("Bot user [%s] is already used by [%s] bot", botUser.getName(), bot.getName()));
        }
        return bot;
    }

    private User retrieveUser(Bot bot) {
        try {
            return (User)((UserRepository)UserRepository.class.cast(Entity.getEntityRepository("user"))).get(null, bot.getBotUser().getId(), EntityUtil.Fields.EMPTY_FIELDS);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Bot retrieveBot(String botName) {
        try {
            return (Bot)((BotRepository)this.dao).getByName(null, botName, EntityUtil.Fields.EMPTY_FIELDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class BotList
    extends ResultList<Bot> {
        public BotList() {
        }

        public BotList(List<Bot> data) {
            super(data);
        }
    }
}

