/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.databases;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.CreateTable;
import org.openmetadata.schema.api.data.CreateTableProfile;
import org.openmetadata.schema.api.tests.CreateCustomMetric;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.CustomMetric;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.ColumnProfile;
import org.openmetadata.schema.type.DataModel;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.SQLQuery;
import org.openmetadata.schema.type.TableData;
import org.openmetadata.schema.type.TableJoins;
import org.openmetadata.schema.type.TableProfile;
import org.openmetadata.schema.type.TableProfilerConfig;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TableRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/tables")
@Api(value="Tables collection", tags={"Tables collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="tables")
public class TableResource
extends EntityResource<Table, TableRepository> {
    public static final String COLLECTION_PATH = "v1/tables/";
    static final String FIELDS = "tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,sampleData,viewDefinition,tableProfilerConfig,profile,location,tableQueries,dataModel,tests,extension";

    @Override
    public Table addHref(UriInfo uriInfo, Table table) {
        Entity.withHref(uriInfo, table.getDatabaseSchema());
        Entity.withHref(uriInfo, table.getDatabase());
        Entity.withHref(uriInfo, table.getService());
        Entity.withHref(uriInfo, table.getLocation());
        Entity.withHref(uriInfo, table.getOwner());
        Entity.withHref(uriInfo, table.getFollowers());
        return table;
    }

    @Override
    protected MetadataOperation[] getViewOperations(EntityUtil.Fields fields) {
        ArrayList<MetadataOperation> operations = new ArrayList<MetadataOperation>(List.of(MetadataOperation.VIEW_BASIC));
        if (fields.contains("tests")) {
            operations.add(MetadataOperation.VIEW_TESTS);
        }
        if (fields.contains("tableQueries")) {
            operations.add(MetadataOperation.VIEW_QUERIES);
        }
        if (fields.contains("profile")) {
            operations.add(MetadataOperation.VIEW_DATA_PROFILE);
        }
        if (fields.contains("sampleData")) {
            operations.add(MetadataOperation.VIEW_SAMPLE_DATA);
        }
        if (operations.size() == 5) {
            return EntityResource.VIEW_ALL_OPERATIONS;
        }
        return operations.toArray(new MetadataOperation[0]);
    }

    public TableResource(CollectionDAO dao, Authorizer authorizer) {
        super(Table.class, new TableRepository(dao), authorizer);
        this.allowedFields.add("tests");
        this.allowedFields.add("customMetrics");
    }

    @GET
    @Operation(operationId="listTables", summary="List tables", tags={"tables"}, description="Get a list of tables, optionally filtered by `database` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of tables", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableList.class))})})
    public ResultList<Table> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,sampleData,viewDefinition,tableProfilerConfig,profile,location,tableQueries,dataModel,tests,extension")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter tables by database fully qualified name", schema=@Schema(type="string", example="snowflakeWestCoast.financeDB")) @QueryParam(value="database") String databaseParam, @Parameter(description="Limit the number tables returned. (1 to 1000000, default = 10) ") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tables before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tables after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include).addQueryParam("database", databaseParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getTableByID", summary="Get a table", tags={"tables"}, description="Get a table by `id`", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Table get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="table Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,sampleData,viewDefinition,tableProfilerConfig,profile,location,tableQueries,dataModel,tests,extension")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Table)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getTableByFQN", summary="Get a table by name", tags={"tables"}, description="Get a table by fully qualified table name.", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Table getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the table", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,sampleData,viewDefinition,tableProfilerConfig,profile,location,tableQueries,dataModel,tests,extension")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Table)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTableVersion", summary="List table versions", tags={"tables"}, description="Get a list of all the versions of a table identified by `id`", responses={@ApiResponse(responseCode="200", description="List of table versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="table Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDatabaseVersion", summary="Get a version of the table", tags={"tables"}, description="Get a version of the table by given `id`", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} and version {version} is not found")})
    public Table getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="table Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="table version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Table)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createTable", summary="Create a table", tags={"tables"}, description="Create a new table under an existing `database`.", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTable create) throws IOException {
        Table table = this.getTable(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, table, true);
    }

    @PUT
    @Operation(operationId="createOrUpdateTable", summary="Create or update a table", tags={"tables"}, description="Create a table, if it does not exist. If a table already exists, update the table.", responses={@ApiResponse(responseCode="200", description="The table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTable create) throws IOException {
        Table table = this.getTable(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, table, true);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchTable", summary="Update a table", tags={"tables"}, description="Update an existing table using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTable", summary="Delete a table", tags={"tables"}, description="Delete a table by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, false, hardDelete, true);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteTable", summary="Delete a table", tags={"tables"}, description="Delete a table by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Table for instance {fqn} is not found")})
    public Response deleteByFqn(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the table", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) throws IOException {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete, true);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollowerToTable", summary="Add a follower", tags={"tables"}, description="Add a user identified by `userId` as followed of this table", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="string")) UUID userId) throws IOException {
        return ((TableRepository)this.dao).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @PUT
    @Path(value="/{id}/joins")
    @Operation(operationId="addTableJoinInfo", summary="Add table join information", description="Add information about other tables that this table is joined with. Join information can only be added for the last 30 days starting today.", tags={"tables"}, responses={@ApiResponse(responseCode="200", description="Successfully updated the Table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found"), @ApiResponse(responseCode="400", description="Date range can only include past 30 days starting today")})
    public Table addJoins(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TableJoins joins) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        Table table = ((TableRepository)this.dao).addJoins(id, joins);
        return this.addHref(uriInfo, table);
    }

    @PUT
    @Path(value="/{id}/sampleData")
    @Operation(operationId="addSampleData", summary="Add sample data", tags={"tables"}, description="Add sample data to the table.", responses={@ApiResponse(responseCode="200", description="Successfully update the Table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TableData tableData) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_SAMPLE_DATA);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        Table table = ((TableRepository)this.dao).addSampleData(id, tableData);
        return this.addHref(uriInfo, table);
    }

    @PUT
    @Path(value="/{id}/tableProfilerConfig")
    @Operation(operationId="addDataProfilerConfig", summary="Add table profile Config", tags={"tables"}, description="Add table profile config to the table.", responses={@ApiResponse(responseCode="200", description="Successfully updated the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addDataProfilerConfig(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TableProfilerConfig tableProfilerConfig) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        Table table = ((TableRepository)this.dao).addTableProfilerConfig(id, tableProfilerConfig);
        return this.addHref(uriInfo, table);
    }

    @GET
    @Path(value="/{id}/tableProfilerConfig")
    @Operation(operationId="getDataProfilerConfig", summary="Get table profile Config", tags={"tables"}, description="Get table profile config to the table.", responses={@ApiResponse(responseCode="200", description="Successfully updated the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table getDataProfilerConfig(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        Table table = (Table)((TableRepository)this.dao).get(uriInfo, id, EntityUtil.Fields.EMPTY_FIELDS);
        return this.addHref(uriInfo, table.withTableProfilerConfig(((TableRepository)this.dao).getTableProfilerConfig(table)));
    }

    @DELETE
    @Path(value="/{id}/tableProfilerConfig")
    @Operation(operationId="delete DataProfilerConfig", summary="delete table profiler config", tags={"tables"}, description="delete table profile config to the table.", responses={@ApiResponse(responseCode="200", description="Successfully deleted the Table profiler config", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table deleteDataProfilerConfig(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        Table table = ((TableRepository)this.dao).deleteTableProfilerConfig(id);
        return this.addHref(uriInfo, table);
    }

    @GET
    @Path(value="/{fqn}/tableProfile")
    @Operation(operationId="list Profiles", summary="List of profiles", tags={"tables"}, description="Get a list of all the table profiles for the given table fqn, optionally filtered by `extension`, `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of table profiles", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableProfileList.class))})})
    public ResultList<TableProfile> listTableProfiles(@Context SecurityContext securityContext, @Parameter(description="FQN of the table or column", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter table/column profiles after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter table/column profiles before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") Long endTs) throws IOException {
        return ((TableRepository)this.dao).getTableProfiles(fqn, startTs, endTs);
    }

    @GET
    @Path(value="/{fqn}/columnProfile")
    @Operation(operationId="list column Profiles", summary="List of profiles", tags={"tables"}, description="Get a list of all the column profiles for the given table fqn, optionally filtered by `extension`, `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of table profiles", content={@Content(mediaType="application/json", schema=@Schema(implementation=ColumnProfileList.class))})})
    public ResultList<ColumnProfile> listColumnProfiles(@Context SecurityContext securityContext, @Parameter(description="FQN of the column", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter table/column profiles after the given start timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter table/column profiles before the given end timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="endTs") Long endTs) throws IOException {
        return ((TableRepository)this.dao).getColumnProfiles(fqn, startTs, endTs);
    }

    @PUT
    @Path(value="/{id}/tableProfile")
    @Operation(operationId="addDataProfiler", summary="Add table profile data", tags={"tables"}, description="Add table profile data to the table.", responses={@ApiResponse(responseCode="200", description="Successfully updated the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addDataProfiler(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid CreateTableProfile createTableProfile) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        Table table = ((TableRepository)this.dao).addTableProfileData(id, createTableProfile);
        return this.addHref(uriInfo, table);
    }

    @DELETE
    @Path(value="/{fqn}/{entityType}/{timestamp}/profile")
    @Operation(operationId="DeleteDataProfiler", summary="Delete table profile data", tags={"tables"}, description="Delete table profile data to the table.", responses={@ApiResponse(responseCode="200", description="Successfully deleted the Table Profile", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableProfile.class))})})
    public Response deleteDataProfiler(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="FQN of the table or column", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn, @Parameter(description="type of the entity table or column", schema=@Schema(type="String")) @PathParam(value="entityType") String entityType, @Parameter(description="Timestamp of the table profile", schema=@Schema(type="long")) @PathParam(value="timestamp") Long timestamp) throws IOException {
        OperationContext operationContext = new OperationContext(entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn), true);
        ((TableRepository)this.dao).deleteTableProfile(fqn, entityType, timestamp);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{id}/location")
    @Operation(operationId="addLocationToTable", summary="Add a location", tags={"tables"}, description="Add a location identified by `locationId` to this table", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Response addLocation(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the location to be added", schema=@Schema(type="UUID")) UUID locationId) throws IOException {
        Table table = ((TableRepository)this.dao).addLocation(id, locationId);
        return Response.ok().entity((Object)table).build();
    }

    @PUT
    @Path(value="/{id}/tableQuery")
    @Operation(operationId="addTableQuery", summary="Add table query data", tags={"tables"}, description="Add table query data to the table.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addQuery(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid SQLQuery sqlQuery) throws IOException {
        this.authorizer.authorizeAdmin(securityContext, true);
        Table table = ((TableRepository)this.dao).addQuery(id, sqlQuery);
        return this.addHref(uriInfo, table);
    }

    @PUT
    @Path(value="/{id}/dataModel")
    @Operation(operationId="addDataModel", summary="Add data modeling information to a table", tags={"tables"}, description="Add data modeling (such as DBT model) information on how the table was created to the table.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addDataModel(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Valid DataModel dataModel) throws IOException {
        this.authorizer.authorizeAdmin(securityContext, true);
        Table table = ((TableRepository)this.dao).addDataModel(id, dataModel);
        return this.addHref(uriInfo, table);
    }

    @PUT
    @Path(value="/{id}/customMetric")
    @Operation(operationId="addCustomMetric", summary="Add column custom metrics", tags={"tables"}, description="Add column custom metrics.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addCustomMetric(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid CreateCustomMetric createCustomMetric) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        CustomMetric customMetric = this.getCustomMetric(securityContext, createCustomMetric);
        Table table = ((TableRepository)this.dao).addCustomMetric(id, customMetric);
        return this.addHref(uriInfo, table);
    }

    @DELETE
    @Path(value="/{id}/customMetric/{columnName}/{customMetricName}")
    @Operation(operationId="deleteCustomMetric", summary="delete custom metric from a column", tags={"tables"}, description="Delete a custom metric from a column.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table deleteCustomMetric(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="column of the table", schema=@Schema(type="string")) @PathParam(value="columnName") String columnName, @Parameter(description="column Test Type", schema=@Schema(type="string")) @PathParam(value="customMetricName") String customMetricName) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_TESTS);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id), true);
        Table table = ((TableRepository)this.dao).deleteCustomMetric(id, columnName, customMetricName);
        return this.addHref(uriInfo, table);
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(operationId="deleteFollower", summary="Remove a follower", tags={"tables"}, description="Remove the user identified `userId` as a follower of the table.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))})})
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="string")) @PathParam(value="userId") String userId) throws IOException {
        return ((TableRepository)this.dao).deleteFollower(securityContext.getUserPrincipal().getName(), id, UUID.fromString(userId)).toResponse();
    }

    @DELETE
    @Path(value="/{id}/location")
    @Operation(operationId="deleteLocation", summary="Remove the location", tags={"tables"}, description="Remove the location", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table deleteLocation(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        EntityUtil.Fields fields = this.getFields("location");
        ((TableRepository)this.dao).deleteLocation(id);
        Table table = (Table)((TableRepository)this.dao).get(uriInfo, id, fields);
        return this.addHref(uriInfo, table);
    }

    public static Table validateNewTable(Table table) {
        table.setId(UUID.randomUUID());
        DatabaseUtil.validateConstraints(table.getColumns(), table.getTableConstraints());
        DatabaseUtil.validateTablePartition(table.getColumns(), table.getTablePartition());
        DatabaseUtil.validateViewDefinition(table.getTableType(), table.getViewDefinition());
        DatabaseUtil.validateColumns(table);
        return table;
    }

    private Table getTable(CreateTable create, String user) throws IOException {
        return TableResource.validateNewTable(this.copy(new Table(), (CreateEntity)create, user).withColumns(create.getColumns()).withTableConstraints(create.getTableConstraints()).withTablePartition(create.getTablePartition()).withTableType(create.getTableType()).withTags(create.getTags()).withViewDefinition(create.getViewDefinition()).withTableProfilerConfig(create.getTableProfilerConfig()).withDatabaseSchema(create.getDatabaseSchema()));
    }

    private CustomMetric getCustomMetric(SecurityContext securityContext, CreateCustomMetric create) {
        return new CustomMetric().withId(UUID.randomUUID()).withDescription(create.getDescription()).withName(create.getName()).withColumnName(create.getColumnName()).withOwner(create.getOwner()).withExpression(create.getExpression()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
    }

    public static class ColumnProfileList
    extends ResultList<ColumnProfile> {
        public ColumnProfileList() {
        }

        public ColumnProfileList(List<ColumnProfile> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }

    public static class TableProfileList
    extends ResultList<TableProfile> {
        public TableProfileList() {
        }

        public TableProfileList(List<TableProfile> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }

    public static class TableList
    extends ResultList<Table> {
        public TableList() {
        }

        public TableList(List<Table> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }
}

