/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.feeds;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(MessageParser.class);
    private static final String ENTITY_LINK_SEPARATOR = "::";
    private static final Pattern ENTITY_LINK_PATTERN = Pattern.compile("<#E::([^<>]+?)::([^<>]+?)(::([^<>]+?))?(::([^<>]+?))?(::([^<>]+?))?>");

    private MessageParser() {
    }

    public static List<EntityLink> getEntityLinks(String message) {
        ArrayList<EntityLink> links = new ArrayList<EntityLink>();
        Matcher matcher = ENTITY_LINK_PATTERN.matcher(message);
        while (matcher.find()) {
            links.add(EntityLink.parse(matcher.group()));
        }
        return links;
    }

    public static class EntityLink {
        private final LinkType linkType;
        private final String entityType;
        private final String entityFQN;
        private final String fieldName;
        private final String arrayFieldName;
        private final String arrayFieldValue;
        private final String fullyQualifiedFieldType;
        private final String fullyQualifiedFieldValue;

        public EntityLink(String entityType, String entityFqn, String fieldName, String arrayFieldName, String arrayFieldValue) {
            if (entityType == null || entityFqn == null) {
                throw new IllegalArgumentException("Entity link must have both {entityType} and {entityFQN}");
            }
            this.entityType = entityType;
            this.entityFQN = entityFqn;
            this.fieldName = fieldName;
            this.arrayFieldName = arrayFieldName;
            this.arrayFieldValue = arrayFieldValue;
            if (arrayFieldValue != null) {
                if (arrayFieldName == null) {
                    throw new IllegalArgumentException("Entity link must have both {arrayFieldName} and {arrayFieldValue}");
                }
                this.linkType = LinkType.ENTITY_ARRAY_FIELD;
                this.fullyQualifiedFieldType = String.format("%s.%s.member", entityType, fieldName);
                this.fullyQualifiedFieldValue = String.format("%s.%s.%s", entityFqn, arrayFieldName, arrayFieldValue);
            } else if (arrayFieldName != null) {
                this.linkType = LinkType.ENTITY_ARRAY_FIELD;
                this.fullyQualifiedFieldType = String.format("%s.%s.member", entityType, fieldName);
                this.fullyQualifiedFieldValue = String.format("%s.%s", entityFqn, arrayFieldName);
            } else if (fieldName != null) {
                this.fullyQualifiedFieldType = String.format("%s.%s", entityType, fieldName);
                this.fullyQualifiedFieldValue = String.format("%s.%s", entityFqn, fieldName);
                this.linkType = LinkType.ENTITY_REGULAR_FIELD;
            } else {
                this.fullyQualifiedFieldType = entityType;
                this.fullyQualifiedFieldValue = entityFqn;
                this.linkType = LinkType.ENTITY;
            }
        }

        public String getLinkString() {
            StringBuilder builder = new StringBuilder();
            builder.append("<#E").append(MessageParser.ENTITY_LINK_SEPARATOR).append(this.entityType).append(MessageParser.ENTITY_LINK_SEPARATOR).append(this.entityFQN);
            if (this.linkType == LinkType.ENTITY_REGULAR_FIELD || this.linkType == LinkType.ENTITY_ARRAY_FIELD) {
                builder.append(MessageParser.ENTITY_LINK_SEPARATOR).append(this.fieldName);
            }
            if (this.linkType == LinkType.ENTITY_ARRAY_FIELD) {
                builder.append(MessageParser.ENTITY_LINK_SEPARATOR).append(this.arrayFieldName);
                if (StringUtils.isNotEmpty((CharSequence)this.arrayFieldValue)) {
                    builder.append(MessageParser.ENTITY_LINK_SEPARATOR).append(this.arrayFieldValue);
                }
            }
            builder.append(">");
            return builder.toString();
        }

        public static EntityLink parse(String link) {
            if (((String)link).contains("|")) {
                link = ((String)link).substring(0, ((String)link).indexOf("|")) + ">";
            }
            Matcher matcher = ENTITY_LINK_PATTERN.matcher((CharSequence)link);
            EntityLink entityLink = null;
            while (matcher.find()) {
                if (entityLink == null) {
                    String entityFQN = matcher.group(2);
                    if (entityFQN == null) {
                        throw new IllegalArgumentException("Invalid Entity Link. Entity FQN is missing in " + (String)link);
                    }
                    entityLink = new EntityLink(matcher.group(1), entityFQN, matcher.group(4), matcher.group(6), matcher.group(8));
                    continue;
                }
                throw new IllegalArgumentException("Unexpected multiple entity links in " + (String)link);
            }
            if (entityLink == null) {
                throw new IllegalArgumentException("Entity link was not found in " + (String)link);
            }
            return entityLink;
        }

        public LinkType getLinkType() {
            return this.linkType;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public String getEntityFQN() {
            return this.entityFQN;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getArrayFieldName() {
            return this.arrayFieldName;
        }

        public String getArrayFieldValue() {
            return this.arrayFieldValue;
        }

        public String getFullyQualifiedFieldType() {
            return this.fullyQualifiedFieldType;
        }

        public String getFullyQualifiedFieldValue() {
            return this.fullyQualifiedFieldValue;
        }

        public String toString() {
            return String.format("EntityLink { type = %s, entityType = %s, entityFQN = %s, fieldName = %s, arrayFieldName = %s, arrayFieldValue = %s}", new Object[]{this.linkType, this.entityType, this.entityType, this.fieldName, this.arrayFieldName, this.arrayFieldValue});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityLink that = (EntityLink)o;
            return this.linkType == that.linkType && Objects.equals(this.entityType, that.entityType) && Objects.equals(this.entityFQN, that.entityFQN) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.arrayFieldName, that.arrayFieldName) && Objects.equals(this.arrayFieldValue, that.arrayFieldValue);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.linkType, this.entityType, this.entityFQN, this.fieldName, this.arrayFieldName, this.arrayFieldValue});
        }

        public static enum LinkType {
            ENTITY,
            ENTITY_REGULAR_FIELD,
            ENTITY_ARRAY_FIELD;

        }
    }
}

