/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.search;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.elasticsearch.search.suggest.completion.context.CategoryQueryContext;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.service.util.ElasticSearchClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/search")
@Api(value="Search collection", tags={"Search collection"})
@Produces(value={"application/json"})
public class SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private final RestHighLevelClient client;
    private static final Integer MAX_AGGREGATE_SIZE = 50;
    private static final Integer MAX_RESULT_HITS = 10000;
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DESCRIPTION = "description";
    private static final String UNIFIED = "unified";

    public SearchResource(ElasticSearchConfiguration esConfig) {
        this.client = ElasticSearchClientUtils.createElasticSearchClient(esConfig);
    }

    @GET
    @Path(value="/query")
    @Operation(operationId="searchEntitiesWithQuery", summary="Search entities", tags={"search"}, description="Search entities using query test. Use query params `from` and `size` for pagination. Use `sort_field` to sort the results in `sort_order`.", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response search(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. <br/> 1. For listing all tables or topics pass q=* <br/>2. For search tables or topics pass q=*search_term* <br/>3. For searching field names such as search by column_name pass q=column_names:address <br/>4. For searching by tag names pass q=tags:user.email <br/>5. When user selects a filter pass q=query_text AND tags:user.email AND platform:MYSQL <br/>6. Search with multiple values of same filter q=tags:user.email AND tags:user.address <br/> logic operators such as AND and OR must be in uppercase ", required=true) @QueryParam(value="q") String query, @Parameter(description="ElasticSearch Index name, defaults to table_search_index") @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Filter documents by deleted param. By default deleted is false") @DefaultValue(value="false") @QueryParam(value="deleted") boolean deleted, @Parameter(description="From field to paginate the results, defaults to 0") @DefaultValue(value="0") @QueryParam(value="from") int from, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @Parameter(description="Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp") @QueryParam(value="sort_field") String sortFieldParam, @Parameter(description="Sort order asc for ascending or desc for descending, defaults to desc") @DefaultValue(value="desc") @QueryParam(value="sort_order") String sortOrderParam, @Parameter(description="Track Total Hits") @DefaultValue(value="false") @QueryParam(value="track_total_hits") boolean trackTotalHits) throws IOException {
        SearchSourceBuilder searchSourceBuilder;
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SortOrder sortOrder = SortOrder.DESC;
        if (sortOrderParam.equals("asc")) {
            sortOrder = SortOrder.ASC;
        }
        query = (String)query + " AND deleted:" + deleted;
        switch (index) {
            case "topic_search_index": {
                searchSourceBuilder = this.buildTopicSearchBuilder((String)query, from, size);
                break;
            }
            case "dashboard_search_index": {
                searchSourceBuilder = this.buildDashboardSearchBuilder((String)query, from, size);
                break;
            }
            case "pipeline_search_index": {
                searchSourceBuilder = this.buildPipelineSearchBuilder((String)query, from, size);
                break;
            }
            case "table_search_index": {
                searchSourceBuilder = this.buildTableSearchBuilder((String)query, from, size);
                break;
            }
            case "user_search_index": {
                searchSourceBuilder = this.buildUserSearchBuilder((String)query, from, size);
                break;
            }
            case "team_search_index": {
                searchSourceBuilder = this.buildTeamSearchBuilder((String)query, from, size);
                break;
            }
            case "glossary_search_index": {
                searchSourceBuilder = this.buildGlossaryTermSearchBuilder((String)query, from, size);
                break;
            }
            case "tag_search_index": {
                searchSourceBuilder = this.buildTagSearchBuilder((String)query, from, size);
                break;
            }
            default: {
                searchSourceBuilder = this.buildAggregateSearchBuilder((String)query, from, size);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)sortFieldParam)) {
            searchSourceBuilder.sort(sortFieldParam, sortOrder);
        }
        LOG.debug(searchSourceBuilder.toString());
        if (trackTotalHits) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHitsUpTo(MAX_RESULT_HITS.intValue());
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)searchResponse.toString()).build();
    }

    @GET
    @Path(value="/suggest")
    @Operation(operationId="getSuggestedEntities", summary="Suggest Entities", tags={"search"}, description="Get suggested entities used for auto-completion.", responses={@ApiResponse(responseCode="200", description="Table Suggestion API", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggest.class))})})
    public Response suggest(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Suggest API can be used to auto-fill the entities name while use is typing search text <br/> 1. To get suggest results pass q=us or q=user etc.. <br/> 2. Do not add any wild-cards such as * like in search api <br/> 3. suggest api is a prefix suggestion <br/>", required=true) @QueryParam(value="q") String query, @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @DefaultValue(value="suggest") @QueryParam(value="field") String fieldName, @DefaultValue(value="false") @QueryParam(value="deleted") String deleted) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CompletionSuggestionBuilder suggestionBuilder = SuggestBuilders.completionSuggestion((String)fieldName).prefix(query);
        if (fieldName.equalsIgnoreCase("suggest")) {
            suggestionBuilder.contexts(Collections.singletonMap("deleted", Collections.singletonList(CategoryQueryContext.builder().setCategory(deleted).build())));
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("metadata-suggest", (SuggestionBuilder)suggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)suggest.toString()).build();
    }

    private SearchSourceBuilder buildAggregateSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).lenient(Boolean.valueOf(true));
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder(queryBuilder, null, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildTableSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 10.0f).field(DESCRIPTION, 1.0f).field("columns.name", 5.0f).field("columns.description", 1.0f).field("columns.children.name", 5.0f).lenient(Boolean.valueOf(true)).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTableName = new HighlightBuilder.Field(NAME);
        highlightTableName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("columns.name");
        highlightColumns.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("columns.description");
        highlightColumnDescriptions.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("columns.children.name");
        highlightColumnDescriptions.highlighterType(UNIFIED);
        hb.field(highlightDescription);
        hb.field(highlightTableName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder(queryStringBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"Database").field("database.name.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"DatabaseSchema").field("databaseSchema.name.keyword"));
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildTopicSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 10.0f).field(DESCRIPTION, 2.0f).lenient(Boolean.valueOf(true));
        HighlightBuilder.Field highlightTopicName = new HighlightBuilder.Field(NAME);
        highlightTopicName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightTopicName);
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder(queryBuilder, hb, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildDashboardSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 10.0f).field(DESCRIPTION, 2.0f).field("chars.name").field("charts.description").lenient(Boolean.valueOf(true));
        HighlightBuilder.Field highlightDashboardName = new HighlightBuilder.Field(NAME);
        highlightDashboardName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightCharts = new HighlightBuilder.Field("charts.name");
        highlightCharts.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightChartDescriptions = new HighlightBuilder.Field("charts.description");
        highlightChartDescriptions.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightDashboardName);
        hb.field(highlightCharts);
        hb.field(highlightChartDescriptions);
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder(queryBuilder, hb, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder buildPipelineSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 5.0f).field(DESCRIPTION).field("tasks.name").field("tasks.description").lenient(Boolean.valueOf(true));
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field(NAME);
        highlightPipelineName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("tasks.name");
        highlightTasks.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("tasks.description");
        highlightTaskDescriptions.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = this.searchBuilder(queryBuilder, hb, from, size);
        return this.addAggregation(searchSourceBuilder);
    }

    private SearchSourceBuilder searchBuilder(QueryStringQueryBuilder queryBuilder, HighlightBuilder hb, int from, int size) {
        SearchSourceBuilder builder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).from(from).size(size);
        if (hb != null) {
            hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
            hb.postTags(new String[]{"</span>"});
            builder.highlighter(hb);
        }
        return builder;
    }

    private SearchSourceBuilder addAggregation(SearchSourceBuilder builder) {
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"Service").field("serviceType")).size(MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"ServiceName").field("service.name.keyword")).size(MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"ServiceCategory").field("service.type")).size(MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"EntityType").field("entityType")).size(MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"Tier").field("tier.tagFQN")).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"Tags").field("tags.tagFQN")).size(MAX_AGGREGATE_SIZE.intValue()));
        return builder;
    }

    private SearchSourceBuilder buildUserSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 5.0f).field(DISPLAY_NAME, 1.0f).lenient(Boolean.valueOf(true));
        return this.searchBuilder(queryBuilder, null, from, size);
    }

    private SearchSourceBuilder buildTeamSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 5.0f).field(DISPLAY_NAME, 3.0f).lenient(Boolean.valueOf(true));
        return this.searchBuilder(queryBuilder, null, from, size);
    }

    private SearchSourceBuilder buildGlossaryTermSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 5.0f).field(DESCRIPTION, 3.0f).lenient(Boolean.valueOf(true));
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field(NAME);
        highlightGlossaryName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return this.searchBuilder(queryBuilder, hb, from, size);
    }

    private SearchSourceBuilder buildTagSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field(NAME, 5.0f).field(DESCRIPTION, 3.0f).lenient(Boolean.valueOf(true));
        HighlightBuilder.Field highlightTagName = new HighlightBuilder.Field(NAME);
        highlightTagName.highlighterType(UNIFIED);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field(DESCRIPTION);
        highlightDescription.highlighterType(UNIFIED);
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightTagName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return this.searchBuilder(queryBuilder, hb, from, size);
    }
}

