/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.dashboard;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.services.CreateDashboardService;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.DashboardConnection;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DashboardServiceRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/services/dashboardServices")
@Api(value="Dashboard service collection", tags={"Services -> Dashboard service collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="dashboardServices")
public class DashboardServiceResource
extends ServiceEntityResource<DashboardService, DashboardServiceRepository, DashboardConnection> {
    public static final String COLLECTION_PATH = "v1/services/dashboardServices";
    static final String FIELDS = "owner";

    @Override
    public DashboardService addHref(UriInfo uriInfo, DashboardService service) {
        service.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, service.getId()));
        Entity.withHref(uriInfo, service.getOwner());
        return service;
    }

    public DashboardServiceResource(CollectionDAO dao, Authorizer authorizer, SecretsManager secretsManager) {
        super(DashboardService.class, new DashboardServiceRepository(dao, secretsManager), authorizer, secretsManager, ServiceType.DASHBOARD);
    }

    @GET
    @Operation(operationId="listDashboardsService", summary="List dashboard services", tags={"dashboardServices"}, description="Get a list of dashboard services.", responses={@ApiResponse(responseCode="200", description="List of dashboard service instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardServiceList.class))})})
    public ResultList<DashboardService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @QueryParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of dashboard services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of dashboard services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include);
        ResultList dashboardServices = this.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        return this.addHref(uriInfo, this.decryptOrNullify(securityContext, dashboardServices));
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDashboardServiceByID", summary="Get a dashboard service", tags={"dashboardServices"}, description="Get a dashboard service by `id`.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="404", description="Dashboard service for instance {id} is not found")})
    public DashboardService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        DashboardService dashboardService = (DashboardService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, dashboardService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getDashboardServiceByFQN", summary="Get dashboard service by name", tags={"dashboardServices"}, description="Get a dashboard service by the service `name`.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="404", description="Dashboard service for instance {id} is not found")})
    public DashboardService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        DashboardService dashboardService = (DashboardService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        return this.decryptOrNullify(securityContext, dashboardService);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDashboardServiceVersion", summary="List dashboard service versions", tags={"dashboardServices"}, description="Get a list of all the versions of a dashboard service identified by `id`", responses={@ApiResponse(responseCode="200", description="List of dashboard service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="dashboard service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                DashboardService dashboardService = JsonUtils.readValue((String)json, DashboardService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, dashboardService));
            }
            catch (IOException e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDashboardServiceVersion", summary="Get a version of the dashboard service", tags={"dashboardServices"}, description="Get a version of the dashboard service by given `id`", responses={@ApiResponse(responseCode="200", description="dashboard service", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="404", description="Dashboard service for instance {id} and version {version} is not found")})
    public DashboardService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="dashboard service Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="dashboard service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        DashboardService dashboardService = (DashboardService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, dashboardService);
    }

    @POST
    @Operation(operationId="createDashboardService", summary="Create a dashboard service", tags={"dashboardServices"}, description="Create a new dashboard service.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboardService create) throws IOException {
        DashboardService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service, true);
        this.decryptOrNullify(securityContext, (DashboardService)response.getEntity());
        return response;
    }

    @PUT
    @Operation(operationId="createOrUpdateDashboardService", summary="Update a Dashboard service", tags={"dashboardServices"}, description="Update an existing dashboard service identified by `id`.", responses={@ApiResponse(responseCode="200", description="Dashboard service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboardService update) throws IOException {
        DashboardService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, service, true);
        this.decryptOrNullify(securityContext, (DashboardService)response.getEntity());
        return response;
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDashboardService", summary="Delete a Dashboard service", tags={"dashboardServices"}, description="Delete a Dashboard services. If dashboard (and charts) belong to the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DashboardService service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the dashboard service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete, true);
    }

    private DashboardService getService(CreateDashboardService create, String user) throws IOException {
        return this.copy(new DashboardService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected DashboardService nullifyConnection(DashboardService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(DashboardService service) {
        return service.getServiceType().value();
    }

    public static class DashboardServiceList
    extends ResultList<DashboardService> {
        public DashboardServiceList() {
        }

        public DashboardServiceList(List<DashboardService> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }
}

