/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.teams;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.fasterxml.jackson.core.JsonProcessingException;
import freemarker.template.TemplateException;
import io.dropwizard.jersey.PATCH;
import io.dropwizard.jersey.errors.ErrorMessage;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonValue;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jetbrains.annotations.Nullable;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.api.teams.CreateUser;
import org.openmetadata.schema.auth.ChangePasswordRequest;
import org.openmetadata.schema.auth.EmailRequest;
import org.openmetadata.schema.auth.EmailVerificationToken;
import org.openmetadata.schema.auth.LoginRequest;
import org.openmetadata.schema.auth.LogoutRequest;
import org.openmetadata.schema.auth.PasswordResetRequest;
import org.openmetadata.schema.auth.PasswordResetToken;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.RegistrationRequest;
import org.openmetadata.schema.auth.TokenRefreshRequest;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.teams.authn.BasicAuthMechanism;
import org.openmetadata.schema.teams.authn.GenerateTokenRequest;
import org.openmetadata.schema.teams.authn.JWTAuthMechanism;
import org.openmetadata.schema.teams.authn.JWTTokenExpiry;
import org.openmetadata.schema.teams.authn.SSOAuthMechanism;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.auth.LoginAttemptCache;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.security.saml.JwtTokenCacheManager;
import org.openmetadata.service.util.ConfigurationHolder;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.PasswordUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.TokenUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/users")
@Api(value="User collection", tags={"User collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="users")
public class UserResource
extends EntityResource<User, UserRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(UserResource.class);
    public static final String COLLECTION_PATH = "v1/users/";
    public static final String USER_PROTECTED_FIELDS = "authenticationMechanism";
    private final JWTTokenGenerator jwtTokenGenerator = JWTTokenGenerator.getInstance();
    private final TokenRepository tokenRepository;
    private final UserRepository userRepository;
    private final SecretsManager secretsManager;
    private final String providerType;
    private final boolean isEmailServiceEnabled;
    private final LoginAttemptCache loginAttemptCache;
    static final String FIELDS = "profile,roles,teams,follows,owns";

    @Override
    public User addHref(UriInfo uriInfo, User user) {
        Entity.withHref(uriInfo, user.getTeams());
        Entity.withHref(uriInfo, user.getRoles());
        Entity.withHref(uriInfo, user.getInheritedRoles());
        Entity.withHref(uriInfo, user.getOwns());
        Entity.withHref(uriInfo, user.getFollows());
        return user;
    }

    public UserResource(CollectionDAO dao, Authorizer authorizer, SecretsManager secretsManager) {
        super(User.class, new UserRepository(dao, secretsManager), authorizer);
        this.allowedFields.remove(USER_PROTECTED_FIELDS);
        this.tokenRepository = new TokenRepository(dao);
        this.userRepository = new UserRepository(dao, secretsManager);
        this.secretsManager = secretsManager;
        this.providerType = ConfigurationHolder.getInstance().getConfig(ConfigurationHolder.ConfigurationType.AUTHENTICATION_CONFIG, AuthenticationConfiguration.class).getProvider();
        SmtpSettings smtpSettings = ConfigurationHolder.getInstance().getConfig(ConfigurationHolder.ConfigurationType.SMTP_CONFIG, SmtpSettings.class);
        this.isEmailServiceEnabled = smtpSettings != null && smtpSettings.getEnableSmtpServer() != false;
        this.loginAttemptCache = new LoginAttemptCache();
    }

    @GET
    @Valid
    @Operation(operationId="listUsers", summary="List users", tags={"users"}, description="Get a list of users. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserList.class))})})
    public ResultList<User> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter users by team", schema=@Schema(type="string", example="Legal")) @QueryParam(value="team") String teamParam, @Parameter(description="Limit the number users returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of users before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of users after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Returns list of admin users if set to true", schema=@Schema(type="boolean")) @QueryParam(value="isAdmin") Boolean isAdmin, @Parameter(description="Returns list of bot users if set to true", schema=@Schema(type="boolean")) @QueryParam(value="isBot") Boolean isBot, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include).addQueryParam("team", teamParam);
        if (isAdmin != null) {
            filter.addQueryParam("isAdmin", String.valueOf(isAdmin));
        }
        if (isBot != null) {
            filter.addQueryParam("isBot", String.valueOf(isBot));
        }
        ResultList<User> users = this.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        users.getData().forEach(user -> this.decryptOrNullify(securityContext, (User)user));
        return users;
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllUserVersion", summary="List user versions", tags={"users"}, description="Get a list of all the versions of a user identified by `id`", responses={@ApiResponse(responseCode="200", description="List of user versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="user Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/generateRandomPwd")
    @Operation(operationId="generateRandomPwd", summary="generateRandomPwd", tags={"users"}, description="Generate a random pwd", responses={@ApiResponse(responseCode="200", description="Random pwd")})
    public Response generateRandomPassword(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext, false);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)PasswordUtil.generateRandomPassword()).build();
    }

    @GET
    @Valid
    @Path(value="/{id}")
    @Operation(operationId="getUserByID", summary="Get a user", tags={"users"}, description="Get a user by `id`", responses={@ApiResponse(responseCode="200", description="The user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User for instance {id} is not found")})
    public User get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return this.decryptOrNullify(securityContext, (User)this.getInternal(uriInfo, securityContext, id, fieldsParam, include));
    }

    @GET
    @Valid
    @Path(value="/name/{name}")
    @Operation(operationId="getUserByFQN", summary="Get a user by name", tags={"users"}, description="Get a user by `name`.", responses={@ApiResponse(responseCode="200", description="The user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User for instance {id} is not found")})
    public User getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return this.decryptOrNullify(securityContext, (User)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include));
    }

    @GET
    @Valid
    @Path(value="/loggedInUser")
    @Operation(operationId="getCurrentLoggedInUser", summary="Get current logged in user", tags={"users"}, description="Get the user who is authenticated and is currently logged in.", responses={@ApiResponse(responseCode="200", description="The user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User not found")})
    public User getCurrentLoggedInUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="profile,roles,teams,follows,owns")) @QueryParam(value="fields") String fieldsParam) throws IOException {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        String currentUserName = securityContext.getUserPrincipal().getName();
        User user = (User)((UserRepository)this.dao).getByName(uriInfo, currentUserName, fields);
        return this.addHref(uriInfo, user);
    }

    @GET
    @Valid
    @Path(value="/loggedInUser/groupTeams")
    @Operation(operationId="getCurrentLoggedInUserGroupTeams", summary="Get group type of teams for current logged in user", tags={"users"}, description="Get the group type of teams of user who is authenticated and is currently logged in.", responses={@ApiResponse(responseCode="200", description="The teams of type 'Group' that a user belongs to", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EntityReference.class)))}), @ApiResponse(responseCode="404", description="User not found")})
    public List<EntityReference> getCurrentLoggedInUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext) throws IOException {
        String currentUserName = securityContext.getUserPrincipal().getName();
        return ((UserRepository)this.dao).getGroupTeams(uriInfo, currentUserName);
    }

    @POST
    @Path(value="/logout")
    @Operation(operationId="logoutUser", summary="Logout a User(Only called for saml and basic Auth)", tags={"users"}, description="Logout a User(Only called for saml and basic Auth)", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response logoutUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid LogoutRequest request) {
        Date logoutTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        JwtTokenCacheManager.getInstance().markLogoutEventForToken(new LogoutRequest().withUsername(securityContext.getUserPrincipal().getName()).withToken(request.getToken()).withLogoutTime(logoutTime));
        if (this.isBasicAuth() && request.getRefreshToken() != null) {
            this.tokenRepository.deleteToken(request.getRefreshToken());
        }
        return Response.status((int)200).entity((Object)"Logout Successful").build();
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificUserVersion", summary="Get a version of the user", tags={"users"}, description="Get a version of the user by given `id`", responses={@ApiResponse(responseCode="200", description="user", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="404", description="User for instance {id} and version {version} is not found")})
    public User getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="User Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="User version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (User)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createUser", summary="Create a user", tags={"users"}, description="Create a new user.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateUser create) throws IOException {
        User user = this.getUser(securityContext, create);
        if (Boolean.TRUE.equals(create.getIsAdmin())) {
            this.authorizer.authorizeAdmin(securityContext, true);
        }
        if (Boolean.TRUE.equals(create.getIsBot())) {
            this.addAuthMechanismToBot(user, create, uriInfo);
        }
        if (this.isBasicAuth()) {
            try {
                this.validateEmailAlreadyExists(create.getEmail());
            }
            catch (RuntimeException ex) {
                return Response.status((Response.Status)Response.Status.CONFLICT).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(Response.Status.CONFLICT.getStatusCode(), "Entity already exists")).build();
            }
            user.setName(user.getEmail().split("@")[0]);
            if (Boolean.FALSE.equals(create.getIsBot()) && create.getCreatePasswordType() == CreateUser.CreatePasswordType.ADMINCREATE) {
                this.addAuthMechanismToUser(user, create);
            }
        }
        this.addHref(uriInfo, ((UserRepository)this.dao).create(uriInfo, user));
        if (this.isBasicAuth() && this.isEmailServiceEnabled) {
            try {
                this.sendInviteMailToUser(uriInfo, user, String.format("Welcome to %s", EmailUtil.getInstance().getEmailingEntity()), create.getCreatePasswordType(), create.getPassword());
            }
            catch (Exception ex) {
                LOG.error("Error in sending invite to User" + ex.getMessage());
            }
        }
        Response response = Response.created((URI)user.getHref()).entity((Object)user).build();
        this.decryptOrNullify(securityContext, (User)response.getEntity());
        return response;
    }

    private boolean isBasicAuth() {
        return this.providerType.equals(SSOAuthMechanism.SsoServiceType.BASIC.toString());
    }

    @PUT
    @Operation(summary="Update user", tags={"users"}, description="Create or Update a user.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateUser.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdateUser(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateUser create) throws IOException {
        User user = this.getUser(securityContext, create);
        ((UserRepository)this.dao).prepare(user);
        if (Boolean.TRUE.equals(create.getIsAdmin()) || Boolean.TRUE.equals(create.getIsBot())) {
            this.authorizer.authorizeAdmin(securityContext, true);
        } else if (!securityContext.getUserPrincipal().getName().equals(user.getName())) {
            OperationContext createOperationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
            ResourceContext resourceContext = this.getResourceContextByName(user.getName());
            this.authorizer.authorize(securityContext, createOperationContext, resourceContext, true);
        }
        if (Boolean.TRUE.equals(create.getIsBot())) {
            return this.createOrUpdateBot(user, create, uriInfo, securityContext);
        }
        RestUtil.PutResponse<User> response = ((UserRepository)this.dao).createOrUpdate(uriInfo, user);
        this.addHref(uriInfo, response.getEntity());
        return response.toResponse();
    }

    @PUT
    @Path(value="/generateToken/{id}")
    @Operation(operationId="generateJWTTokenForBotUser", summary="Generate JWT Token for a Bot User", tags={"users"}, description="Generate JWT Token for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTTokenExpiry.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response generateToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Valid GenerateTokenRequest generateTokenRequest) throws IOException {
        User user = (User)((UserRepository)this.dao).get(uriInfo, id, EntityUtil.Fields.EMPTY_FIELDS);
        this.authorizeGenerateJWT(user);
        this.authorizer.authorizeAdmin(securityContext, false);
        JWTAuthMechanism jwtAuthMechanism = this.jwtTokenGenerator.generateJWTToken(user, generateTokenRequest.getJWTTokenExpiry());
        AuthenticationMechanism authenticationMechanism = new AuthenticationMechanism().withConfig((Object)jwtAuthMechanism).withAuthType(AuthenticationMechanism.AuthType.JWT);
        user.setAuthenticationMechanism(authenticationMechanism);
        User updatedUser = ((UserRepository)this.dao).createOrUpdate(uriInfo, user).getEntity();
        jwtAuthMechanism = JsonUtils.convertValue(updatedUser.getAuthenticationMechanism().getConfig(), JWTAuthMechanism.class);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jwtAuthMechanism).build();
    }

    @PUT
    @Path(value="/revokeToken/{id}")
    @Operation(operationId="revokeJWTTokenForBotUser", summary="Revoke JWT Token for a Bot User", tags={"users"}, description="Revoke JWT Token for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTAuthMechanism.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response revokeToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id) throws IOException {
        User user = (User)((UserRepository)this.dao).get(uriInfo, id, EntityUtil.Fields.EMPTY_FIELDS);
        this.authorizeGenerateJWT(user);
        this.authorizer.authorizeAdmin(securityContext, false);
        JWTAuthMechanism jwtAuthMechanism = new JWTAuthMechanism().withJWTToken("");
        AuthenticationMechanism authenticationMechanism = new AuthenticationMechanism().withConfig((Object)jwtAuthMechanism).withAuthType(AuthenticationMechanism.AuthType.JWT);
        user.setAuthenticationMechanism(authenticationMechanism);
        RestUtil.PutResponse<User> response = ((UserRepository)this.dao).createOrUpdate(uriInfo, user);
        this.addHref(uriInfo, response.getEntity());
        return response.toResponse();
    }

    @GET
    @Path(value="/token/{id}")
    @Operation(operationId="getJWTTokenForBotUser", summary="Get JWT Token for a Bot User", tags={"users"}, description="Get JWT Token for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTAuthMechanism.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public JWTAuthMechanism getToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id) throws IOException {
        User user = (User)((UserRepository)this.dao).get(uriInfo, id, new EntityUtil.Fields(List.of(USER_PROTECTED_FIELDS)));
        if (!Boolean.TRUE.equals(user.getIsBot())) {
            throw new IllegalArgumentException("JWT token is only supported for bot users");
        }
        this.decryptOrNullify(securityContext, user);
        this.authorizer.authorizeAdmin(securityContext, false);
        AuthenticationMechanism authenticationMechanism = user.getAuthenticationMechanism();
        if (authenticationMechanism != null && authenticationMechanism.getConfig() != null && authenticationMechanism.getAuthType() == AuthenticationMechanism.AuthType.JWT) {
            return JsonUtils.convertValue(authenticationMechanism.getConfig(), JWTAuthMechanism.class);
        }
        return new JWTAuthMechanism();
    }

    @GET
    @Path(value="/auth-mechanism/{id}")
    @Operation(operationId="getAuthenticationMechanismBotUser", summary="Get Authentication Mechanism for a Bot User", tags={"users"}, description="Get Authentication Mechanism for a Bot User.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationMechanism.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public AuthenticationMechanism getAuthenticationMechanism(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id) throws IOException {
        User user = (User)((UserRepository)this.dao).get(uriInfo, id, new EntityUtil.Fields(List.of(USER_PROTECTED_FIELDS)));
        if (!Boolean.TRUE.equals(user.getIsBot())) {
            throw new IllegalArgumentException("JWT token is only supported for bot users");
        }
        this.decryptOrNullify(securityContext, user);
        this.authorizer.authorizeAdmin(securityContext, false);
        return user.getAuthenticationMechanism();
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchUser", summary="Update a user", tags={"users"}, description="Update an existing user using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        for (JsonValue patchOp : patch.toJsonArray()) {
            JsonObject patchOpObject = patchOp.asJsonObject();
            if (!patchOpObject.containsKey((Object)"path") || !patchOpObject.containsKey((Object)"value")) continue;
            String path = patchOpObject.getString("path");
            if (path.equals("/isAdmin") || path.equals("/isBot")) {
                this.authorizer.authorizeAdmin(securityContext, true);
            }
            if (!patchOpObject.containsKey((Object)"op") || !patchOpObject.getString("op").equals("add") || !path.startsWith("/teams/")) continue;
            JsonObject value = null;
            try {
                value = patchOpObject.getJsonObject("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) continue;
            String teamId = value.getString("id");
            ((UserRepository)this.dao).validateTeamAddition(id, UUID.fromString(teamId));
            if (((UserRepository)this.dao).isTeamJoinable(teamId)) continue;
            this.authorizer.authorizeAdmin(securityContext, false);
        }
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteUser", summary="Delete a user", tags={"users"}, description="Users can't be deleted but are soft-deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="User for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="User Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        Response response = this.delete(uriInfo, securityContext, id, false, hardDelete, true);
        this.decryptOrNullify(securityContext, (User)response.getEntity());
        return response;
    }

    @POST
    @Path(value="/signup")
    @Operation(operationId="registerUser", summary="Register User", tags={"users"}, description="Register a new User", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response registerNewUser(@Context UriInfo uriInfo, @Valid RegistrationRequest create) throws IOException {
        if (Boolean.TRUE.equals(ConfigurationHolder.getInstance().getConfig(ConfigurationHolder.ConfigurationType.AUTHENTICATION_CONFIG, AuthenticationConfiguration.class).getEnableSelfSignup())) {
            User registeredUser = this.registerUser(uriInfo, create);
            if (this.isEmailServiceEnabled) {
                try {
                    this.sendEmailVerification(uriInfo, registeredUser);
                }
                catch (Exception e) {
                    LOG.error("Error in sending mail to the User : {}", (Object)e.getMessage());
                    return Response.status((int)424, (String)"There is some issue in sending the Mail. Please contact your administrator.").build();
                }
            }
            return Response.status((int)Response.Status.CREATED.getStatusCode(), (String)"User Registration Successful.").entity((Object)registeredUser).build();
        }
        return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Signup is not available").build();
    }

    @GET
    @Path(value="/registrationConfirmation")
    @Operation(operationId="confirmUserEmail", summary="Confirm User Email", tags={"users"}, description="Confirm User Email", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response confirmUserEmail(@Context UriInfo uriInfo, @Parameter(description="Token sent for Email Confirmation", schema=@Schema(type="string")) @QueryParam(value="token") String token) throws IOException {
        this.confirmEmailRegistration(uriInfo, token);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Email Verified Successfully").build();
    }

    @GET
    @Path(value="/resendRegistrationToken")
    @Operation(operationId="resendRegistrationToken", summary="Resend Registration Token", tags={"users"}, description="Resend Registration Token", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response resendRegistrationToken(@Context UriInfo uriInfo, @Parameter(description="Token sent for Email Confirmation Earlier", schema=@Schema(type="string")) @QueryParam(value="user") String user) throws IOException {
        User registeredUser = (User)((UserRepository)this.dao).getByName(uriInfo, user, this.getFields("isEmailVerified"));
        if (Boolean.TRUE.equals(registeredUser.getIsEmailVerified())) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Email Already Verified For User.").build();
        }
        this.tokenRepository.deleteTokenByUserAndType(registeredUser.getId().toString(), TokenType.EMAIL_VERIFICATION.toString());
        if (this.isEmailServiceEnabled) {
            try {
                this.sendEmailVerification(uriInfo, registeredUser);
            }
            catch (Exception e) {
                LOG.error("Error in sending Email Verification mail to the User : {}", (Object)e.getMessage());
                return Response.status((int)424).entity((Object)new ErrorMessage(424, "There is some issue in sending the Mail. Please contact your administrator.")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Email Verification Mail Sent. Please check your Mailbox.").build();
    }

    @POST
    @Path(value="/generatePasswordResetLink")
    @Operation(operationId="generatePasswordResetLink", summary="Generate Password Reset Link", tags={"users"}, description="Generate Password Reset Link", responses={@ApiResponse(responseCode="200", description="The user "), @ApiResponse(responseCode="400", description="Bad request")})
    public Response generateResetPasswordLink(@Context UriInfo uriInfo, @Valid EmailRequest request) {
        User registeredUser;
        String userName = request.getEmail().split("@")[0];
        try {
            registeredUser = (User)((UserRepository)this.dao).getByName(uriInfo, userName, new EntityUtil.Fields(List.of(USER_PROTECTED_FIELDS), USER_PROTECTED_FIELDS));
        }
        catch (IOException ex) {
            throw new BadRequestException("Email is not valid.");
        }
        if (this.isEmailServiceEnabled) {
            try {
                this.sendPasswordResetLink(uriInfo, registeredUser, EmailUtil.getInstance().getPasswordResetSubject(), "reset-link.ftl");
            }
            catch (Exception ex) {
                LOG.error("Error in sending mail for reset password" + ex.getMessage());
                return Response.status((int)424).entity((Object)new ErrorMessage(424, "There is some issue in sending the Mail. Please contact your administrator.")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Please check your mail to for Reset Password Link.").build();
    }

    @POST
    @Path(value="/password/reset")
    @Operation(operationId="resetUserPassword", summary="Reset Password For User", tags={"users"}, description="Reset User Password", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response resetUserPassword(@Context UriInfo uriInfo, @Valid PasswordResetRequest request) throws IOException {
        String tokenID = request.getToken();
        PasswordResetToken passwordResetToken = (PasswordResetToken)this.tokenRepository.findByToken(tokenID);
        if (passwordResetToken == null) {
            throw new EntityNotFoundException("Invalid Password Request. Please issue a new request.");
        }
        List<String> fields = ((UserRepository)this.dao).getAllowedFieldsCopy();
        fields.add(USER_PROTECTED_FIELDS);
        User storedUser = (User)((UserRepository)this.dao).getByName(uriInfo, request.getUsername(), new EntityUtil.Fields(fields, String.join((CharSequence)",", fields)));
        if (!passwordResetToken.getUserId().equals(storedUser.getId())) {
            throw new RuntimeException("Token does not belong to the user.");
        }
        this.verifyPasswordResetTokenExpiry(passwordResetToken);
        if (!request.getPassword().equals(request.getConfirmPassword())) {
            throw new RuntimeException("Password and Confirm Password should match");
        }
        PasswordUtil.validatePassword(request.getPassword());
        String newHashedPwd = BCrypt.withDefaults().hashToString(12, request.getPassword().toCharArray());
        BasicAuthMechanism newAuthForUser = new BasicAuthMechanism().withPassword(newHashedPwd);
        storedUser.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)newAuthForUser));
        RestUtil.PutResponse<User> response = ((UserRepository)this.dao).createOrUpdate(uriInfo, storedUser);
        this.tokenRepository.deleteTokenByUserAndType(storedUser.getId().toString(), TokenType.PASSWORD_RESET.toString());
        if (this.isEmailServiceEnabled) {
            try {
                this.sendAccountStatus(storedUser, "Update Password", "Change Successful");
            }
            catch (Exception ex) {
                LOG.error("Error in sending Password Change Mail to User. Reason : " + ex.getMessage());
                return Response.status((int)424).entity((Object)new ErrorMessage(424, "There is some issue in sending the Mail. Please contact your administrator.")).build();
            }
        }
        this.loginAttemptCache.recordSuccessfulLogin(request.getUsername());
        return Response.status((Response.Status)response.getStatus()).entity((Object)"Password Changed Successfully").build();
    }

    @PUT
    @Path(value="/changePassword")
    @Operation(operationId="changeUserPassword", summary="Change Password For User", tags={"users"}, description="Create a new user.", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response changeUserPassword(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid ChangePasswordRequest request) throws IOException {
        if (!request.getNewPassword().equals(request.getConfirmPassword())) {
            throw new RuntimeException("Password and Confirm Password should match");
        }
        PasswordUtil.validatePassword(request.getNewPassword());
        List<String> fields = ((UserRepository)this.dao).getAllowedFieldsCopy();
        fields.add(USER_PROTECTED_FIELDS);
        if (request.getRequestType() == ChangePasswordRequest.RequestType.SELF) {
            User storedUser = (User)((UserRepository)this.dao).getByName(uriInfo, securityContext.getUserPrincipal().getName(), new EntityUtil.Fields(fields, String.join((CharSequence)",", fields)));
            BasicAuthMechanism storedBasicAuthMechanism = JsonUtils.convertValue(storedUser.getAuthenticationMechanism().getConfig(), BasicAuthMechanism.class);
            String storedHashPassword = storedBasicAuthMechanism.getPassword();
            if (BCrypt.verifyer().verify((char[])request.getOldPassword().toCharArray(), (CharSequence)storedHashPassword).verified) {
                String newHashedPassword = BCrypt.withDefaults().hashToString(12, request.getNewPassword().toCharArray());
                storedBasicAuthMechanism.setPassword(newHashedPassword);
                storedUser.getAuthenticationMechanism().setConfig((Object)storedBasicAuthMechanism);
                ((UserRepository)this.dao).createOrUpdate(uriInfo, storedUser);
                this.loginAttemptCache.recordSuccessfulLogin(securityContext.getUserPrincipal().getName());
                return Response.status((int)200).entity((Object)"Password Updated Successfully").build();
            }
            return Response.status((int)403).entity((Object)new ErrorMessage(403, "Old Password is not correct")).build();
        }
        this.authorizer.authorizeAdmin(securityContext, false);
        User storedUser = (User)((UserRepository)this.dao).getByName(uriInfo, request.getUsername(), new EntityUtil.Fields(fields, String.join((CharSequence)",", fields)));
        String newHashedPassword = BCrypt.withDefaults().hashToString(12, request.getNewPassword().toCharArray());
        BasicAuthMechanism storedBasicAuthMechanism = JsonUtils.convertValue(storedUser.getAuthenticationMechanism().getConfig(), BasicAuthMechanism.class);
        storedBasicAuthMechanism.setPassword(newHashedPassword);
        storedUser.getAuthenticationMechanism().setConfig((Object)storedBasicAuthMechanism);
        RestUtil.PutResponse<User> response = ((UserRepository)this.dao).createOrUpdate(uriInfo, storedUser);
        this.loginAttemptCache.recordSuccessfulLogin(request.getUsername());
        if (this.isEmailServiceEnabled) {
            try {
                this.sendInviteMailToUser(uriInfo, response.getEntity(), String.format("%s: Password Update", EmailUtil.getInstance().getEmailingEntity()), CreateUser.CreatePasswordType.ADMINCREATE, request.getNewPassword());
            }
            catch (Exception ex) {
                LOG.error("Error in sending invite to User" + ex.getMessage());
            }
        }
        return Response.status((Response.Status)response.getStatus()).entity((Object)"Password Updated Successfully").build();
    }

    @POST
    @Path(value="/checkEmailInUse")
    @Operation(operationId="checkEmailInUse", summary="Check if a mail is already in use", tags={"users"}, description="Check if a mail is already in use", responses={@ApiResponse(responseCode="200", description="Return true or false", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response checkEmailInUse(@Valid EmailRequest request) {
        boolean emailExists = ((UserRepository)this.dao).checkEmailAlreadyExists(request.getEmail());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)emailExists).build();
    }

    @POST
    @Path(value="/checkEmailVerified")
    @Operation(operationId="checkEmailIsVerified", summary="Check if a mail is verified", tags={"users"}, description="Check if a mail is already in use", responses={@ApiResponse(responseCode="200", description="Return true or false", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response checkEmailVerified(@Context UriInfo uriInfo, @Valid EmailRequest request) throws IOException {
        User user = (User)((UserRepository)this.dao).getByName(uriInfo, request.getEmail().split("@")[0], this.getFields("isEmailVerified"));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)user.getIsEmailVerified()).build();
    }

    @POST
    @Path(value="/login")
    @Operation(operationId="loginUserWithPwd", summary="Login User by Password", tags={"users"}, description="Login a user with Password", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTTokenExpiry.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response loginUserWithPassword(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid LoginRequest loginRequest) throws IOException, TemplateException {
        String userName;
        String string = userName = loginRequest.getEmail().contains("@") ? loginRequest.getEmail().split("@")[0] : loginRequest.getEmail();
        if (!this.loginAttemptCache.isLoginBlocked(userName)) {
            User storedUser;
            try {
                storedUser = (User)((UserRepository)this.dao).getByName(uriInfo, userName, new EntityUtil.Fields(List.of(USER_PROTECTED_FIELDS), USER_PROTECTED_FIELDS));
            }
            catch (Exception ex) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "You have entered an invalid username or password.")).build();
            }
            if (storedUser != null && Boolean.TRUE.equals(storedUser.getIsBot())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "You have entered an invalid username or password.")).build();
            }
            LinkedHashMap storedData = (LinkedHashMap)storedUser.getAuthenticationMechanism().getConfig();
            String requestPassword = loginRequest.getPassword();
            String storedHashPassword = (String)storedData.get("password");
            if (BCrypt.verifyer().verify((char[])requestPassword.toCharArray(), (CharSequence)storedHashPassword).verified) {
                RefreshToken refreshToken = this.createRefreshTokenForLogin(storedUser.getId());
                JWTAuthMechanism jwtAuthMechanism = this.jwtTokenGenerator.generateJWTToken(storedUser.getName(), storedUser.getEmail(), JWTTokenExpiry.OneHour, false);
                JwtResponse response = new JwtResponse();
                response.setTokenType("Bearer");
                response.setAccessToken(jwtAuthMechanism.getJWTToken());
                response.setRefreshToken(refreshToken.getToken().toString());
                response.setExpiryDuration(jwtAuthMechanism.getJWTTokenExpiresAt());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
            }
            this.loginAttemptCache.recordFailedLogin(userName);
            int failedLoginAttempt = this.loginAttemptCache.getUserFailedLoginCount(userName);
            if (failedLoginAttempt == 3) {
                this.sendAccountStatus(storedUser, "Multiple Failed Login Attempts.", "Login Blocked for 10 mins. Please change your password.");
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorMessage(Response.Status.UNAUTHORIZED.getStatusCode(), "You have entered an invalid username or password.")).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "Failed Login Attempts Exceeded. Please try after some time.")).build();
    }

    @POST
    @Path(value="/refresh")
    @Operation(operationId="refreshToken", summary="Provide access token to User with refresh token", tags={"users"}, description="Provide access token to User with refresh token", responses={@ApiResponse(responseCode="200", description="The user ", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWTTokenExpiry.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response refreshToken(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid TokenRefreshRequest refreshRequest) throws IOException {
        User storedUser = (User)((UserRepository)this.dao).getByName(uriInfo, securityContext.getUserPrincipal().getName(), this.getFields("*"));
        if (storedUser.getIsBot() != null && storedUser.getIsBot().booleanValue()) {
            throw new IllegalArgumentException("User are only allowed to login");
        }
        RefreshToken refreshToken = this.validateAndReturnNewRefresh(storedUser.getId(), refreshRequest);
        JWTAuthMechanism jwtAuthMechanism = this.jwtTokenGenerator.generateJWTToken(storedUser.getName(), storedUser.getEmail(), JWTTokenExpiry.OneHour, false);
        JwtResponse response = new JwtResponse();
        response.setTokenType("Bearer");
        response.setAccessToken(jwtAuthMechanism.getJWTToken());
        response.setRefreshToken(refreshToken.getToken().toString());
        response.setExpiryDuration(jwtAuthMechanism.getJWTTokenExpiresAt());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    private User getUser(SecurityContext securityContext, CreateUser create) {
        return new User().withId(UUID.randomUUID()).withName(create.getName()).withFullyQualifiedName(create.getName()).withEmail(create.getEmail()).withDescription(create.getDescription()).withDisplayName(create.getDisplayName()).withIsBot(create.getIsBot()).withIsAdmin(create.getIsAdmin()).withProfile(create.getProfile()).withTimezone(create.getTimezone()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withTeams(EntityUtil.toEntityReferences(create.getTeams(), "team")).withRoles(EntityUtil.toEntityReferences(create.getRoles(), "role"));
    }

    private void authorizeGenerateJWT(User user) {
        if (!Boolean.TRUE.equals(user.getIsBot())) {
            throw new IllegalArgumentException("Generating JWT token is only supported for bot users");
        }
    }

    public User registerUser(UriInfo uriInfo, RegistrationRequest newRegistrationRequest) throws IOException {
        String newRegistrationRequestEmail = newRegistrationRequest.getEmail();
        String[] tokens = newRegistrationRequest.getEmail().split("@");
        String userName = tokens[0];
        String emailDomain = tokens[1];
        Set allowedDomains = ConfigurationHolder.getInstance().getConfig(ConfigurationHolder.ConfigurationType.AUTHORIZER_CONFIG, AuthorizerConfiguration.class).getAllowedEmailRegistrationDomains();
        if (!allowedDomains.contains("all") && !allowedDomains.contains(emailDomain)) {
            LOG.error("Email with this Domain not allowed: " + newRegistrationRequestEmail);
            throw new BadRequestException("Email with the given domain is not allowed. Contact Administrator");
        }
        this.validateEmailAlreadyExists(newRegistrationRequestEmail);
        PasswordUtil.validatePassword(newRegistrationRequest.getPassword());
        LOG.info("Trying to register new user [" + newRegistrationRequestEmail + "]");
        User newUser = this.getUserFromRegistrationRequest(newRegistrationRequest);
        if (ConfigurationHolder.getInstance().getConfig(ConfigurationHolder.ConfigurationType.AUTHORIZER_CONFIG, AuthorizerConfiguration.class).getAdminPrincipals().contains(userName)) {
            newUser.setIsAdmin(Boolean.valueOf(true));
        }
        User registeredUser = ((UserRepository)this.dao).create(uriInfo, newUser);
        registeredUser.setAuthenticationMechanism(null);
        return registeredUser;
    }

    public void confirmEmailRegistration(UriInfo uriInfo, String emailToken) throws IOException {
        EmailVerificationToken emailVerificationToken = (EmailVerificationToken)this.tokenRepository.findByToken(emailToken);
        if (emailVerificationToken == null) {
            throw new EntityNotFoundException("Invalid Token. Please issue a new Request");
        }
        User registeredUser = (User)((UserRepository)this.dao).get(uriInfo, emailVerificationToken.getUserId(), this.userRepository.getFieldsWithUserAuth("*"));
        if (Boolean.TRUE.equals(registeredUser.getIsEmailVerified())) {
            LOG.info("User [{}] already registered.", (Object)emailToken);
            return;
        }
        if (emailVerificationToken.getExpiryDate().compareTo(Instant.now().toEpochMilli()) < 0) {
            throw new RuntimeException(String.format("Email Verification Token %s is expired. Please issue a new request for email verification", emailVerificationToken.getToken()));
        }
        registeredUser.setIsEmailVerified(Boolean.valueOf(true));
        ((UserRepository)this.dao).createOrUpdate(uriInfo, registeredUser);
        this.tokenRepository.deleteTokenByUserAndType(registeredUser.getId().toString(), TokenType.EMAIL_VERIFICATION.toString());
    }

    public User extendRegistrationToken(UriInfo uriInfo, String existingToken) throws IOException {
        EmailVerificationToken emailVerificationToken = (EmailVerificationToken)this.tokenRepository.findByToken(existingToken);
        User registeredUser = (User)((UserRepository)this.dao).get(uriInfo, emailVerificationToken.getUserId(), this.getFields("isEmailVerified"));
        if (Boolean.TRUE.equals(registeredUser.getIsEmailVerified())) {
            return registeredUser;
        }
        emailVerificationToken.setTokenStatus(EmailVerificationToken.TokenStatus.STATUS_PENDING);
        emailVerificationToken.setExpiryDate(Long.valueOf(Instant.now().plus(24L, ChronoUnit.HOURS).toEpochMilli()));
        this.tokenRepository.updateToken((TokenInterface)emailVerificationToken);
        return registeredUser;
    }

    private void sendEmailVerification(UriInfo uriInfo, User user) throws IOException, TemplateException {
        UUID mailVerificationToken = UUID.randomUUID();
        EmailVerificationToken emailVerificationToken = TokenUtil.getEmailVerificationToken(user.getId(), mailVerificationToken);
        LOG.info("Generated Email verification token [" + mailVerificationToken + "]");
        String emailVerificationLink = String.format("%s://%s/users/registrationConfirmation?user=%s&token=%s", uriInfo.getRequestUri().getScheme(), uriInfo.getRequestUri().getHost(), user.getFullyQualifiedName(), mailVerificationToken);
        HashMap<String, String> templatePopulator = new HashMap<String, String>();
        templatePopulator.put("entity", EmailUtil.getInstance().getEmailingEntity());
        templatePopulator.put("supportUrl", EmailUtil.getInstance().getSupportUrl());
        templatePopulator.put("userName", user.getName());
        templatePopulator.put("userEmailTokenVerificationLink", emailVerificationLink);
        templatePopulator.put("expirationTime", "24");
        EmailUtil.getInstance().sendMail(EmailUtil.getInstance().getEmailVerificationSubject(), templatePopulator, user.getEmail(), "/emailTemplates", "email-verification.ftl");
        this.tokenRepository.insertToken((TokenInterface)emailVerificationToken);
    }

    private void sendAccountStatus(User user, String action, String status) throws IOException, TemplateException {
        HashMap<String, String> templatePopulator = new HashMap<String, String>();
        templatePopulator.put("entity", EmailUtil.getInstance().getEmailingEntity());
        templatePopulator.put("supportUrl", EmailUtil.getInstance().getSupportUrl());
        templatePopulator.put("userName", user.getName());
        templatePopulator.put("action", action);
        templatePopulator.put("actionStatus", status);
        EmailUtil.getInstance().sendMail(EmailUtil.getInstance().getAccountStatusChangeSubject(), templatePopulator, user.getEmail(), "/emailTemplates", "account-activity-change.ftl");
    }

    private void sendPasswordResetLink(UriInfo uriInfo, User user, String subject, String templateFilePath) throws IOException, TemplateException {
        UUID mailVerificationToken = UUID.randomUUID();
        PasswordResetToken resetToken = TokenUtil.getPasswordResetToken(user.getId(), mailVerificationToken);
        LOG.info("Generated Password Reset verification token [" + mailVerificationToken + "]");
        String passwordResetLink = String.format("%s://%s/users/password/reset?user=%s&token=%s", uriInfo.getRequestUri().getScheme(), uriInfo.getRequestUri().getHost(), user.getFullyQualifiedName(), mailVerificationToken);
        HashMap<String, String> templatePopulator = new HashMap<String, String>();
        templatePopulator.put("entity", EmailUtil.getInstance().getEmailingEntity());
        templatePopulator.put("supportUrl", EmailUtil.getInstance().getSupportUrl());
        templatePopulator.put("userName", user.getName());
        templatePopulator.put("userResetPasswordLink", passwordResetLink);
        templatePopulator.put("expirationTime", "60");
        EmailUtil.getInstance().sendMail(subject, templatePopulator, user.getEmail(), "/emailTemplates", templateFilePath);
        this.tokenRepository.deleteTokenByUserAndType(user.getId().toString(), TokenType.PASSWORD_RESET.toString());
        this.tokenRepository.insertToken((TokenInterface)resetToken);
    }

    private void sendInviteMailToUser(UriInfo uriInfo, User user, String subject, CreateUser.CreatePasswordType requestType, String pwd) throws TemplateException, IOException {
        switch (requestType) {
            case ADMINCREATE: {
                HashMap<String, String> templatePopulator = new HashMap<String, String>();
                templatePopulator.put("entity", EmailUtil.getInstance().getEmailingEntity());
                templatePopulator.put("supportUrl", EmailUtil.getInstance().getSupportUrl());
                templatePopulator.put("userName", user.getName());
                templatePopulator.put("password", pwd);
                templatePopulator.put("applicationLoginLink", EmailUtil.getInstance().getOMUrl());
                try {
                    EmailUtil.getInstance().sendMail(subject, templatePopulator, user.getEmail(), "/emailTemplates", "invite-randompwd.ftl");
                }
                catch (Exception ex) {
                    LOG.error("Failed in sending Mail to user [{}]. Reason : {}", (Object)user.getEmail(), (Object)ex.getMessage());
                }
                break;
            }
            case USERCREATE: {
                this.sendPasswordResetLink(uriInfo, user, subject, "invite-createPassword.ftl");
                break;
            }
            default: {
                LOG.error("Invalid Password Create Type");
            }
        }
    }

    public RefreshToken createRefreshTokenForLogin(UUID currentUserId) throws JsonProcessingException {
        this.tokenRepository.deleteTokenByUserAndType(currentUserId.toString(), TokenType.REFRESH_TOKEN.toString());
        RefreshToken newRefreshToken = TokenUtil.getRefreshToken(currentUserId, UUID.randomUUID());
        this.tokenRepository.insertToken((TokenInterface)newRefreshToken);
        return newRefreshToken;
    }

    public void verifyPasswordResetTokenExpiry(PasswordResetToken token) {
        if (token.getExpiryDate().compareTo(Instant.now().toEpochMilli()) < 0) {
            throw new RuntimeException("Password Reset Token" + token.getToken() + "Expired token. Please issue a new request");
        }
        if (Boolean.FALSE.equals(token.getIsActive())) {
            throw new RuntimeException("Password Reset Token" + token.getToken() + "Token was marked inactive");
        }
    }

    public RefreshToken validateAndReturnNewRefresh(UUID currentUserId, TokenRefreshRequest tokenRefreshRequest) throws JsonProcessingException {
        String requestRefreshToken = tokenRefreshRequest.getRefreshToken();
        RefreshToken storedRefreshToken = (RefreshToken)this.tokenRepository.findByToken(requestRefreshToken);
        if (storedRefreshToken == null) {
            throw new RuntimeException("Invalid Refresh Token");
        }
        if (storedRefreshToken.getExpiryDate().compareTo(Instant.now().toEpochMilli()) < 0) {
            throw new RuntimeException("Expired token. Please login again : " + storedRefreshToken.getToken().toString());
        }
        this.tokenRepository.deleteTokenByUserAndType(currentUserId.toString(), TokenType.REFRESH_TOKEN.toString());
        RefreshToken newRefreshToken = TokenUtil.getRefreshToken(currentUserId, UUID.randomUUID());
        this.tokenRepository.insertToken((TokenInterface)newRefreshToken);
        return newRefreshToken;
    }

    private User getUserFromRegistrationRequest(RegistrationRequest create) {
        String username = create.getEmail().split("@")[0];
        String hashedPwd = BCrypt.withDefaults().hashToString(12, create.getPassword().toCharArray());
        BasicAuthMechanism newAuthMechanism = new BasicAuthMechanism().withPassword(hashedPwd);
        return new User().withId(UUID.randomUUID()).withName(username).withFullyQualifiedName(username).withEmail(create.getEmail()).withDisplayName(create.getFirstName() + create.getLastName()).withIsBot(Boolean.valueOf(false)).withUpdatedBy(username).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withIsEmailVerified(Boolean.valueOf(false)).withAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)newAuthMechanism));
    }

    public void validateEmailAlreadyExists(String email) {
        if (((UserRepository)this.dao).checkEmailAlreadyExists(email)) {
            throw new RuntimeException("User with Email Already Exists");
        }
    }

    private Response createOrUpdateBot(User user, CreateUser create, UriInfo uriInfo, SecurityContext securityContext) throws IOException {
        User original = this.retrieveBotUser(user, uriInfo);
        String botName = create.getBotName();
        Object bot = this.retrieveBot(botName);
        if (!this.botHasRelationshipWithUser((EntityInterface)bot, original) && original != null && this.userHasRelationshipWithAnyBot(original, (EntityInterface)bot)) {
            List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(original);
            bot = Entity.getEntityRepository("bot").get(null, ((CollectionDAO.EntityRelationshipRecord)userBotRelationship.stream().findFirst().orElseThrow()).getId(), EntityUtil.Fields.EMPTY_FIELDS);
            throw new IllegalArgumentException(String.format("Bot user [%s] is already used by [%s] bot.", user.getName(), bot.getName()));
        }
        this.addAuthMechanismToBot(user, create, uriInfo);
        RestUtil.PutResponse<User> response = ((UserRepository)this.dao).createOrUpdate(uriInfo, user);
        this.decryptOrNullify(securityContext, response.getEntity());
        return response.toResponse();
    }

    private EntityInterface retrieveBot(String botName) {
        try {
            return Entity.getEntityRepository("bot").getByName(null, botName, EntityUtil.Fields.EMPTY_FIELDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean userHasRelationshipWithAnyBot(User user, EntityInterface botUser) {
        List<CollectionDAO.EntityRelationshipRecord> userBotRelationship = this.retrieveBotRelationshipsFor(user);
        return !userBotRelationship.isEmpty() && (botUser == null || userBotRelationship.stream().anyMatch(relationship -> !relationship.getId().equals(botUser.getId())));
    }

    private List<CollectionDAO.EntityRelationshipRecord> retrieveBotRelationshipsFor(User user) {
        return ((UserRepository)this.dao).findFrom(user.getId(), "user", Relationship.CONTAINS, "bot");
    }

    private boolean botHasRelationshipWithUser(EntityInterface bot, User user) {
        if (bot == null || user == null) {
            return false;
        }
        List<CollectionDAO.EntityRelationshipRecord> botUserRelationships = this.retrieveBotRelationshipsFor(bot);
        return !botUserRelationships.isEmpty() && botUserRelationships.get(0).getId().equals(user.getId());
    }

    private List<CollectionDAO.EntityRelationshipRecord> retrieveBotRelationshipsFor(EntityInterface bot) {
        return ((UserRepository)this.dao).findTo(bot.getId(), "bot", Relationship.CONTAINS, "user");
    }

    private void addAuthMechanismToBot(User user, @Valid CreateUser create, UriInfo uriInfo) {
        AuthenticationMechanism authMechanism;
        if (!Boolean.TRUE.equals(user.getIsBot())) {
            throw new IllegalArgumentException("Authentication mechanism change is only supported for bot users");
        }
        if (this.isValidAuthenticationMechanism(create)) {
            authMechanism = create.getAuthenticationMechanism();
            AuthenticationMechanism.AuthType authType = authMechanism.getAuthType();
            switch (authType) {
                case JWT: {
                    User original = this.retrieveBotUser(user, uriInfo);
                    if (original != null && !this.secretsManager.isLocal() && authMechanism.getConfig() != null) {
                        original.getAuthenticationMechanism().setConfig(this.secretsManager.encryptOrDecryptBotUserCredentials(user.getName(), authMechanism.getConfig(), false));
                    }
                    if (original == null || !this.hasAJWTAuthMechanism(original.getAuthenticationMechanism())) {
                        JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class);
                        authMechanism.setConfig((Object)this.jwtTokenGenerator.generateJWTToken(user, jwtAuthMechanism.getJWTTokenExpiry()));
                        break;
                    }
                    authMechanism = original.getAuthenticationMechanism();
                    break;
                }
                case SSO: {
                    SSOAuthMechanism ssoAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), SSOAuthMechanism.class);
                    authMechanism.setConfig((Object)ssoAuthMechanism);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authType.value()));
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("Authentication mechanism is empty bot user: [%s]", user.getName()));
        }
        user.setAuthenticationMechanism(authMechanism);
    }

    @Nullable
    private User retrieveBotUser(User user, UriInfo uriInfo) {
        User original;
        try {
            original = (User)((UserRepository)this.dao).getByName(uriInfo, user.getFullyQualifiedName(), new EntityUtil.Fields(List.of(USER_PROTECTED_FIELDS)));
        }
        catch (IOException | EntityNotFoundException exc) {
            LOG.debug(String.format("User not found when adding auth mechanism for: [%s]", user.getName()));
            original = null;
        }
        return original;
    }

    private void addAuthMechanismToUser(User user, @Valid CreateUser create) {
        if (!create.getPassword().equals(create.getConfirmPassword())) {
            throw new IllegalArgumentException("Password and Confirm Password should be same.");
        }
        PasswordUtil.validatePassword(create.getPassword());
        String newHashedPwd = BCrypt.withDefaults().hashToString(12, create.getPassword().toCharArray());
        BasicAuthMechanism newAuthForUser = new BasicAuthMechanism().withPassword(newHashedPwd);
        user.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)newAuthForUser));
    }

    private boolean hasAJWTAuthMechanism(AuthenticationMechanism authMechanism) {
        if (authMechanism != null && AuthenticationMechanism.AuthType.JWT.equals((Object)authMechanism.getAuthType())) {
            JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class);
            return jwtAuthMechanism != null && jwtAuthMechanism.getJWTToken() != null && !"".equals(jwtAuthMechanism.getJWTToken());
        }
        return false;
    }

    private boolean isValidAuthenticationMechanism(CreateUser create) {
        if (create.getAuthenticationMechanism() == null) {
            return false;
        }
        if (create.getAuthenticationMechanism().getConfig() != null && create.getAuthenticationMechanism().getAuthType() != null) {
            return true;
        }
        throw new IllegalArgumentException(String.format("Incomplete authentication mechanism parameters for bot user: [%s]", create.getName()));
    }

    private User decryptOrNullify(SecurityContext securityContext, User user) {
        if (Boolean.TRUE.equals(user.getIsBot()) && user.getAuthenticationMechanism() != null) {
            try {
                this.authorizer.authorize(securityContext, new OperationContext(this.entityType, MetadataOperation.VIEW_ALL), this.getResourceContextById(user.getId()), this.secretsManager.isLocal());
            }
            catch (IOException | AuthorizationException e) {
                user.getAuthenticationMechanism().setConfig(null);
                return user;
            }
            user.getAuthenticationMechanism().setConfig(this.secretsManager.encryptOrDecryptBotUserCredentials(user.getName(), user.getAuthenticationMechanism().getConfig(), false));
            return user;
        }
        return user;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public static class UserList
    extends ResultList<User> {
        public UserList() {
        }

        public UserList(List<User> users, String beforeCursor, String afterCursor, int total) {
            super(users, beforeCursor, afterCursor, total);
        }
    }
}

