/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import org.apache.logging.log4j.util.Strings;
import org.openmetadata.schema.services.connections.metadata.SecretsManagerProvider;
import org.openmetadata.service.secrets.SecretsManagerConfiguration;
import org.openmetadata.service.secrets.ThirdPartySecretsManager;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public abstract class AWSBasedSecretsManager
extends ThirdPartySecretsManager {
    public static final String ACCESS_KEY_ID = "accessKeyId";
    public static final String SECRET_ACCESS_KEY = "secretAccessKey";
    public static final String REGION = "region";

    protected AWSBasedSecretsManager(SecretsManagerProvider awsProvider, SecretsManagerConfiguration config, String clusterPrefix) {
        super(awsProvider, clusterPrefix);
        if (config != null && config.getParameters() != null && !Strings.isBlank((String)config.getParameters().getOrDefault(REGION, ""))) {
            String region = config.getParameters().getOrDefault(REGION, "");
            String accessKeyId = config.getParameters().getOrDefault(ACCESS_KEY_ID, "");
            String secretAccessKey = config.getParameters().getOrDefault(SECRET_ACCESS_KEY, "");
            Object credentialsProvider = Strings.isBlank((String)accessKeyId) && Strings.isBlank((String)secretAccessKey) ? DefaultCredentialsProvider.create() : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            this.initClientWithCredentials(region, (AwsCredentialsProvider)credentialsProvider);
        } else {
            this.initClientWithoutCredentials();
        }
    }

    abstract void initClientWithoutCredentials();

    abstract void initClientWithCredentials(String var1, AwsCredentialsProvider var2);
}

