/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.services.connections.metadata.SecretsManagerProvider;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.secrets.ThirdPartySecretsManager;

public class InMemorySecretsManager
extends ThirdPartySecretsManager {
    private static InMemorySecretsManager INSTANCE;
    private final Map<String, String> secretsMap = new HashMap<String, String>();

    protected InMemorySecretsManager(SecretsManagerProvider secretsManagerProvider, String clusterPrefix) {
        super(secretsManagerProvider, clusterPrefix);
    }

    public static InMemorySecretsManager getInstance(String clusterPrefix) {
        if (INSTANCE == null) {
            INSTANCE = new InMemorySecretsManager(SecretsManagerProvider.IN_MEMORY, clusterPrefix);
        }
        return INSTANCE;
    }

    @Override
    void storeSecret(String secretName, String secretValue) {
        this.secretsMap.put(secretName, secretValue);
    }

    @Override
    void updateSecret(String secretName, String secretValue) {
        this.storeSecret(secretName, secretValue);
    }

    @Override
    String getSecret(String secretName) {
        String value = this.secretsMap.getOrDefault(secretName, null);
        if (value == null) {
            throw new SecretsManagerException(String.format("Key [%s] not found in in-memory secrets manager", secretName));
        }
        return value;
    }

    public Map<String, String> getSecretsMap() {
        return this.secretsMap;
    }
}

