/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.openmetadata.schema.api.services.ingestionPipelines.TestServiceConnection;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.DatabaseServiceMetadataPipeline;
import org.openmetadata.schema.services.connections.metadata.SecretsManagerProvider;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.util.JsonUtils;

public abstract class SecretsManager {
    private final String clusterPrefix;
    private final SecretsManagerProvider secretsManagerProvider;

    protected SecretsManager(SecretsManagerProvider secretsManagerProvider, String clusterPrefix) {
        this.secretsManagerProvider = secretsManagerProvider;
        this.clusterPrefix = clusterPrefix;
    }

    public boolean isLocal() {
        return false;
    }

    public abstract Object encryptOrDecryptServiceConnectionConfig(Object var1, String var2, String var3, ServiceType var4, boolean var5);

    abstract Object encryptOrDecryptDbtConfigSource(Object var1, String var2, boolean var3);

    public void encryptOrDecryptDbtConfigSource(IngestionPipeline ingestionPipeline, boolean encrypt) {
        this.encryptOrDecryptDbtConfigSource(ingestionPipeline, ingestionPipeline.getService(), encrypt);
    }

    public void encryptOrDecryptDbtConfigSource(IngestionPipeline ingestionPipeline, EntityReference service, boolean encrypt) {
        if (service.getType().equals("databaseService") && ingestionPipeline.getPipelineType().equals((Object)PipelineType.METADATA)) {
            DatabaseServiceMetadataPipeline databaseServiceMetadataPipeline = JsonUtils.convertValue(ingestionPipeline.getSourceConfig().getConfig(), DatabaseServiceMetadataPipeline.class);
            databaseServiceMetadataPipeline.setDbtConfigSource(this.encryptOrDecryptDbtConfigSource(databaseServiceMetadataPipeline.getDbtConfigSource(), service.getName(), encrypt));
            ingestionPipeline.getSourceConfig().setConfig((Object)databaseServiceMetadataPipeline);
        }
    }

    protected String getSecretSeparator() {
        return "/";
    }

    protected boolean startsWithSeparator() {
        return true;
    }

    protected String buildSecretId(String ... secretIdValues) {
        StringBuilder format = new StringBuilder();
        format.append(this.startsWithSeparator() ? this.getSecretSeparator() : "");
        format.append(this.clusterPrefix);
        for (String secretIdValue : List.of(secretIdValues)) {
            if (Objects.isNull(secretIdValue)) {
                throw new SecretsManagerException("Cannot build a secret id with null values.");
            }
            format.append(this.getSecretSeparator());
            format.append("%s");
        }
        return String.format(format.toString(), secretIdValues).toLowerCase();
    }

    protected Class<?> createConnectionConfigClass(String connectionType, String connectionPackage) throws ClassNotFoundException {
        String clazzName = "org.openmetadata.schema.services.connections." + connectionPackage + "." + connectionType + "Connection";
        return Class.forName(clazzName);
    }

    protected String extractConnectionPackageName(ServiceType serviceType) {
        return serviceType.value().toLowerCase(Locale.ROOT);
    }

    public abstract Object storeTestConnectionObject(TestServiceConnection var1);

    public abstract Object encryptOrDecryptBotUserCredentials(String var1, Object var2, boolean var3);

    public abstract Object encryptOrDecryptBotCredentials(String var1, String var2, boolean var3);

    public void validateServiceConnection(Object connectionConfig, String connectionType, ServiceType serviceType) {
        try {
            Class<?> clazz = this.createConnectionConfigClass(connectionType, this.extractConnectionPackageName(serviceType));
            JsonUtils.readValue(JsonUtils.pojoToJson(connectionConfig), clazz);
        }
        catch (Exception exception) {
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to construct connection instance of %s", connectionType));
        }
    }

    public String getClusterPrefix() {
        return this.clusterPrefix;
    }

    public SecretsManagerProvider getSecretsManagerProvider() {
        return this.secretsManagerProvider;
    }
}

