/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import org.openmetadata.schema.services.connections.metadata.SecretsManagerProvider;
import org.openmetadata.service.secrets.AWSSSMSecretsManager;
import org.openmetadata.service.secrets.AWSSecretsManager;
import org.openmetadata.service.secrets.InMemorySecretsManager;
import org.openmetadata.service.secrets.NoopSecretsManager;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerConfiguration;

public class SecretsManagerFactory {
    private SecretsManagerFactory() {
    }

    public static SecretsManager createSecretsManager(SecretsManagerConfiguration config, String clusterName) {
        SecretsManagerProvider secretManager = config != null && config.getSecretsManager() != null ? config.getSecretsManager() : SecretsManagerConfiguration.DEFAULT_SECRET_MANAGER;
        switch (secretManager) {
            case NOOP: {
                return NoopSecretsManager.getInstance(clusterName);
            }
            case AWS: {
                return AWSSecretsManager.getInstance(config, clusterName);
            }
            case AWS_SSM: {
                return AWSSSMSecretsManager.getInstance(config, clusterName);
            }
            case IN_MEMORY: {
                return InMemorySecretsManager.getInstance(clusterName);
            }
        }
        throw new IllegalArgumentException("Not implemented secret manager store: " + secretManager);
    }
}

