/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.service.util.ConfigurationHolder;

public class LoginAttemptCache {
    private final int MAX_ATTEMPT;
    private final LoadingCache<String, Integer> attemptsCache;

    public LoginAttemptCache() {
        LoginConfiguration loginConfiguration = ConfigurationHolder.getInstance().getConfig(ConfigurationHolder.ConfigurationType.LOGIN_CONFIG, LoginConfiguration.class);
        this.MAX_ATTEMPT = 3;
        this.attemptsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)loginConfiguration.getAccessBlockTime().intValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String key) {
                return 0;
            }
        });
    }

    public LoginAttemptCache(int maxAttempt, int blockTimeInSec) {
        this.MAX_ATTEMPT = maxAttempt;
        this.attemptsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)blockTimeInSec, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String key) {
                return 0;
            }
        });
    }

    public void recordSuccessfulLogin(String key) {
        this.attemptsCache.invalidate((Object)key);
    }

    public void recordFailedLogin(String key) {
        int attempts = 0;
        try {
            attempts = (Integer)this.attemptsCache.get((Object)key);
        }
        catch (ExecutionException e) {
            attempts = 0;
        }
        this.attemptsCache.put((Object)key, (Object)(++attempts));
    }

    public boolean isLoginBlocked(String key) {
        try {
            return (Integer)this.attemptsCache.get((Object)key) >= this.MAX_ATTEMPT;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public int getUserFailedLoginCount(String key) {
        try {
            return (Integer)this.attemptsCache.get((Object)key);
        }
        catch (ExecutionException e) {
            return -1;
        }
    }
}

