/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyCache {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyCache.class);
    private static final PolicyCache INSTANCE = new PolicyCache();
    private static volatile boolean INITIALIZED = false;
    protected static LoadingCache<UUID, List<CompiledRule>> POLICY_CACHE;
    private static EntityRepository<Policy> POLICY_REPOSITORY;
    private static EntityUtil.Fields FIELDS;

    public static PolicyCache getInstance() {
        return INSTANCE;
    }

    public static void initialize() {
        if (!INITIALIZED) {
            POLICY_CACHE = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new PolicyLoader());
            POLICY_REPOSITORY = Entity.getEntityRepository("policy");
            FIELDS = POLICY_REPOSITORY.getFields("rules");
            INITIALIZED = true;
        }
    }

    public List<CompiledRule> getPolicyRules(UUID policyId) {
        try {
            return (List)POLICY_CACHE.get((Object)policyId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public void invalidatePolicy(UUID policyId) {
        try {
            POLICY_CACHE.invalidate((Object)policyId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for policy {}", (Object)policyId, (Object)ex);
        }
    }

    protected List<CompiledRule> getRules(Policy policy) {
        ArrayList<CompiledRule> rules = new ArrayList<CompiledRule>();
        for (Rule r : policy.getRules()) {
            rules.add(new CompiledRule(r));
        }
        return rules;
    }

    public static void cleanUp() {
        POLICY_CACHE.cleanUp();
        INITIALIZED = false;
    }

    static class PolicyLoader
    extends CacheLoader<UUID, List<CompiledRule>> {
        PolicyLoader() {
        }

        public List<CompiledRule> load(@CheckForNull UUID policyId) throws IOException {
            Policy policy = POLICY_REPOSITORY.get(null, policyId, FIELDS);
            LOG.info("Loaded policy {}:{}", (Object)policy.getName(), (Object)policy.getId());
            return PolicyCache.getInstance().getRules(policy);
        }
    }
}

