/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.io.IOException;
import java.util.List;
import org.openmetadata.schema.Function;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RuleEvaluator.class);
    private final SubjectContext.PolicyContext policyContext;
    private final SubjectContext subjectContext;
    private final ResourceContextInterface resourceContext;

    public RuleEvaluator(SubjectContext.PolicyContext policyContext, SubjectContext subjectContext, ResourceContextInterface resourceContext) {
        this.policyContext = policyContext;
        this.subjectContext = subjectContext;
        this.resourceContext = resourceContext;
    }

    @Function(name="noOwner", input="none", description="Returns true if the entity being accessed has no owner", examples={"noOwner()", "!noOwner", "noOwner() || isOwner()"})
    public boolean noOwner() throws IOException {
        return this.resourceContext != null && this.resourceContext.getOwner() == null;
    }

    @Function(name="isOwner", input="none", description="Returns true if the logged in user is the owner of the entity being accessed", examples={"isOwner()", "!isOwner", "noOwner() || isOwner()"})
    public boolean isOwner() throws IOException {
        return this.subjectContext != null && this.subjectContext.isOwner(this.resourceContext.getOwner());
    }

    @Function(name="matchAllTags", input="List of comma separated tag or glossary fully qualified names", description="Returns true if the entity being accessed has all the tags given as input", examples={"matchAllTags('PersonalData.Personal', 'Tier.Tier1', 'Business Glossary.Clothing')"})
    public boolean matchAllTags(String ... tagFQNs) throws IOException {
        if (this.resourceContext == null) {
            return false;
        }
        List<TagLabel> tags = this.resourceContext.getTags();
        for (String tagFQN : tagFQNs) {
            TagLabel found = tags.stream().filter(t -> t.getTagFQN().equals(tagFQN)).findAny().orElse(null);
            if (found != null) continue;
            return false;
        }
        return true;
    }

    @Function(name="matchAnyTag", input="List of comma separated tag or glossary fully qualified names", description="Returns true if the entity being accessed has at least one of the tags given as input", examples={"matchAnyTags('PersonalData.Personal', 'Tier.Tier1', 'Business Glossary.Clothing')"})
    public boolean matchAnyTag(List<String> tagFQNs) throws IOException {
        if (this.resourceContext == null) {
            return false;
        }
        List<TagLabel> tags = this.resourceContext.getTags();
        for (String tagFQN : tagFQNs) {
            TagLabel found = tags.stream().filter(t -> t.getTagFQN().equals(tagFQN)).findAny().orElse(null);
            if (found == null) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchTeam", input="None", description="Returns true if the user and the resource belongs to the team hierarchy where this policy isattached. This allows restricting permissions to a resource to the members of the team hierarchy.", examples={"matchTeam()"}, resourceBased=true)
    public boolean matchTeam() throws IOException {
        if (this.resourceContext == null || this.resourceContext.getOwner() == null) {
            return true;
        }
        if (this.policyContext == null || !this.policyContext.getEntityType().equals("team")) {
            return true;
        }
        return this.subjectContext.isTeamAsset(this.policyContext.getEntityName(), this.resourceContext.getOwner()) && this.subjectContext.isUserUnderTeam(this.policyContext.getEntityName());
    }
}

