/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectCache.class);
    private static SubjectCache INSTANCE;
    private static volatile boolean INITIALIZED;
    protected static LoadingCache<String, SubjectContext> USER_CACHE;
    protected static LoadingCache<UUID, Team> TEAM_CACHE;
    protected static EntityRepository<User> USER_REPOSITORY;
    protected static EntityUtil.Fields USER_FIELDS;
    protected static EntityRepository<Team> TEAM_REPOSITORY;
    protected static EntityUtil.Fields TEAM_FIELDS;

    public static void initialize() {
        if (!INITIALIZED) {
            USER_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new UserLoader());
            TEAM_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new TeamLoader());
            USER_REPOSITORY = Entity.getEntityRepository("user");
            USER_FIELDS = USER_REPOSITORY.getFields("roles, teams");
            TEAM_REPOSITORY = Entity.getEntityRepository("team");
            TEAM_FIELDS = TEAM_REPOSITORY.getFields("defaultRoles, policies, parents");
            INSTANCE = new SubjectCache();
            INITIALIZED = true;
            LOG.info("Subject cache is initialized");
        } else {
            LOG.info("Subject cache is already initialized");
        }
    }

    public static SubjectCache getInstance() {
        return INSTANCE;
    }

    public SubjectContext getSubjectContext(String userName) throws EntityNotFoundException {
        try {
            return (SubjectContext)USER_CACHE.get((Object)userName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            ex.printStackTrace();
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public Team getTeam(UUID teamId) throws EntityNotFoundException {
        try {
            return (Team)TEAM_CACHE.get((Object)teamId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            return null;
        }
    }

    public static void cleanUp() {
        LOG.info("Subject cache is cleaned up");
        USER_CACHE.invalidateAll();
        TEAM_CACHE.invalidateAll();
        INITIALIZED = false;
    }

    public void invalidateUser(String userName) {
        try {
            USER_CACHE.invalidate((Object)userName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for user {}", (Object)userName, (Object)ex);
        }
    }

    public void invalidateTeam(UUID teamId) {
        try {
            TEAM_CACHE.invalidate((Object)teamId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for team {}", (Object)teamId, (Object)ex);
        }
    }

    public List<EntityReference> getInheritedRolesForUser(String userName) {
        return this.getRolesForTeams(this.getSubjectContext(userName).getTeams());
    }

    public List<EntityReference> getRolesForTeams(List<EntityReference> teams) {
        ArrayList<EntityReference> roles = new ArrayList<EntityReference>();
        for (EntityReference teamRef : CommonUtil.listOrEmpty(teams)) {
            Team team = this.getTeam(teamRef.getId());
            if (team == null) continue;
            roles.addAll(team.getDefaultRoles());
            roles.addAll(this.getRolesForTeams(team.getParents()));
        }
        return roles.stream().distinct().collect(Collectors.toList());
    }

    static {
        INITIALIZED = false;
    }

    static class UserLoader
    extends CacheLoader<String, SubjectContext> {
        UserLoader() {
        }

        public SubjectContext load(@CheckForNull String userName) throws IOException {
            User user = USER_REPOSITORY.getByName(null, userName, USER_FIELDS);
            LOG.info("Loaded user {}:{}", (Object)user.getName(), (Object)user.getId());
            return new SubjectContext(user);
        }
    }

    static class TeamLoader
    extends CacheLoader<UUID, Team> {
        TeamLoader() {
        }

        public Team load(@NonNull UUID teamId) throws IOException {
            if (teamId == null) {
                throw new NullPointerException("teamId is marked non-null but is null");
            }
            Team team = TEAM_REPOSITORY.get(null, teamId, TEAM_FIELDS);
            LOG.info("Loaded team {}:{}", (Object)team.getName(), (Object)team.getId());
            return team;
        }
    }
}

